/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;

public class SubjectHelper {
    private static Subject unauthenticatedSubject = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$SubjectHelper == null ? (class$com$ibm$ws$security$auth$SubjectHelper = SubjectHelper.class$("com.ibm.ws.security.auth.SubjectHelper")) : class$com$ibm$ws$security$auth$SubjectHelper), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$SingleSignonToken;
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$AuthorizationToken;
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$AuthenticationToken;
    static /* synthetic */ Class class$com$ibm$websphere$security$auth$WSPrincipal;
    static /* synthetic */ Class class$com$ibm$ws$security$auth$SubjectHelper;

    public static Subject createSubjectFromWSCredential(final WSCredential wSCredential) {
        if (wSCredential == null) {
            return null;
        }
        try {
            final WSPrincipal wSPrincipal = SubjectHelper.createPrincipal(wSCredential);
            final Subject subject = new Subject();
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    if (!subject.getPrincipals().contains(wSPrincipal)) {
                        subject.getPrincipals().add(wSPrincipal);
                    }
                    if (!subject.getPublicCredentials().contains(wSCredential)) {
                        subject.getPublicCredentials().add(wSCredential);
                    }
                    return null;
                }
            });
            return subject;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.createSubjectFromWSCredential", (String)"110");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating Subject from WSCredential.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    public static WSCredential getWSCredentialFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        WSCredential wSCredential = null;
        try {
            wSCredential = (WSCredential)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Set<Object> set = subject.getPublicCredentials();
                    if (set != null && set.size() > 0) {
                        Iterator<Object> iterator = set.iterator();
                        while (iterator.hasNext()) {
                            Object object = iterator.next();
                            if (object == null || !(object instanceof WSCredential)) continue;
                            return (WSCredential)object;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WSCredential not present in Subject.");
                    }
                    return null;
                }
            });
            return wSCredential;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.getWSCredentialFromSubject", (String)"162");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting WSCredential from Subject.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    public static SingleSignonToken getDefaultSSOTokenFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        SingleSignonToken singleSignonToken = null;
        try {
            singleSignonToken = (SingleSignonToken)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Iterator iterator = subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$SingleSignonToken == null ? (class$com$ibm$wsspi$security$token$SingleSignonToken = SubjectHelper.class$("com.ibm.wsspi.security.token.SingleSignonToken")) : class$com$ibm$wsspi$security$token$SingleSignonToken).iterator();
                    while (iterator.hasNext()) {
                        SingleSignonToken singleSignonToken = (SingleSignonToken)iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Processing SSO token with name: " + singleSignonToken.getName()));
                        }
                        if (!singleSignonToken.getName().equals("LtpaToken")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Found default SSO token.");
                        }
                        return singleSignonToken;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Could not find default SSO token.");
                    }
                    return null;
                }
            });
            return singleSignonToken;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.getDefaultSSOTokenFromSubject", (String)"211");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SingleSignonToken from Subject.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    public static AuthorizationToken getDefaultAuthzTokenFromSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        AuthorizationToken authorizationToken = null;
        try {
            Iterator iterator = subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$AuthorizationToken == null ? (class$com$ibm$wsspi$security$token$AuthorizationToken = SubjectHelper.class$("com.ibm.wsspi.security.token.AuthorizationToken")) : class$com$ibm$wsspi$security$token$AuthorizationToken).iterator();
            while (iterator.hasNext()) {
                authorizationToken = (AuthorizationToken)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing AUTHZ token with name: " + authorizationToken.getName()));
                }
                if (!authorizationToken.getName().equals("com.ibm.ws.security.token.AuthorizationTokenImpl")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found default AuthorizationToken.");
                }
                return authorizationToken;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not find default Authorization token.");
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.getDefaultAuthzTokenFromSubject", (String)"252");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting AuthorizationToken from Subject.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    public static AuthenticationToken getDefaultAuthTokenFromSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        AuthenticationToken authenticationToken = null;
        try {
            Iterator iterator = subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$AuthenticationToken == null ? (class$com$ibm$wsspi$security$token$AuthenticationToken = SubjectHelper.class$("com.ibm.wsspi.security.token.AuthenticationToken")) : class$com$ibm$wsspi$security$token$AuthenticationToken).iterator();
            while (iterator.hasNext()) {
                authenticationToken = (AuthenticationToken)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing AUTH token with name: " + authenticationToken.getName()));
                }
                if (!authenticationToken.getName().equals("com.ibm.ws.security.token.AuthenticationTokenImpl")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found default AuthenticationToken.");
                }
                return authenticationToken;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not find default AuthenticationToken.");
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.getDefaultAuthzTokenFromSubject", (String)"293");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting AuthenticationToken from Subject.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    public static boolean isWSCredentialValid(Subject subject) {
        return SubjectHelper.isWSCredentialValid(subject, false);
    }

    public static boolean isWSCredentialValid(final Subject subject, boolean bl) {
        if (subject == null) {
            return false;
        }
        WSCredential wSCredential = null;
        try {
            wSCredential = (WSCredential)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Iterator<Object> iterator = subject.getPublicCredentials().iterator();
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (!(object instanceof WSCredential)) continue;
                        return (WSCredential)object;
                    }
                    return null;
                }
            });
            if (bl) {
                long l = wSCredential.getExpiration();
                long l2 = ContextManagerFactory.getInstance().getReqTimeout();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Cushion in use is " + l2 + " millis."));
                }
                if (l != -1L && l != 0L) {
                    long l3 = System.currentTimeMillis();
                    long l4 = l - (l3 + l2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Time remaining is: " + l4 + " millis."));
                    }
                    if (l4 <= 0L) {
                        return ServerCredSigner.getInstance().isServerCred(wSCredential);
                    }
                    return true;
                }
                return true;
            }
            boolean bl2 = wSCredential.isCurrent();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Is credential valid? " + bl2));
            }
            return bl2;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.getWSCredentialFromSubject", (String)"383");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting WSCredential from Subject.", (Object)new Object[]{exception});
            }
            return false;
        }
    }

    public static WSPrincipal getPrincipalFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        try {
            WSPrincipal wSPrincipal = (WSPrincipal)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return subject.getPrincipals(class$com$ibm$websphere$security$auth$WSPrincipal == null ? (class$com$ibm$websphere$security$auth$WSPrincipal = SubjectHelper.class$("com.ibm.websphere.security.auth.WSPrincipal")) : class$com$ibm$websphere$security$auth$WSPrincipal).iterator().next();
                }
            });
            return wSPrincipal;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.getPrincipalFromSubject", (String)"417");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting WSPrincipal from Subject.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    public static WSPrincipal createPrincipal(WSCredential wSCredential) throws WSSecurityException {
        WSPrincipalImpl wSPrincipalImpl = null;
        try {
            if (wSCredential != null) {
                String string = wSCredential.getRealmSecurityName();
                if (string == null || string.length() == 0) {
                    StringBuffer stringBuffer = new StringBuffer(ContextManagerFactory.getInstance().getDefaultRealm());
                    stringBuffer.append("/").append(wSCredential.getSecurityName());
                    string = stringBuffer.toString();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Principal name: " + string));
                }
                wSPrincipalImpl = new WSPrincipalImpl(string);
            }
        }
        catch (CredentialExpiredException credentialExpiredException) {
            throw new WSSecurityException(credentialExpiredException.getMessage(), credentialExpiredException);
        }
        return wSPrincipalImpl;
    }

    public static Subject createBasicAuthSubject(String string, String string2, String string3) {
        WSCredentialImpl wSCredentialImpl = null;
        wSCredentialImpl = string == null || string.length() == 0 ? new WSCredentialImpl(ContextManagerFactory.getInstance().getDefaultRealm(), string2, string3) : new WSCredentialImpl(string, string2, string3);
        return SubjectHelper.createSubjectFromWSCredential(wSCredentialImpl);
    }

    public static Subject createUnauthenticatedSubject() {
        if (unauthenticatedSubject == null) {
            WSCredentialImpl wSCredentialImpl = new WSCredentialImpl("", ContextManagerFactory.getInstance().getUnauthenticatedString(), "");
            unauthenticatedSubject = SubjectHelper.createSubjectFromWSCredential(wSCredentialImpl);
        }
        return unauthenticatedSubject;
    }

    public static Subject createNewSubjectFromExisting(Subject subject) {
        Subject subject2;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createNewSubjectFromExisting");
            }
            if (subject == null) {
                return null;
            }
            subject2 = new Subject();
            try {
                Object object;
                Iterator<Object> iterator;
                Set<Object> set = subject.getPublicCredentials();
                Set<Object> set2 = subject.getPrivateCredentials();
                Set<Principal> set3 = subject.getPrincipals();
                if (set.size() > 0) {
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        subject2.getPublicCredentials().add(object);
                    }
                }
                if (set2.size() > 0) {
                    iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        subject2.getPrivateCredentials().add(object);
                    }
                }
                if (set3.size() > 0) {
                    iterator = set3.iterator();
                    while (iterator.hasNext()) {
                        object = (Principal)iterator.next();
                        subject2.getPrincipals().add((Principal)object);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.createNewSubjectFromExisting", (String)"547");
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)tc, (String)"Error copying existing Subject.", (Object)new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createNewSubjectFromExisting");
        }
        return subject2;
    }

    public static PropagationToken updatePropagationTokenWithSubjectChange(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updatePropagationTokenWithSubjectChange");
        }
        if (subject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updatePropagationTokenWithSubjectChange");
            }
            return null;
        }
        try {
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (wSCredential == null || wSCredential != null && wSCredential.isUnauthenticated()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Not setting propagation token for UNAUTHENTICATED subject.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updatePropagationTokenWithSubjectChange");
                }
                return null;
            }
            String string = ContextManagerFactory.getInstance().getProperty("com.ibm.CSI.CellNodeServer");
            String[] stringArray = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
            if (stringArray == null) {
                block54: {
                    try {
                        final Subject subject2 = subject;
                        stringArray = (PropagationToken)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws WSSecurityException {
                                PropagationToken propagationToken = ContextManagerFactory.getInstance().createPropagationToken(subject2);
                                ContextManagerFactory.getInstance().setPropagationToken(propagationToken.getName() + ":" + propagationToken.getVersion(), propagationToken);
                                return propagationToken;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"606");
                        if (!tc.isDebugEnabled()) break block54;
                        Tr.debug((TraceComponent)tc, (String)"Error setting propagation token.", (Object)new Object[]{privilegedActionException.getException()});
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updatePropagationTokenWithSubjectChange, new");
                }
                return stringArray;
            }
            if (wSCredential != null) {
                String string2;
                Object object;
                Object object2;
                Object object3;
                boolean bl;
                block59: {
                    String string3;
                    Object object4;
                    String[] stringArray2;
                    block55: {
                        stringArray2 = null;
                        try {
                            object4 = stringArray;
                            stringArray2 = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((PropagationToken)object4){
                                private final /* synthetic */ PropagationToken val$propagationTokenPriv;
                                {
                                    this.val$propagationTokenPriv = propagationToken;
                                }

                                public Object run() throws WSSecurityException {
                                    String[] stringArray = this.val$propagationTokenPriv.getAttributes("com.ibm.wsspi.security.propagation.callers");
                                    return stringArray;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"633");
                            if (!tc.isDebugEnabled()) break block55;
                            Tr.debug((TraceComponent)tc, (String)"Error setting propagation token attribute.", (Object)new Object[]{privilegedActionException.getException()});
                        }
                    }
                    object4 = null;
                    String string4 = string + ":" + wSCredential.getRealmSecurityName();
                    bl = false;
                    if (stringArray2 != null && stringArray2.length > 0) {
                        object4 = stringArray2[stringArray2.length - 1];
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Last caller: " + (String)object4));
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Current caller: " + string4));
                        }
                        if (!wSCredential.isUnauthenticated() && object4 != null && !((String)object4).equals(string4)) {
                            block56: {
                                try {
                                    object3 = stringArray;
                                    string3 = string4;
                                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((PropagationToken)object3, string3){
                                        private final /* synthetic */ PropagationToken val$propagationTokenPriv;
                                        private final /* synthetic */ String val$callersPriv;
                                        {
                                            this.val$propagationTokenPriv = propagationToken;
                                            this.val$callersPriv = string;
                                        }

                                        public Object run() throws WSSecurityException {
                                            this.val$propagationTokenPriv.addAttribute("com.ibm.wsspi.security.propagation.callers", this.val$callersPriv);
                                            return null;
                                        }
                                    });
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"664");
                                    if (!tc.isDebugEnabled()) break block56;
                                    Tr.debug((TraceComponent)tc, (String)"Error setting propagation token attribute.", (Object)new Object[]{privilegedActionException.getException()});
                                }
                            }
                            bl = true;
                        }
                    } else {
                        block57: {
                            try {
                                object3 = stringArray;
                                string3 = string4;
                                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((PropagationToken)object3, string3){
                                    private final /* synthetic */ PropagationToken val$propagationTokenPriv;
                                    private final /* synthetic */ String val$callersPriv;
                                    {
                                        this.val$propagationTokenPriv = propagationToken;
                                        this.val$callersPriv = string;
                                    }

                                    public Object run() throws WSSecurityException {
                                        this.val$propagationTokenPriv.addAttribute("com.ibm.wsspi.security.propagation.callers", this.val$callersPriv);
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"688");
                                if (!tc.isDebugEnabled()) break block57;
                                Tr.debug((TraceComponent)tc, (String)"Error setting propagation token attribute.", (Object)new Object[]{privilegedActionException.getException()});
                            }
                        }
                        bl = true;
                    }
                    if (tc.isDebugEnabled()) {
                        block58: {
                            try {
                                object3 = stringArray;
                                stringArray2 = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((PropagationToken)object3){
                                    private final /* synthetic */ PropagationToken val$propagationTokenPriv;
                                    {
                                        this.val$propagationTokenPriv = propagationToken;
                                    }

                                    public Object run() throws WSSecurityException {
                                        String[] stringArray = this.val$propagationTokenPriv.getAttributes("com.ibm.wsspi.security.propagation.callers");
                                        return stringArray;
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"711");
                                if (!tc.isDebugEnabled()) break block58;
                                Tr.debug((TraceComponent)tc, (String)"Error setting propagation token attribute.", (Object)new Object[]{privilegedActionException.getException()});
                            }
                        }
                        object3 = new StringBuffer();
                        ((StringBuffer)object3).append("New contents of caller list: ");
                        for (int i = 0; i < stringArray2.length; ++i) {
                            if (i != 0) {
                                ((StringBuffer)object3).append("|");
                            }
                            ((StringBuffer)object3).append(stringArray2[i]);
                        }
                        Tr.debug((TraceComponent)tc, (String)((StringBuffer)object3).toString());
                    }
                    object3 = null;
                    try {
                        object2 = stringArray;
                        object3 = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((PropagationToken)object2){
                            private final /* synthetic */ PropagationToken val$propagationTokenPriv;
                            {
                                this.val$propagationTokenPriv = propagationToken;
                            }

                            public Object run() throws WSSecurityException {
                                return this.val$propagationTokenPriv.getAttributes("com.ibm.wsspi.security.propagation.hosts");
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"744");
                        if (!tc.isDebugEnabled()) break block59;
                        Tr.debug((TraceComponent)tc, (String)"Error setting propagation token attribute.", (Object)new Object[]{privilegedActionException.getException()});
                    }
                }
                object2 = null;
                if (object3 != null && ((Object)object3).length > 0) {
                    object2 = object3[((Object)object3).length - 1];
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Last host: " + (String)object2));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Current host: " + string));
                    }
                    if (!((String)object2).equals(string)) {
                        block60: {
                            try {
                                object = stringArray;
                                string2 = string;
                                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((PropagationToken)object, string2){
                                    private final /* synthetic */ PropagationToken val$propagationTokenPriv;
                                    private final /* synthetic */ String val$hostsPriv;
                                    {
                                        this.val$propagationTokenPriv = propagationToken;
                                        this.val$hostsPriv = string;
                                    }

                                    public Object run() throws WSSecurityException {
                                        this.val$propagationTokenPriv.addAttribute("com.ibm.wsspi.security.propagation.hosts", this.val$hostsPriv);
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"774");
                                if (!tc.isDebugEnabled()) break block60;
                                Tr.debug((TraceComponent)tc, (String)"Error setting propagation token attribute.", (Object)new Object[]{privilegedActionException.getException()});
                            }
                        }
                        bl = true;
                    }
                } else {
                    block61: {
                        try {
                            object = stringArray;
                            string2 = string;
                            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((PropagationToken)object, string2){
                                private final /* synthetic */ PropagationToken val$propagationTokenPriv;
                                private final /* synthetic */ String val$hostsPriv;
                                {
                                    this.val$propagationTokenPriv = propagationToken;
                                    this.val$hostsPriv = string;
                                }

                                public Object run() throws WSSecurityException {
                                    this.val$propagationTokenPriv.addAttribute("com.ibm.wsspi.security.propagation.hosts", this.val$hostsPriv);
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"798");
                            if (!tc.isDebugEnabled()) break block61;
                            Tr.debug((TraceComponent)tc, (String)"Error setting propagation token attribute.", (Object)new Object[]{privilegedActionException.getException()});
                        }
                    }
                    bl = true;
                }
                if (tc.isDebugEnabled()) {
                    block62: {
                        try {
                            object = stringArray;
                            object3 = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((PropagationToken)object){
                                private final /* synthetic */ PropagationToken val$propagationTokenPriv;
                                {
                                    this.val$propagationTokenPriv = propagationToken;
                                }

                                public Object run() throws WSSecurityException {
                                    return this.val$propagationTokenPriv.getAttributes("com.ibm.wsspi.security.propagation.hosts");
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"820");
                            if (!tc.isDebugEnabled()) break block62;
                            Tr.debug((TraceComponent)tc, (String)"Error setting propagation token attribute.", (Object)new Object[]{privilegedActionException.getException()});
                        }
                    }
                    object = new StringBuffer();
                    ((StringBuffer)object).append("New contents of hosts list: ");
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        if (i != 0) {
                            ((StringBuffer)object).append("|");
                        }
                        ((StringBuffer)object).append((String)object3[i]);
                    }
                    Tr.debug((TraceComponent)tc, (String)((StringBuffer)object).toString());
                }
                if (bl) {
                    block63: {
                        try {
                            object = stringArray;
                            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((PropagationToken)object){
                                private final /* synthetic */ PropagationToken val$propagationTokenPriv;
                                {
                                    this.val$propagationTokenPriv = propagationToken;
                                }

                                public Object run() throws WSSecurityException {
                                    ContextManagerFactory.getInstance().setPropagationToken(this.val$propagationTokenPriv.getName() + ":" + this.val$propagationTokenPriv.getVersion(), this.val$propagationTokenPriv);
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"854");
                            if (!tc.isDebugEnabled()) break block63;
                            Tr.debug((TraceComponent)tc, (String)"Exception setting propagation token.", (Object)new Object[]{privilegedActionException.getException()});
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"updatePropagationTokenWithSubjectChange, modified propagation token.");
                    }
                } else if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updatePropagationTokenWithSubjectChange, propagation token unchanged.");
                }
                return stringArray;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updatePropagationTokenWithSubjectChange");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred updating propagation token.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", (String)"876");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updatePropagationTokenWithSubjectChange");
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

