/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsPackage.CredentialsNotSet;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl;
import com.ibm.ISecurityUtilityImpl.CredentialsHelper;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.wsspi.security.ltpa.Token;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.security.auth.AuthPermission;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.login.CredentialExpiredException;
import org.omg.CORBA.StringHolder;
import org.omg.Security.OpaqueHolder;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.InvalidCredential;

public class WSCredentialImpl
implements WSCredential {
    private String realmname;
    private String username;
    private String uniqueusername;
    private String hostname;
    private String oid;
    private String primaryGroupId;
    private String accessId;
    private Token token = null;
    private byte[] credentialToken;
    private boolean forwardable;
    private long expiration = 0L;
    private boolean unauthenticated = false;
    private ArrayList groupIds;
    private ArrayList roles;
    private Hashtable hashTable = null;
    private boolean isBasicAuthCred = false;
    private boolean destroyed = false;
    private Credentials CORBACred = null;
    private byte[] refreshSync = null;
    private byte[] serverCredCipher = null;
    private byte[] wsCredCipher = null;
    private static final AuthPermission APP_READ_PERMISSION = new AuthPermission("wssecurity.applicationReadCredential");
    private static final AuthPermission APP_UPDATE_PERMISSION = new AuthPermission("wssecurity.applicationUpdateCredential");
    private static final AuthPermission READ_PERMISSION = new AuthPermission("wssecurity.readCredential");
    private static final AuthPermission UPDATE_PERMISSION = new AuthPermission("wssecurity.updateCredential");
    private static final AuthPermission CREATE_PERMISSION = new AuthPermission("wssecurity.createCredential");
    private static final AuthPermission DESTROY_PERMISSION = new AuthPermission("wssecurity.destroyCredential");
    private static final AuthPermission REFRESH_PERMISSION = new AuthPermission("wssecurity.refreshCredential");
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$WSCredentialImpl == null ? (class$com$ibm$ws$security$auth$WSCredentialImpl = WSCredentialImpl.class$("com.ibm.ws.security.auth.WSCredentialImpl")) : class$com$ibm$ws$security$auth$WSCredentialImpl), null, (String)"com.ibm.ISecurityL13SupportImpl.sec");
    static /* synthetic */ Class class$com$ibm$ws$security$auth$WSCredentialImpl;

    public WSCredentialImpl(String string, String string2, String string3, String string4, String string5, ArrayList arrayList, ArrayList arrayList2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(CREATE_PERMISSION);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating Registry WSCredential.");
        }
        this.refreshSync = new byte[0];
        this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
        this.realmname = string;
        this.username = string2;
        this.uniqueusername = string3;
        this.primaryGroupId = string4;
        this.accessId = string5;
        this.hashTable = new Hashtable(32);
        this.roles = arrayList != null ? (ArrayList)arrayList.clone() : new ArrayList();
        this.groupIds = arrayList2 != null ? (ArrayList)arrayList2.clone() : new ArrayList();
    }

    public WSCredentialImpl(WSCredential wSCredential, String string, Token token, boolean bl, long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(CREATE_PERMISSION);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating LoginModule WSCredential.");
        }
        try {
            this.refreshSync = new byte[0];
            this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
            this.realmname = wSCredential.getRealmName();
            this.username = wSCredential.getSecurityName();
            this.uniqueusername = wSCredential.getUniqueSecurityName();
            this.primaryGroupId = wSCredential.getPrimaryGroupId();
            this.accessId = wSCredential.getAccessId();
            this.roles = wSCredential.getRoles();
            this.groupIds = wSCredential.getGroupIds();
            this.hashTable = new Hashtable(32);
            this.oid = string;
            this.forwardable = bl;
            this.expiration = l;
            this.token = token;
            this.hashTable = ((WSCredentialImpl)wSCredential).getTable();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred while creating credential.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSCredentialImpl.constructor", (String)"159");
        }
    }

    public WSCredentialImpl(WSCredential wSCredential, String string, byte[] byArray, boolean bl, long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(CREATE_PERMISSION);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating LoginModule WSCredential.");
        }
        try {
            this.refreshSync = new byte[0];
            this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
            this.realmname = wSCredential.getRealmName();
            this.username = wSCredential.getSecurityName();
            this.uniqueusername = wSCredential.getUniqueSecurityName();
            this.primaryGroupId = wSCredential.getPrimaryGroupId();
            this.accessId = wSCredential.getAccessId();
            this.roles = wSCredential.getRoles();
            this.groupIds = wSCredential.getGroupIds();
            this.hashTable = new Hashtable(32);
            this.oid = string;
            this.forwardable = bl;
            this.expiration = l;
            this.credentialToken = byArray;
            this.hashTable = ((WSCredentialImpl)wSCredential).getTable();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred while creating credential.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSCredentialImpl.constructor", (String)"206");
        }
    }

    public WSCredentialImpl(String string, String string2, String string3) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating BasicAuth WSCredential.");
        }
        this.refreshSync = new byte[0];
        this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
        this.realmname = string;
        this.username = string2;
        this.uniqueusername = string2;
        this.accessId = string2;
        this.credentialToken = StringBytesConversion.getConvertedBytes(string3);
        this.isBasicAuthCred = true;
        this.oid = "oid:2.23.130.1.1.1";
        this.forwardable = true;
        this.expiration = 0L;
        this.hashTable = new Hashtable(32);
        this.groupIds = new ArrayList();
        if (this.username.equals("UNAUTHENTICATED")) {
            this.unauthenticated = true;
        }
    }

    public WSCredentialImpl(Credentials credentials) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(CREATE_PERMISSION);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating WSCredential wrapper of CORBACred.");
        }
        if (credentials == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Corba credential is null.");
            }
            throw new NullPointerException("CORBA Credential is null");
        }
        this.refreshSync = new byte[0];
        this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
        this.CORBACred = credentials;
        this.cleanup();
    }

    public String getRealmName() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.CORBACred == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRealmName() -> " + this.realmname));
            }
            return this.realmname;
        }
        String string = CredentialsHelper.getUserName((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred);
        String string2 = RealmSecurityName.getRealm(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRealmName() -> " + string2));
        }
        return string2;
    }

    public String getSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.CORBACred == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getSecurityName() -> " + this.username));
            }
            return this.username;
        }
        String string = CredentialsHelper.getUserName((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred);
        String string2 = RealmSecurityName.getSecurityName(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getSecurityName() -> " + string2));
        }
        return string2;
    }

    public String getRealmSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        return this.getRealmName() + "/" + this.getSecurityName();
    }

    public String getUniqueSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        this._assert();
        if (this.CORBACred == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getUniqueSecurityName() -> " + this.uniqueusername));
            }
            return this.uniqueusername;
        }
        String string = ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).getUniqueSecurityName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getUniqueSecurityName() -> " + string));
        }
        return string;
    }

    public String getRealmUniqueSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        return this.getRealmName() + "/" + this.getUniqueSecurityName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCredentialToken() throws CredentialDestroyedException, CredentialExpiredException {
        byte[] byArray = this.refreshSync;
        synchronized (this.refreshSync) {
            this._assert();
            if (this.CORBACred == null) {
                if (this.credentialToken != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return (byte[])this.credentialToken.clone();
                }
                if (this.credentialToken == null && this.token != null) {
                    try {
                        this.credentialToken = this.token.getBytes();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return (byte[])this.credentialToken.clone();
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception occurred getting bytes[] from token.", (Object)new Object[]{exception});
                        }
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.auth.WSCredentialImpl.getCredentialToken", (String)"483");
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return null;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getCredentialToken() -> null");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            StringHolder stringHolder = new StringHolder();
            OpaqueHolder opaqueHolder = new OpaqueHolder();
            try {
                ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).get_credential_token(stringHolder, opaqueHolder);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return opaqueHolder.value;
            }
            catch (CredentialsNotSet credentialsNotSet) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Token is null.");
                }
                FFDCFilter.processException((Throwable)((Object)credentialsNotSet), (String)"com.ibm.ws.security.common.auth.WSCredentialImpl.getCredentialToken", (String)"313");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }
    }

    public String getHostName() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.CORBACred == null) {
            if (this.hostname == null || this.hostname.length() == 0) {
                this.hostname = VaultImpl.getInstance().getORB().getLocalHost();
                if (this.hostname == null || this.hostname.length() == 0) {
                    this.hostname = "localHost";
                }
            }
            return this.hostname;
        }
        String string = CredentialsHelper.getHostName((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred);
        return string;
    }

    public String getOID() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.CORBACred == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getOID() -> " + this.oid));
            }
            return this.oid;
        }
        String string = ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).getOID();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getOID() -> " + string));
        }
        return string;
    }

    public boolean isForwardable() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.CORBACred == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isForwardable() -> " + this.forwardable));
            }
            return this.forwardable;
        }
        boolean bl = ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).isForwardable();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isForwardable() -> " + bl));
        }
        return bl;
    }

    public boolean isForwardable(String string) throws CredentialDestroyedException, CredentialExpiredException {
        if (this.CORBACred == null) {
            boolean bl;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isForwardable() -> " + this.forwardable));
            }
            String string2 = this.realmname;
            String string3 = string;
            String string4 = "<default>";
            boolean bl2 = bl = string2.length() == 0 || string2.equalsIgnoreCase(string4) || string2.equalsIgnoreCase(string3) || string3.length() == 0;
            if (!bl) {
                String string5;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Target realm does not match current realm, target realm: " + string3 + ", current realm: " + string2 + "."));
                }
                VaultImpl.getInstance();
                SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
                if (securityConfiguration != null && (string5 = securityConfiguration.getSupportedTargetRealms()) != null && !string5.equals("")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, "|");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken();
                        if (!string6.equalsIgnoreCase(string3)) continue;
                        bl = true;
                        break;
                    }
                }
            }
            if (!bl && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Target realm does not match current realm, target realm: " + string3 + ", current realm: " + string2 + "."));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isForwardable() -> " + bl));
            }
            return bl;
        }
        boolean bl = ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).isForwardable(string, true);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isForwardable() -> " + bl));
        }
        return bl;
    }

    public long getExpiration() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.CORBACred == null) {
            return this.expiration;
        }
        long l = ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).getExpiration();
        return l;
    }

    public String getPrimaryGroupId() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.CORBACred == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getPrimaryGroupId() -> " + this.primaryGroupId));
            }
            return this.primaryGroupId;
        }
        String string = CredentialsHelper.getPrimaryGroupID((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPrimaryGroupId() -> " + string));
        }
        return string;
    }

    public ArrayList getRoles() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.roles != null) {
            return (ArrayList)this.roles.clone();
        }
        return null;
    }

    public String getAccessId() throws CredentialDestroyedException, CredentialExpiredException {
        this._assert();
        if (this.CORBACred == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getAccessId() -> " + this.accessId));
            }
            return this.accessId;
        }
        String string = CredentialsHelper.getAccessID((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAccessId() -> " + string));
        }
        return string;
    }

    public ArrayList getGroupIds() throws CredentialDestroyedException, CredentialExpiredException {
        this._assert();
        if (this.CORBACred == null) {
            return (ArrayList)this.groupIds.clone();
        }
        ArrayList arrayList = CredentialsHelper.getGroupIDs((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred);
        return arrayList;
    }

    public Object get(String string) throws CredentialDestroyedException, CredentialExpiredException {
        this._assert();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(APP_READ_PERMISSION);
        }
        if (string.startsWith("wssecurity") && securityManager != null) {
            securityManager.checkPermission(READ_PERMISSION);
        }
        if (this.CORBACred == null) {
            return this.hashTable.get(string);
        }
        return ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(String string, Object object) throws CredentialDestroyedException, CredentialExpiredException {
        byte[] byArray = this.refreshSync;
        synchronized (this.refreshSync) {
            this._assert();
            SecurityManager securityManager = System.getSecurityManager();
            if (string.startsWith("wssecurity") && securityManager != null) {
                securityManager.checkPermission(UPDATE_PERMISSION);
            }
            if (this.CORBACred == null) {
                if (this.hashTable.get(string) != null && securityManager != null) {
                    securityManager.checkPermission(APP_UPDATE_PERMISSION);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.hashTable.put(string, object);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).set(string, object);
        }
    }

    public boolean isCurrent() {
        if (this.isDestroyed()) {
            return false;
        }
        boolean bl = false;
        try {
            if (this.CORBACred == null) {
                long l;
                long l2;
                bl = this.expiration != -1L && this.expiration != 0L ? ((l2 = this.expiration - (l = System.currentTimeMillis())) <= 0L ? ServerCredSigner.getInstance().isServerCred(this) : true) : true;
            } else {
                try {
                    bl = this.CORBACred.is_valid(CredentialsHelper.expiry_time_now);
                }
                catch (InvalidCredential invalidCredential) {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Refresh of credential failed.");
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSCredentialImpl.refresh", (String)"1042", (Object)this);
            bl = false;
        }
        if (tc.isDebugEnabled() && !bl) {
            Tr.debug((TraceComponent)tc, (String)("isCurrent() -> " + bl));
        }
        return bl;
    }

    public boolean isUnauthenticated() {
        if (this.CORBACred == null) {
            return this.unauthenticated;
        }
        return ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).isUnauthenticated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws DestroyFailedException {
        byte[] byArray = this.refreshSync;
        synchronized (this.refreshSync) {
            SecurityManager securityManager;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"destroy()");
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                securityManager.checkPermission(DESTROY_PERMISSION);
            }
            if (ServerCredSigner.getInstance().isServerCred(this)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"destroy() -> Server cred cannot be destroyed");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.destroyed = true;
            this.CORBACred = null;
            this.cleanup();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"destroy()");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isDestroyed() {
        if (tc.isDebugEnabled() && this.destroyed) {
            Tr.debug((TraceComponent)tc, (String)("isDestroyed() -> " + this.destroyed));
        }
        return this.destroyed;
    }

    public boolean isBasicAuth() {
        if (this.CORBACred == null) {
            return this.isBasicAuthCred;
        }
        return this.CORBACred instanceof CredentialsImpl;
    }

    public Credentials getCORBACred() {
        if (tc.isDebugEnabled()) {
            if (this.CORBACred == null) {
                Tr.debug((TraceComponent)tc, (String)"CORBA credential does not exist in WSCredential.");
            } else {
                Tr.debug((TraceComponent)tc, (String)"CORBA credential exists in WSCredential.");
            }
        }
        return this.CORBACred;
    }

    public void setCORBACred(Credentials credentials) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting Corba Cred into WS cred, hashcode: " + credentials.hashCode()));
        }
        this.CORBACred = credentials;
        this.cleanup();
    }

    public void refresh() throws RefreshFailedException {
        throw new RefreshFailedException("Refresh is not supported in this mechanism.");
    }

    private final void _assert() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.isDestroyed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_assert() --> destroyed");
            }
            throw new CredentialDestroyedException("Credential is destroyed, can not be used.");
        }
        if (!this.isCurrent()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_assert() --> expired");
            }
            throw new CredentialExpiredException("Credential is expired, please refresh.");
        }
    }

    public Hashtable getTable() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(READ_PERMISSION);
        }
        if (this.CORBACred == null) {
            return this.hashTable != null ? (Hashtable)this.hashTable.clone() : null;
        }
        return ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).getTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(Hashtable hashtable) {
        byte[] byArray = this.refreshSync;
        synchronized (this.refreshSync) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(UPDATE_PERMISSION);
            }
            if (this.CORBACred == null) {
                this.hashTable = (Hashtable)hashtable.clone();
            } else {
                ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)this.CORBACred).setTable(hashtable);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void markServerCred(byte[] byArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(UPDATE_PERMISSION);
        }
        this.serverCredCipher = byArray;
    }

    protected byte[] getServerCredCipher() {
        return this.serverCredCipher;
    }

    protected byte[] getWSCredCipher() {
        return this.wsCredCipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshCred(WSCredential wSCredential) throws WSSecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(UPDATE_PERMISSION);
        }
        try {
            if (!ServerCredSigner.getInstance().isServerCred(this) || wSCredential.isBasicAuth()) return;
            if (wSCredential != null && this.CORBACred == null && !this.destroyed) {
                byte[] byArray = this.refreshSync;
                synchronized (this.refreshSync) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Refreshing only the credential token and expiration.");
                    }
                    this.destroyed = true;
                    this.credentialToken = wSCredential.getCredentialToken();
                    this.expiration = wSCredential.getExpiration();
                    this.destroyed = false;
                    wSCredential = null;
                    if (!tc.isDebugEnabled()) return;
                    Tr.debug((TraceComponent)tc, (String)"Completed refresh.");
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
            if (wSCredential == null) return;
            byte[] byArray = this.refreshSync;
            synchronized (this.refreshSync) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Refreshing the entire WSCredential.");
                }
                this.destroyed = true;
                this.CORBACred = null;
                this.credentialToken = wSCredential.getCredentialToken();
                this.expiration = wSCredential.getExpiration();
                this.realmname = wSCredential.getRealmName();
                this.username = wSCredential.getSecurityName();
                this.uniqueusername = wSCredential.getUniqueSecurityName();
                this.hostname = wSCredential.getHostName();
                this.oid = wSCredential.getOID();
                this.primaryGroupId = wSCredential.getPrimaryGroupId();
                this.accessId = wSCredential.getAccessId();
                this.forwardable = wSCredential.isForwardable();
                this.unauthenticated = false;
                this.groupIds = wSCredential.getGroupIds();
                this.roles = wSCredential.getRoles();
                this.hashTable = ((WSCredentialImpl)wSCredential).getTable();
                this.isBasicAuthCred = false;
                this.destroyed = false;
                wSCredential = null;
                if (!tc.isDebugEnabled()) return;
                Tr.debug((TraceComponent)tc, (String)"Completed refresh.");
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred while refreshing credential.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSCredentialImpl.refreshCred", (String)"1424", (Object)this);
            throw new WSSecurityException(exception.getMessage(), exception);
        }
    }

    private void cleanup() {
        this.realmname = null;
        this.username = null;
        this.uniqueusername = null;
        this.oid = null;
        this.primaryGroupId = null;
        this.accessId = null;
        this.forwardable = false;
        this.expiration = 0L;
        this.credentialToken = null;
        this.groupIds = null;
        this.hashTable = null;
        this.isBasicAuthCred = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

