/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SerialDeserialSubjectException;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public class WSLoginHelperImpl {
    private static final AuthPermission GET_SUBJECT_PERMISSION = new AuthPermission("getSubject");
    private static final PrivilegedExceptionAction getSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException, GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSubjectAction.run()");
            }
            Subject subject = null;
            WSCredential wSCredential = ContextManagerFactory.getInstance().getInvocationCredential();
            if (wSCredential != null) {
                subject = new Subject();
                WSPrincipalImpl wSPrincipalImpl = new WSPrincipalImpl(wSCredential.getRealmSecurityName());
                subject.getPrincipals().add(wSPrincipalImpl);
                subject.getPublicCredentials().add(wSCredential);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invocation Credential is null, null Subject is returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSubjectAction.run()");
            }
            return subject;
        }
    };
    private static final PrivilegedExceptionAction getSerializableSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException, GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSerializableSubjectAction.run()");
            }
            Subject subject = null;
            WSCredential wSCredential = ContextManagerFactory.getInstance().getInvocationCredential();
            if (wSCredential != null) {
                subject = new Subject();
                WSPrincipalImpl wSPrincipalImpl = new WSPrincipalImpl(wSCredential.getRealmSecurityName());
                subject.getPrincipals().add(wSPrincipalImpl);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invocation Credential is null, null Subject is returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSerializableSubjectAction.run()");
            }
            return subject;
        }
    };
    private static final PrivilegedExceptionAction getUnauthSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getUnauthSubjectAction.run()");
            }
            Subject subject = null;
            WSCredential wSCredential = ContextManagerFactory.getInstance().getUnauthenticatedCredential();
            if (wSCredential != null) {
                subject = new Subject();
                WSPrincipalImpl wSPrincipalImpl = new WSPrincipalImpl(wSCredential.getRealmSecurityName());
                subject.getPrincipals().add(wSPrincipalImpl);
                subject.getPublicCredentials().add(wSCredential);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No unauthenticated credential, null Subject is returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUnauthSubjectAction.run()");
            }
            return subject;
        }
    };
    private static final PrivilegedExceptionAction getSerializableUnauthSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSerializableUnauthSubjectAction.run()");
            }
            Subject subject = null;
            WSCredential wSCredential = ContextManagerFactory.getInstance().getUnauthenticatedCredential();
            if (wSCredential != null) {
                subject = new Subject();
                WSPrincipalImpl wSPrincipalImpl = new WSPrincipalImpl(wSCredential.getRealmSecurityName());
                subject.getPrincipals().add(wSPrincipalImpl);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No unauthenticated credential, null Subject is returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSerializableUnauthSubjectAction.run()");
            }
            return subject;
        }
    };
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$WSLoginHelperImpl == null ? (class$com$ibm$ws$security$auth$WSLoginHelperImpl = WSLoginHelperImpl.class$("com.ibm.ws.security.auth.WSLoginHelperImpl")) : class$com$ibm$ws$security$auth$WSLoginHelperImpl), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$websphere$security$UserRegistry;
    static /* synthetic */ Class class$com$ibm$ws$security$auth$WSLoginHelperImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSCredential authenticate(String string, String string2, String string3) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("authenticate(username = \"" + string + "\", realmname = \"" + string2 + "\", password = \"XXXXXXXX\")"));
        }
        WSLoginHelperImpl.disableAuthRetryForThread();
        WSCredential wSCredential = null;
        try {
            if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                wSCredential = ContextManagerFactory.getInstance().authenticate(string2, string, string3);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is disabled, no authentication is performed, null credential will be returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"authenticate(username, realmname, password)");
            }
        }
        finally {
            WSLoginHelperImpl.enableAuthRetryForThread();
        }
        return wSCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSCredential validate(byte[] byArray) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate(credToken)");
        }
        WSLoginHelperImpl.disableAuthRetryForThread();
        WSCredential wSCredential = null;
        try {
            if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                wSCredential = ContextManagerFactory.getInstance().authenticate(WSLoginHelperImpl.getDefaultRealmName(), byArray);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is disabled, no validation is performed, null credential will be returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate(credToken)");
            }
        }
        finally {
            WSLoginHelperImpl.enableAuthRetryForThread();
        }
        return wSCredential;
    }

    /*
     * Unable to fully structure code
     */
    public static Subject getSubject() throws WSSecurityException {
        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)WSLoginHelperImpl.tc, (String)"getSubject()");
        }
        if ((var0 = System.getSecurityManager()) != null) {
            var0.checkPermission(WSLoginHelperImpl.GET_SUBJECT_PERMISSION);
            if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        var1_1 = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Getting the subject from credential on the Current Thread of Execution");
                }
                var1_1 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)WSLoginHelperImpl.getSubjectAction);
                if (!WSLoginHelperImpl.tc.isDebugEnabled()) ** GOTO lbl25
                Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Got the subject from credential on the Current Thread of Execution");
            }
            catch (PrivilegedActionException var2_2) {
                var3_3 = var2_2.getException();
                FFDCFilter.processException((Throwable)var3_3, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.getSubject", (String)"245");
                var1_1 = null;
                if (var3_3 instanceof WSSecurityException) {
                    throw (WSSecurityException)var3_3;
                }
                throw new WSSecurityException(var3_3.getMessage(), var3_3);
            }
        } else if (WSLoginHelperImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Security is disabled, null subject will be returned");
        }
lbl25:
        // 5 sources

        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)WSLoginHelperImpl.tc, (String)"getSubject()");
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    public static Subject getSerializableSubject() throws WSSecurityException {
        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)WSLoginHelperImpl.tc, (String)"getSerializableSubject()");
        }
        if ((var0 = System.getSecurityManager()) != null) {
            var0.checkPermission(WSLoginHelperImpl.GET_SUBJECT_PERMISSION);
            if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        var1_1 = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Getting the serializable subject from credential on the current thread of execution");
                }
                var1_1 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)WSLoginHelperImpl.getSerializableSubjectAction);
                if (!WSLoginHelperImpl.tc.isDebugEnabled()) ** GOTO lbl25
                Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Got the serializable subject from credential on the current thread of execution");
            }
            catch (PrivilegedActionException var2_2) {
                var3_3 = var2_2.getException();
                FFDCFilter.processException((Throwable)var3_3, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.getSerializableSubject", (String)"245");
                var1_1 = null;
                if (var3_3 instanceof WSSecurityException) {
                    throw (WSSecurityException)var3_3;
                }
                throw new WSSecurityException(var3_3.getMessage(), var3_3);
            }
        } else if (WSLoginHelperImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Security is disabled, null subject will be returned");
        }
lbl25:
        // 5 sources

        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)WSLoginHelperImpl.tc, (String)"getSerializableSubject()");
        }
        return var1_1;
    }

    public static Subject getUnauthenticatedSubject() throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUnauthenticatedSubjecy()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        Subject subject = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                subject = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)getUnauthSubjectAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.getUnauthenticatedSubject", (String)"431");
                subject = null;
                if (exception instanceof WSSecurityException) {
                    throw (WSSecurityException)exception;
                }
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Security is disabled, null subject will be returned");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUnauthenticatedSubjecy()");
        }
        return subject;
    }

    public static Subject getSerializableUnauthSubject() throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSerializableUnauthSubject()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        Subject subject = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                subject = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)getSerializableUnauthSubjectAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.getUnauthenticatedSubject", (String)"485");
                subject = null;
                if (exception instanceof WSSecurityException) {
                    throw (WSSecurityException)exception;
                }
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Security is disabled, null subject will be returned");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSerializableUnauthSubject()");
        }
        return subject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Subject restoreSerializedSubject(final Subject subject, WSCredential wSCredential) throws SerialDeserialSubjectException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreSerializedSubject()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        Subject subject2 = null;
        if (subject == null) {
            if (!tc.isDebugEnabled()) throw new SerialDeserialSubjectException();
            Tr.debug((TraceComponent)tc, (String)"Passed in Subject or Credential is null");
            throw new SerialDeserialSubjectException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Passed in Subject is good");
        }
        Subject subject3 = null;
        Subject subject4 = SubjectHelper.createSubjectFromWSCredential(wSCredential);
        try {
            block18: {
                try {
                    if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                        try {
                            subject3 = ContextManagerFactory.getInstance().pushInvocationSubject(subject4);
                        }
                        catch (WSSecurityException wSSecurityException) {
                            SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException(wSSecurityException.getMessage());
                            serialDeserialSubjectException.addException(wSSecurityException);
                            throw serialDeserialSubjectException;
                        }
                        subject2 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws SerialDeserialSubjectException {
                                Subject subject2 = null;
                                Set<Principal> set = subject.getPrincipals();
                                if (set == null || set.isEmpty()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"No Principals found from the serialized subject");
                                    }
                                    throw new SerialDeserialSubjectException();
                                }
                                InitialContext initialContext = null;
                                UserRegistry userRegistry = null;
                                Object object = null;
                                try {
                                    initialContext = new InitialContext();
                                    object = initialContext.lookup("UserRegistry");
                                    userRegistry = (UserRegistry)PortableRemoteObject.narrow((Object)object, (Class)(class$com$ibm$websphere$security$UserRegistry == null ? (class$com$ibm$websphere$security$UserRegistry = WSLoginHelperImpl.class$("com.ibm.websphere.security.UserRegistry")) : class$com$ibm$websphere$security$UserRegistry));
                                    if (userRegistry == null) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"No User Registry is available, null Subject is returned");
                                        }
                                        throw new SerialDeserialSubjectException();
                                    }
                                    WSCredential wSCredential = null;
                                    WSCredential wSCredential2 = null;
                                    WSPrincipalImpl wSPrincipalImpl = null;
                                    subject2 = new Subject();
                                    Object[] objectArray = set.toArray();
                                    for (int i = 0; i < objectArray.length; ++i) {
                                        wSPrincipalImpl = (WSPrincipalImpl)objectArray[i];
                                        if (wSPrincipalImpl.getUserName().compareTo(ContextManagerFactory.getInstance().getUnauthenticatedString()) == 0) {
                                            wSCredential = ContextManagerFactory.getInstance().getUnauthenticatedCredential();
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)"Restoring unauthenticated credential");
                                            }
                                        } else {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)("Restoring subject for: " + wSPrincipalImpl.getUserName()));
                                            }
                                            if ((wSCredential2 = userRegistry.createCredential(wSPrincipalImpl.getUserName())) != null) {
                                                String string = ContextManagerFactory.getInstance().getProperty("com.ibm.CSI.WSSecurityContextActiveForwardable", "true");
                                                boolean bl = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"));
                                                String string2 = ContextManagerFactory.getInstance().getProperty("com.ibm.CSI.WSSecurityContextActiveOID", "NONE");
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)("OID: " + string2 + ", Forwardable: " + string));
                                                }
                                                byte[] byArray = wSCredential2.getCredentialToken();
                                                long l = wSCredential2.getExpiration();
                                                if (string2.equals("NONE")) {
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug((TraceComponent)tc, (String)"Configured authetication mechanism is unknown. Failed to restore Subject.");
                                                    }
                                                    throw new SerialDeserialSubjectException("Configured authetication mechanism is unknown. Failed to restore Subject.");
                                                }
                                                wSCredential = new WSCredentialImpl(wSCredential2, string2, byArray, bl, l);
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)"Restored identity credential");
                                                }
                                            } else {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)"Failed to restore the identity credential");
                                                }
                                                throw new SerialDeserialSubjectException();
                                            }
                                        }
                                        subject2.getPrincipals().add(wSPrincipalImpl);
                                        subject2.getPublicCredentials().add(wSCredential);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Restoring Subject is completed");
                                    }
                                }
                                catch (NamingException namingException) {
                                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"576");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Failed to get initial Naming Context. Failed to resolve for UserRegistry");
                                    }
                                    Tr.error((TraceComponent)tc, (String)"security.jaas.get.initCtx", (Object)new Object[]{namingException});
                                    SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException();
                                    serialDeserialSubjectException.addException(namingException);
                                    throw serialDeserialSubjectException;
                                }
                                catch (CustomRegistryException customRegistryException) {
                                    FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"585");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"CustomRegistryException is caught. Failed to create credential");
                                    }
                                    Tr.error((TraceComponent)tc, (String)"security.jaas.create.credential", (Object)new Object[]{customRegistryException});
                                    SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException();
                                    serialDeserialSubjectException.addException(customRegistryException);
                                    throw serialDeserialSubjectException;
                                }
                                catch (SerialDeserialSubjectException serialDeserialSubjectException) {
                                    throw serialDeserialSubjectException;
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"594");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("An exception is caught: " + exception.toString()));
                                    }
                                    Tr.error((TraceComponent)tc, (String)"security.jaas.restore.exception", (Object)new Object[]{exception});
                                    SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException();
                                    serialDeserialSubjectException.addException(exception);
                                    throw serialDeserialSubjectException;
                                }
                                return subject2;
                            }
                        });
                        break block18;
                    }
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug((TraceComponent)tc, (String)"Security is disabled, null subject will be returned");
                }
                catch (PrivilegedActionException privilegedActionException) {
                    SerialDeserialSubjectException serialDeserialSubjectException = (SerialDeserialSubjectException)privilegedActionException.getException();
                    FFDCFilter.processException((Throwable)serialDeserialSubjectException, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"606");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"PrivilegedActionException is caught while serialized Subject is being restored");
                    }
                    Tr.error((TraceComponent)tc, (String)"security.jaas.priv.exception", (Object)new Object[]{serialDeserialSubjectException});
                    throw serialDeserialSubjectException;
                }
            }
            Object var9_10 = null;
            try {
                ContextManagerFactory.getInstance().popInvocationSubject(subject3);
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"631");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"InvalidCredentialType exception is caught while serialized Subject is being restored");
                }
                Tr.error((TraceComponent)tc, (String)"security.jaas.invalidType2.cred.exception", (Object)new Object[]{wSSecurityException});
                SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException(wSSecurityException.getMessage());
                serialDeserialSubjectException.addException(wSSecurityException);
                throw serialDeserialSubjectException;
            }
            if (!tc.isEntryEnabled()) return subject2;
            Tr.exit((TraceComponent)tc, (String)"restoreSerializedSubject()");
            return subject2;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {}
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"631");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"InvalidCredentialType exception is caught while serialized Subject is being restored");
                }
                Tr.error((TraceComponent)tc, (String)"security.jaas.invalidType2.cred.exception", (Object)new Object[]{wSSecurityException});
                SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException(wSSecurityException.getMessage());
                serialDeserialSubjectException.addException(wSSecurityException);
                throw serialDeserialSubjectException;
            }
            ContextManagerFactory.getInstance().popInvocationSubject(subject3);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"restoreSerializedSubject()");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSCredential refresh(String string, String string2, String string3) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("refresh(username = \"" + string + "\", realmname = \"" + string2 + "\", password = \"XXXXXXXX\")"));
        }
        WSLoginHelperImpl.disableAuthRetryForThread();
        WSCredential wSCredential = null;
        try {
            if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                wSCredential = ContextManagerFactory.getInstance().authenticate(string2, string, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"returned from login");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is disabled, credential is not refreshed, null credential will be returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"refresh(username, realmname, password)");
            }
        }
        finally {
            WSLoginHelperImpl.enableAuthRetryForThread();
        }
        return wSCredential;
    }

    public static String getDefaultRealmName() {
        return ContextManagerFactory.getInstance().getDefaultRealm();
    }

    private WSLoginHelperImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSLoginHelperImpl()");
        }
        Tr.error((TraceComponent)tc, (String)"security.jaas.NoWSLoginHelperImpl");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSLoginHelperImpl()");
        }
    }

    private static void disableAuthRetryForThread() {
        ContextManagerFactory.getInstance().put("wssecurity.disableauthretry", new Boolean(true));
    }

    private static void enableAuthRetryForThread() {
        ContextManagerFactory.getInstance().put("wssecurity.disableauthretry", new Boolean(false));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

