/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ContextManagerFactory {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$core$ContextManagerFactory == null ? (class$com$ibm$ws$security$core$ContextManagerFactory = ContextManagerFactory.class$("com.ibm.ws.security.core.ContextManagerFactory")) : class$com$ibm$ws$security$core$ContextManagerFactory), null, (String)"com.ibm.ejs.resources.security");
    private static final String DEFAULT_CONTEXT_MGR_IMPL = "com.ibm.ws.security.auth.ContextManagerImpl";
    private static String CONTEXT_MGR_IMPL = "com.ibm.ws.security.auth.ContextManagerImpl";
    private static ContextManager instance = null;
    private static final String plugins_list = "/META-INF/plugins.list";
    static /* synthetic */ Class class$com$ibm$ws$security$core$ContextManagerFactory;

    private ContextManagerFactory() {
    }

    public static ContextManager getInstance() {
        if (instance == null) {
            try {
                String string = ContextManagerFactory.getContextMgrImplFromPluginList();
                try {
                    instance = (ContextManager)Class.forName(string).newInstance();
                    Tr.debug((TraceComponent)tc, (String)("Loaded ContextManagerImpl class: " + string));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", (String)"57");
                    Tr.error((TraceComponent)tc, (String)("Could not find class: " + string));
                    throw classNotFoundException;
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", (String)"63");
                    Tr.error((TraceComponent)tc, (String)("Could not instantiate class: " + string));
                    throw instantiationException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", (String)"69");
                    Tr.error((TraceComponent)tc, (String)("Could not load class: " + string));
                    throw exception;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerFactory", (String)"38");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error in initializing the ContextManager Implementation Class " + CONTEXT_MGR_IMPL), (Object)exception);
                }
                instance = null;
                throw new ExceptionInInitializerError(exception);
            }
        }
        return instance;
    }

    private static String getContextMgrImplFromPluginList() {
        try {
            InputStream inputStream = Class.forName("com.ibm.ws.security.core.ContextManagerFactory").getResourceAsStream(plugins_list);
            if (inputStream != null) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("com.ibm.ws.security.plugin.ContextManager")) continue;
                    int n = string.indexOf(61) + 1;
                    CONTEXT_MGR_IMPL = string.substring(n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ContextManager implementation class from plugin.list is: " + CONTEXT_MGR_IMPL));
                    }
                    return CONTEXT_MGR_IMPL;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find com.ibm.ws.security.plugin.ContextManager property in plugins.list file.");
                }
                return DEFAULT_CONTEXT_MGR_IMPL;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"plugins.list file not found");
            }
            return DEFAULT_CONTEXT_MGR_IMPL;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", (String)"118");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed to load list of admin applications");
            }
            return DEFAULT_CONTEXT_MGR_IMPL;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

