/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.wsspi.security.token.Token;
import java.security.Permission;
import java.util.Date;
import java.util.Enumeration;

public abstract class AbstractTokenImpl
implements Token {
    private com.ibm.wsspi.security.ltpa.Token token = null;
    private String accessId = "";
    private ContextManager contextManager = null;
    private boolean isReadOnly = false;
    private short version = 1;
    private byte[] tokenBytes = null;
    private long change_counter = 0L;
    private static final WebSphereRuntimePermission UPDATE_TOKEN = new WebSphereRuntimePermission("updateToken");
    private static final WebSphereRuntimePermission GET_TOKEN = new WebSphereRuntimePermission("getToken");
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$token$AbstractTokenImpl == null ? (class$com$ibm$ws$security$token$AbstractTokenImpl = AbstractTokenImpl.class$("com.ibm.ws.security.token.AbstractTokenImpl")) : class$com$ibm$ws$security$token$AbstractTokenImpl), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$ws$security$token$AbstractTokenImpl;

    public void setToken(com.ibm.wsspi.security.ltpa.Token token) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + UPDATE_TOKEN.toString()));
            }
            securityManager.checkPermission((Permission)UPDATE_TOKEN);
        }
        this.token = token;
    }

    public com.ibm.wsspi.security.ltpa.Token getToken() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_TOKEN.toString()));
            }
            securityManager.checkPermission((Permission)GET_TOKEN);
        }
        return this.token;
    }

    public boolean isValid() {
        if (this.token != null) {
            Date date = new Date();
            Date date2 = new Date(this.getExpiration());
            boolean bl = date.before(date2);
            return bl;
        }
        return false;
    }

    public long getExpiration() {
        if (this.token != null) {
            return this.token.getExpiration();
        }
        return -1L;
    }

    public boolean isForwardable() {
        return true;
    }

    public String getPrincipal() {
        String[] stringArray = this.getAttributes("u");
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String getUniqueID() {
        String[] stringArray = this.getAttributes("com.ibm.wsspi.security.cred.cacheKey");
        if (stringArray != null && stringArray[0] != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found cache key in Authz token: " + stringArray[0]));
            }
            return stringArray[0];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No unique cache key found in token.");
        }
        return null;
    }

    public byte[] getBytes() {
        if (this.token != null) {
            try {
                if (this.tokenBytes == null) {
                    this.tokenBytes = this.token.getBytes();
                }
                return this.tokenBytes;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred getting bytes[] from token.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.AbstractTokenImpl.getBytes", (String)"179");
                return null;
            }
        }
        return new byte[0];
    }

    public String getName() {
        return this.getClass().getName();
    }

    public short getVersion() {
        return this.version;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
    }

    public String[] getAttributes(String string) {
        if (this.token != null) {
            return this.token.getAttributes(string);
        }
        return null;
    }

    public String[] addAttribute(String string, String string2) {
        SecurityManager securityManager;
        if ((string.startsWith("com.ibm.wsspi.security") || string.startsWith("com.ibm.websphere.security")) && (securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + UPDATE_TOKEN.toString()));
            }
            securityManager.checkPermission((Permission)UPDATE_TOKEN);
        }
        if (!this.isReadOnly && this.token != null) {
            ++this.change_counter;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting attribute with key: " + string));
            }
            return this.token.addAttribute(string, string2);
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        if (this.token != null) {
            return this.token.getAttributeNames();
        }
        return null;
    }

    public Object clone() {
        return null;
    }

    protected String getChangeCounter() {
        return new Long(this.change_counter).toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

