/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.token;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.Token;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;

public class WSOpaqueTokenHelper {
    private ContextManager contextManager = null;
    private static WSOpaqueTokenHelper wsOpaqueTokenHelper = null;
    public static final String tokenHeader = "WSOPAQUE";
    private final byte[] tokenHeaderBytes = StringBytesConversion.getConvertedBytes("WSOPAQUE");
    private final int tokenHeaderSize = this.tokenHeaderBytes.length;
    private final int tokenVersion = 1;
    private final String tokenHeaderLookup = "WSOPAQUE:1";
    public static final String wsCredHashHeader = "WSCREDHASH";
    private final byte[] wsCredHashHeaderBytes = StringBytesConversion.getConvertedBytes("WSCREDHASH");
    private final int wsCredHashHeaderSize = this.wsCredHashHeaderBytes.length;
    public static final String wsTokensHeader = "WSTOKEN";
    private final byte[] wsTokensHeaderBytes = StringBytesConversion.getConvertedBytes("WSTOKEN");
    private final int wsTokensHeaderSize = this.wsTokensHeaderBytes.length;
    public static final String customTokensHeader = "CUSTOM";
    private final byte[] customTokensHeaderBytes = StringBytesConversion.getConvertedBytes("CUSTOM");
    private final int customTokensHeaderSize = this.customTokensHeaderBytes.length;
    public static final String customPublicTokensHeader = "CUSTOM_PUBLIC";
    public static final String customPublicTokensHeaderEnding = " (1)";
    private final byte[] customPublicTokensHeaderBytes = StringBytesConversion.getConvertedBytes("CUSTOM_PUBLIC");
    private final int customPublicTokensHeaderSize = this.customPublicTokensHeaderBytes.length;
    public static final String customPrivateTokensHeader = "CUSTOM_PRIVATE";
    public static final String customPrivateTokensHeaderEnding = " (2)";
    private final byte[] customPrivateTokensHeaderBytes = StringBytesConversion.getConvertedBytes("CUSTOM_PRIVATE");
    private final int customPrivateTokensHeaderSize = this.customPrivateTokensHeaderBytes.length;
    public static final String customPrincipalTokensHeader = "CUSTOM_PRINCIPAL";
    public static final String customPrincipalTokensHeaderEnding = " (3)";
    private final byte[] customPrincipalTokensHeaderBytes = StringBytesConversion.getConvertedBytes("CUSTOM_PRINCIPAL");
    private final int customPrincipalTokensHeaderSize = this.customPrincipalTokensHeaderBytes.length;
    private static ArrayList excludeList = null;
    private short number_of_tokens = 0;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$wsspi$security$token$WSOpaqueTokenHelper == null ? (class$com$ibm$wsspi$security$token$WSOpaqueTokenHelper = WSOpaqueTokenHelper.class$("com.ibm.wsspi.security.token.WSOpaqueTokenHelper")) : class$com$ibm$wsspi$security$token$WSOpaqueTokenHelper), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$WSOpaqueTokenHelper;

    public static WSOpaqueTokenHelper getInstance() {
        if (wsOpaqueTokenHelper == null) {
            wsOpaqueTokenHelper = new WSOpaqueTokenHelper();
        }
        return wsOpaqueTokenHelper;
    }

    private WSOpaqueTokenHelper() {
        try {
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.security.token.WSOpaqueTokenHelper.init", (String)"130", (Object)this);
            Tr.debug((TraceComponent)tc, (String)"Exception getting ContextManager.", (Object)new Object[]{exception});
            this.contextManager.setRootException(exception);
        }
    }

    public String getOpaqueTokenName() {
        return tokenHeader;
    }

    public String getOpaqueTokenLookup() {
        return "WSOPAQUE:1";
    }

    public int getOpaqueTokenVersion() {
        return 1;
    }

    public byte[] createOpaqueTokenFromSubject(final Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createOpaqueTokenFromSubject");
        }
        if (subject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createOpaqueTokenFromSubject");
            }
            return null;
        }
        try {
            int n;
            Object[] objectArray;
            ArrayList arrayList = null;
            ArrayList arrayList2 = null;
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                try {
                    arrayList = (ArrayList)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws WSLoginFailedException {
                            return WSOpaqueTokenHelper.this.getForwardableTokensFromSubject(subject);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromSubject", (String)"242", (Object)this);
                    Tr.debug((TraceComponent)tc, (String)"Exception getting private/public tokens from Subject.", (Object)new Object[]{privilegedActionException.getException()});
                    return null;
                }
                if (arrayList == null && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Token list is null.");
                }
                if ((arrayList2 = this.getForwardablePropagationTokensFromContext()) == null && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"propagation token list is null.");
                }
            }
            if (arrayList2 == null && arrayList == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Propagation and subject token lists are null.");
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            if (arrayList2 != null) {
                objectArray = arrayList2.toArray();
                for (n = 0; n < objectArray.length; ++n) {
                    arrayList3.add(objectArray[n]);
                }
            }
            if (arrayList != null) {
                objectArray = arrayList.toArray();
                for (n = 0; n < objectArray.length; ++n) {
                    arrayList3.add(objectArray[n]);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createOpaqueTokenFromSubject");
            }
            return this.createOpaqueTokenFromTokenHolderList(subject, arrayList3);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSLoginFailedException occurred creating opaque token.", (Object)new Object[]{wSLoginFailedException});
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.updatePropagationTokenWithSubjectChange", (String)"297", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createOpaqueTokenFromSubject");
            }
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred creating opaque token.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.updatePropagationTokenWithSubjectChange", (String)"304", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createOpaqueTokenFromSubject");
            }
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    private byte[] createOpaqueTokenFromTokenHolderList(Subject subject, ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createOpaqueTokenFromTokenHolderList");
        }
        if ((arrayList == null || arrayList.size() == 0) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Returning null token.", (Object)new Object[]{arrayList});
        }
        try {
            Object object;
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            block32: {
                byteArrayOutputStream = new ByteArrayOutputStream(300);
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Token header size: " + this.tokenHeaderSize));
                }
                dataOutputStream.write(this.tokenHeaderBytes, 0, this.tokenHeaderSize);
                dataOutputStream.write(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Writing opaque token header/version: WSOPAQUE/V1");
                }
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                Hashtable hashtable = null;
                if (wSCredential != null) {
                    hashtable = ((WSCredentialImpl)wSCredential).getTable();
                }
                byte[] byArray = null;
                int n = 0;
                if (hashtable != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Attempting to write wsCred hashtable.");
                    }
                    try {
                        byArray = WSOpaqueTokenHelper.serialize(hashtable);
                        if (byArray != null) {
                            n = byArray.length;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Offset size: " + byteArrayOutputStream.size()));
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("wsCredHashHeaderSize: " + this.wsCredHashHeaderSize));
                            }
                            dataOutputStream.write(this.wsCredHashHeaderBytes, 0, this.wsCredHashHeaderSize);
                            dataOutputStream.writeInt(n);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Writing wsCred hashtable, length: " + n));
                            }
                            dataOutputStream.write(byArray, 0, n);
                        }
                    }
                    catch (Exception exception) {
                        byArray = null;
                        n = 0;
                        Tr.warning((TraceComponent)tc, (String)"security.sap.warning.serializing.custom.objects.from.subject", (Object)new Object[]{hashtable});
                        if (!tc.isDebugEnabled()) break block32;
                        Tr.debug((TraceComponent)tc, (String)"Exception occurred writing wsCred hashtable.", (Object)new Object[]{exception});
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Total tokens to write: " + arrayList.size()));
            }
            dataOutputStream.write(this.wsTokensHeaderBytes, 0, this.wsTokensHeaderSize);
            dataOutputStream.write(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                object = null;
                int n = 0;
                byte[] byArray = null;
                int n2 = 0;
                byte[] byArray2 = null;
                int n3 = 0;
                TokenHolder tokenHolder = (TokenHolder)arrayList.get(i);
                if (tokenHolder == null) continue;
                object = tokenHolder.getName();
                n2 = tokenHolder.getVersion();
                byArray2 = tokenHolder.getBytes();
                if (object == null || n2 == 0 || byArray2 == null) continue;
                byArray = StringBytesConversion.getConvertedBytes((String)object);
                n = byArray.length;
                n3 = byArray2.length;
                dataOutputStream.writeInt(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Writing token name: " + (String)object));
                }
                dataOutputStream.write(byArray, 0, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Writing token version: " + n2));
                }
                dataOutputStream.write(n2);
                dataOutputStream.writeInt(n3);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Writing token bytes, length: " + n3));
                }
                dataOutputStream.write(byArray2, 0, n3);
            }
            ArrayList arrayList2 = null;
            try {
                object = subject;
                arrayList2 = (ArrayList)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Subject)object){
                    private final /* synthetic */ Subject val$subjectPriv;
                    {
                        this.val$subjectPriv = subject;
                    }

                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                        String string;
                        Object object;
                        Object object2;
                        ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
                        Object object3 = null;
                        byte[] byArray = null;
                        Iterator<Object> iterator = this.val$subjectPriv.getPublicCredentials().iterator();
                        while (iterator.hasNext()) {
                            object3 = iterator.next();
                            if (object3 instanceof Token || object3 instanceof WSCredential || WSOpaqueTokenHelper.this.isExcluded(object3)) continue;
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Serializing custom public object: ", (Object)new Object[]{object3});
                                }
                                byArray = WSOpaqueTokenHelper.serialize(object3);
                                object2 = null;
                                try {
                                    object = object3.getClass().getName();
                                    object2 = (String)object + WSOpaqueTokenHelper.customPublicTokensHeaderEnding;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (object2 == null) {
                                    object2 = WSOpaqueTokenHelper.customPublicTokensHeader;
                                }
                                if (byArray == null) continue;
                                arrayList.add(new TokenHolder(byArray, (String)object2, 1));
                            }
                            catch (Exception exception) {
                                Tr.warning((TraceComponent)tc, (String)"security.sap.warning.serializing.custom.objects.from.subject", (Object)new Object[]{object3});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Exception occurred serializing custom public object.", (Object)new Object[]{exception});
                                }
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", (String)"476", (Object)this);
                            }
                        }
                        object2 = this.val$subjectPriv.getPrivateCredentials().iterator();
                        while (object2.hasNext()) {
                            object3 = object2.next();
                            if (object3 instanceof Token || object3 instanceof WSCredential || WSOpaqueTokenHelper.this.isExcluded(object3)) continue;
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Serializing custom private object: ", (Object)new Object[]{object3});
                                }
                                byArray = WSOpaqueTokenHelper.serialize(object3);
                                object = null;
                                try {
                                    string = object3.getClass().getName();
                                    object = string + WSOpaqueTokenHelper.customPrivateTokensHeaderEnding;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (object == null) {
                                    object = WSOpaqueTokenHelper.customPrivateTokensHeader;
                                }
                                if (byArray == null) continue;
                                arrayList.add(new TokenHolder(byArray, (String)object, 1));
                            }
                            catch (Exception exception) {
                                Tr.warning((TraceComponent)tc, (String)"security.sap.warning.serializing.custom.objects.from.subject", (Object)new Object[]{object3});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Exception occurred serializing custom public object.", (Object)new Object[]{exception});
                                }
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", (String)"512", (Object)this);
                            }
                        }
                        object = this.val$subjectPriv.getPrincipals().iterator();
                        while (object.hasNext()) {
                            object3 = object.next();
                            if (object3 instanceof WSPrincipal || WSOpaqueTokenHelper.this.isExcluded(object3)) continue;
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Serializing custom principal object: ", (Object)new Object[]{object3});
                                }
                                byArray = WSOpaqueTokenHelper.serialize(object3);
                                string = null;
                                try {
                                    String string2 = object3.getClass().getName();
                                    string = string2 + WSOpaqueTokenHelper.customPrincipalTokensHeaderEnding;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (string == null) {
                                    string = WSOpaqueTokenHelper.customPrincipalTokensHeader;
                                }
                                if (byArray == null) continue;
                                arrayList.add(new TokenHolder(byArray, string, 1));
                            }
                            catch (Exception exception) {
                                Tr.warning((TraceComponent)tc, (String)"security.sap.warning.serializing.custom.objects.from.subject", (Object)new Object[]{object3});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Exception occurred serializing custom public object.", (Object)new Object[]{exception});
                                }
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", (String)"547", (Object)this);
                            }
                        }
                        return arrayList;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.commit", (String)"569", (Object)this);
                this.contextManager.setRootException(privilegedActionException.getException());
                throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
            }
            if (arrayList2.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Total custom tokens to write: " + arrayList2.size()));
                }
                dataOutputStream.write(this.customTokensHeaderBytes, 0, this.customTokensHeaderSize);
                dataOutputStream.write(arrayList2.size());
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string = null;
                    int n = 0;
                    byte[] byArray = null;
                    int n4 = 0;
                    byte[] byArray3 = null;
                    int n5 = 0;
                    TokenHolder tokenHolder = (TokenHolder)arrayList2.get(i);
                    if (tokenHolder == null) continue;
                    string = tokenHolder.getName();
                    n4 = tokenHolder.getVersion();
                    byArray3 = tokenHolder.getBytes();
                    if (string == null || n4 == 0 || byArray3 == null) continue;
                    byArray = StringBytesConversion.getConvertedBytes(string);
                    n = byArray.length;
                    n5 = byArray3.length;
                    dataOutputStream.writeInt(n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Writing token name: " + string));
                    }
                    dataOutputStream.write(byArray, 0, n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Writing token version: " + n4));
                    }
                    dataOutputStream.write(n4);
                    dataOutputStream.writeInt(n5);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Writing token bytes, length: " + n5));
                    }
                    dataOutputStream.write(byArray3, 0, n5);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Total opaque token length: " + byteArrayOutputStream.size()));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createOpaqueTokenFromTokenHolderList");
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", (String)"636", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred creating opaque token.", (Object)new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createOpaqueTokenFromTokenHolderList");
            }
            return null;
        }
    }

    public ArrayList createTokenHolderListFromOpaqueToken(byte[] byArray) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTokenHolderListFromOpaqueToken");
        }
        if (byArray == null || byArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning null token holder ArrayList.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createTokenHolderListFromOpaqueToken");
            }
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            boolean bl = this.checkOpaqueTokenHeader(dataInputStream);
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Successfully read the opaque token header, beginning to process token.");
                }
                ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
                boolean bl2 = this.checkCredHashHeader(dataInputStream);
                if (bl2) {
                    byte[] byArray2 = null;
                    boolean bl3 = false;
                    byArray2 = this.readCredHashTableBytes(dataInputStream);
                    if (byArray2 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Successfully retrieved wsCredHash bytes.");
                        }
                        arrayList.add(new TokenHolder(byArray2, wsCredHashHeader, 1));
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"wsCredHash bytes could not be read from InputStream.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The wsCred hashtable not present in opaque byte array.");
                }
                boolean bl4 = this.checkTokensHeader(dataInputStream);
                if (bl4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Reading standard tokens from opaque token.");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"There are no tokens present in opaque byte array.");
                    }
                    throw new WSSecurityException("There are no tokens present in opaque byte array.");
                }
                this.readTokens(dataInputStream, arrayList);
                bl4 = this.checkCustomTokensHeader(dataInputStream);
                if (bl4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Reading custom tokens from opaque token.");
                    }
                    this.readTokens(dataInputStream, arrayList);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There are no custom tokens present in opaque byte array.");
                }
                return arrayList;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Not a WAS opaque authorization token.");
            }
            throw new WSSecurityException("Not a WAS opaque authorization token.");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", (String)"747", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred creating opaque token.", (Object)new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createTokenHolderListFromOpaqueToken");
            }
            return null;
        }
    }

    private void readTokens(DataInputStream dataInputStream, ArrayList arrayList) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readTokens");
        }
        try {
            int n = dataInputStream.readByte();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Number of tokens to be handled: " + n));
            }
            for (int i = 0; i < n; ++i) {
                String string = null;
                byte[] byArray = null;
                int n2 = 0;
                byte by = 0;
                byte[] byArray2 = null;
                int n3 = 0;
                n2 = dataInputStream.readInt();
                byArray = new byte[n2];
                dataInputStream.read(byArray, 0, n2);
                string = StringBytesConversion.getConvertedString(byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found token name: " + string));
                }
                by = dataInputStream.readByte();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Token version: " + by));
                }
                n3 = dataInputStream.readInt();
                byArray2 = new byte[n3];
                dataInputStream.read(byArray2, 0, n3);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Token bytes length: " + n3));
                }
                if (byArray2 == null || string == null) {
                    throw new WSSecurityException("malformed token, cannot retrieve token bytes.");
                }
                arrayList.add(new TokenHolder(byArray2, string, by));
            }
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.readTokens", (String)"805", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readTokens exception", (Object)new Object[]{wSSecurityException});
            }
            throw wSSecurityException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.readTokens", (String)"811", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readTokens exception", (Object)new Object[]{exception});
            }
            throw new WSSecurityException(exception.getMessage(), exception);
        }
    }

    private byte[] readCredHashTableBytes(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readCredHashTableBytes");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            int n = 0;
            byte[] byArray = null;
            n = dataInputStream.readInt();
            if (n > 0) {
                byArray = new byte[n];
                dataInputStream.read(byArray, 0, n);
                return byArray;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("readCredHashTableBytes, invalid size = " + n));
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.readCredHashTableBytes", (String)"852", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readCredHashTableBytes exception", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    private boolean checkOpaqueTokenHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkOpaqueTokenHeader");
        }
        try {
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.tokenHeaderSize];
            dataInputStream.read(byArray, 0, this.tokenHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString(byArray);
                if (string.equals(tokenHeader)) {
                    byte by = dataInputStream.readByte();
                    if (by == 1) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"checkOpaqueTokenHeader, true");
                        }
                        return true;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("checkOpaqueTokenHeader, version mismatch, version = " + by));
                    }
                    return false;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkOpaqueTokenHeader, invalid header, false");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkOpaqueTokenHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.checkOpaqueTokenHeader", (String)"907", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkOpaqueTokenHeader exception", (Object)new Object[]{exception});
            }
            return false;
        }
    }

    private boolean checkCredHashHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkCredHashHeader");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.wsCredHashHeaderSize];
            dataInputStream.read(byArray, 0, this.wsCredHashHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString(byArray);
                if (string.equals(wsCredHashHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"checkCredHashHeader, true");
                    }
                    return true;
                }
                dataInputStream.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkCredHashHeader, false");
                }
                return false;
            }
            dataInputStream.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkCredHashHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            try {
                dataInputStream.reset();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.checkCredHashHeader", (String)"961", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkCredHashHeader exception", (Object)new Object[]{exception});
            }
            return false;
        }
    }

    private boolean checkTokensHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkTokensHeader");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.wsTokensHeaderSize];
            dataInputStream.read(byArray, 0, this.wsTokensHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString(byArray);
                if (string.equals(wsTokensHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"checkTokensHeader, true");
                    }
                    return true;
                }
                dataInputStream.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkTokensHeader, false");
                }
                return false;
            }
            dataInputStream.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkTokensHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            try {
                dataInputStream.reset();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.checkTokensHeader", (String)"1015", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkTokensHeader exception", (Object)new Object[]{exception});
            }
            return false;
        }
    }

    private boolean checkCustomTokensHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkCustomTokensHeader");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.customTokensHeaderSize];
            dataInputStream.read(byArray, 0, this.customTokensHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString(byArray);
                if (string.equals(customTokensHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"checkCustomTokensHeader, true");
                    }
                    return true;
                }
                dataInputStream.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkCustomTokensHeader, false");
                }
                return false;
            }
            dataInputStream.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkCustomTokensHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            try {
                dataInputStream.reset();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.checkCustomTokensHeader", (String)"1069", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkCustomTokensHeader exception", (Object)new Object[]{exception});
            }
            return false;
        }
    }

    public static byte[] serialize(Object object) throws Exception {
        return WSOpaqueTokenHelper.serialize(object, class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = WSOpaqueTokenHelper.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream);
    }

    private static byte[] serialize(Object object, Class clazz) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        byte[] byArray = null;
        try {
            objectOutputStream = (ObjectOutputStream)clazz.getConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = WSOpaqueTokenHelper.class$("java.io.OutputStream")) : class$java$io$OutputStream).newInstance(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception serializing object. ", (Object)new Object[]{exception});
            }
            throw exception;
        }
        finally {
            try {
                objectOutputStream.close();
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public static Object deserialize(byte[] byArray) throws Exception {
        return WSOpaqueTokenHelper.deserialize(byArray, class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = WSOpaqueTokenHelper.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream);
    }

    private static Object deserialize(byte[] byArray, Class clazz) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            objectInputStream = (ObjectInputStream)clazz.getConstructor(class$java$io$InputStream == null ? (class$java$io$InputStream = WSOpaqueTokenHelper.class$("java.io.InputStream")) : class$java$io$InputStream).newInstance(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            Tr.warning((TraceComponent)tc, (String)"security.sap.warning.deserializing.custom.objects.from.subject");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception deserializing object. ", (Object)new Object[]{exception});
            }
            throw exception;
        }
        finally {
            try {
                objectInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    private ArrayList getForwardablePropagationTokensFromContext() throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getForwardablePropagationTokensFromContext");
        }
        try {
            ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
            Map map = this.contextManager.getPropagationTokens();
            if (map == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No propagation token present on the thread.");
                }
                return null;
            }
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                PropagationToken propagationToken = (PropagationToken)iterator.next();
                if (propagationToken == null || !propagationToken.isForwardable()) continue;
                if (!propagationToken.isValid()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Propagation token with name " + propagationToken.getName() + " is expired."));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding propagation token, name: " + propagationToken.getName()));
                }
                arrayList.add(new TokenHolder(propagationToken.getBytes(), propagationToken.getName(), propagationToken.getVersion()));
            }
            if (arrayList == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Propagation token list is null.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getForwardablePropagationTokensFromContext");
            }
            return arrayList;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSAuthzTokenHelper.getForwardableAuthzTokensFromSubject", (String)"1233", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting forwardable propagation tokens.", (Object)new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getForwardablePropagationTokensFromContext");
            }
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    private ArrayList getForwardableTokensFromSubject(Subject subject) throws WSLoginFailedException {
        if (subject == null) {
            Tr.debug((TraceComponent)tc, (String)"Null Subject passed in.");
            return null;
        }
        try {
            Object object;
            Iterator<Object> iterator;
            ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
            Set<Object> set = subject.getPrivateCredentials();
            Set<Object> set2 = subject.getPublicCredentials();
            Iterator<Object> iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                iterator = iterator2.next();
                if (!(iterator instanceof Token)) continue;
                object = (Token)((Object)iterator);
                if (object.isForwardable()) {
                    if (!object.isValid()) {
                        Tr.debug((TraceComponent)tc, (String)("Token with name " + object.getName() + " is expired."));
                        throw new WSLoginFailedException("Token with name " + object.getName() + " is expired.");
                    }
                    arrayList.add(new TokenHolder(object.getBytes(), object.getName(), object.getVersion()));
                    continue;
                }
                Tr.debug((TraceComponent)tc, (String)("Token with name " + object.getName() + " is not forwardable."));
            }
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                Token token;
                object = iterator.next();
                if (!(object instanceof Token) || !(token = (Token)object).isForwardable() || !token.isValid()) continue;
                arrayList.add(new TokenHolder(token.getBytes(), token.getName(), token.getVersion()));
            }
            if (arrayList != null && arrayList.size() > 0) {
                return arrayList;
            }
            return null;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.getForwardableAuthzTokensFromSubject", (String)"1317", (Object)this);
            Tr.debug((TraceComponent)tc, (String)"WSLoginFailedException getting forwardable tokens from Subject.", (Object)new Object[]{wSLoginFailedException});
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.getForwardableAuthzTokensFromSubject", (String)"1323", (Object)this);
            Tr.debug((TraceComponent)tc, (String)"Exception getting forwardable tokens from Subject.", (Object)new Object[]{exception});
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    private boolean isExcluded(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isExcluded");
        }
        try {
            String string;
            if (excludeList == null) {
                string = this.contextManager.getProperty("com.ibm.ws.security.propagationExcludeList");
                excludeList = new ArrayList();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.endsWith("*")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding entry to exclude list: " + string2));
                    }
                    excludeList.add(string2);
                }
            }
            string = object.getClass().getName();
            for (int i = 0; i < excludeList.size(); ++i) {
                if (string.equals((String)excludeList.get(i))) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)(string + " isExcluded (true), list rule -> " + excludeList.get(i)));
                    }
                    return true;
                }
                if (string.startsWith((String)excludeList.get(i))) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)(string + " isExcluded (true), list rule -> " + excludeList.get(i)));
                    }
                    return true;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(string + " isExcluded (false)"));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSOpaqueTokenHelper.isExcluded", (String)"1372", (Object)this);
            Tr.debug((TraceComponent)tc, (String)"Exception checking if class is excluded from propagation.", (Object)new Object[]{exception});
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

