/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

final class C14nUtil {
    C14nUtil() {
    }

    static final void serializeText(String text, Writer wr) throws IOException {
        int len = text.length();
        int start = -1;
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            if (ch == '<') {
                if (start >= 0) {
                    wr.write(text, start, i - start);
                    start = -1;
                }
                wr.write("&lt;");
            } else if (ch == '>') {
                if (start >= 0) {
                    wr.write(text, start, i - start);
                    start = -1;
                }
                wr.write("&gt;");
            } else if (ch == '&') {
                if (start >= 0) {
                    wr.write(text, start, i - start);
                    start = -1;
                }
                wr.write("&amp;");
            } else if (ch == '\r') {
                if (start >= 0) {
                    wr.write(text, start, i - start);
                    start = -1;
                }
                wr.write("&#xD;");
            } else if (start < 0) {
                start = i;
            }
            ++i;
        }
        if (start >= 0) {
            wr.write(text, start, len - start);
        }
    }

    static final void serializePI(Node node, Writer wr) throws IOException {
        boolean lesser = false;
        boolean greater = false;
        if (node.getParentNode().getNodeType() == 9) {
            Node prev = node;
            while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
            }
            if (prev == null) {
                lesser = true;
            } else {
                greater = true;
            }
        }
        ProcessingInstruction pi = (ProcessingInstruction)node;
        if (greater) {
            wr.write("\n");
        }
        wr.write("<?");
        wr.write(pi.getTarget());
        if (pi.getData() != null && pi.getData().length() > 0) {
            wr.write(" ");
            String data = pi.getData();
            int start = 0;
            int index = 0;
            while (index < data.length()) {
                if (data.charAt(index) == '\r') {
                    if (index > start) {
                        wr.write(data, start, index - start);
                    }
                    wr.write("&#xD;");
                    start = index + 1;
                }
                ++index;
            }
            if (start < data.length()) {
                wr.write(data, start, data.length() - start);
            }
        }
        wr.write("?>");
        if (lesser) {
            wr.write("\n");
        }
    }

    static final void serializeComment(Node node, Writer wr) throws IOException {
        boolean lesser = false;
        boolean greater = false;
        if (node.getParentNode().getNodeType() == 9) {
            Node prev = node;
            while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
            }
            if (prev == null) {
                lesser = true;
            } else {
                greater = true;
            }
        }
        if (greater) {
            wr.write("\n");
        }
        wr.write("<!--");
        wr.write(node.getNodeValue());
        wr.write("-->");
        if (lesser) {
            wr.write("\n");
        }
    }

    static final void serializeAttribute(Node attr, Writer wr) throws IOException {
        C14nUtil.serializeAttribute(attr.getNodeName(), attr.getNodeValue(), wr);
    }

    static final void serializeAttribute(String name, String value, Writer wr) throws IOException {
        boolean checkURI = name.equals("xmlns") || name.startsWith("xmlns:");
        wr.write(" ");
        wr.write(name);
        wr.write("=\"");
        boolean hasColon = false;
        int j = 0;
        while (j < value.length()) {
            char ch = value.charAt(j);
            if (ch == '&') {
                wr.write("&amp;");
            } else if (ch == '<') {
                wr.write("&lt;");
            } else if (ch == '\"') {
                wr.write("&quot;");
            } else if (ch == '\t') {
                wr.write("&#x9;");
            } else if (ch == '\n') {
                wr.write("&#xA;");
            } else if (ch == '\r') {
                wr.write("&#xD;");
            } else {
                if (checkURI) {
                    if (ch == ':') {
                        hasColon = true;
                    } else if (ch == '/' && !hasColon) {
                        throw new RuntimeException("Found a relative URI: " + name + "='" + value + "'");
                    }
                }
                wr.write(ch);
            }
            ++j;
        }
        if (value.length() > 0 && checkURI && !hasColon) {
            throw new RuntimeException("Found a relative URI: " + name + "='" + value + "'");
        }
        wr.write("\"");
    }
}

