/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import com.ibm.dom.util.DOMUtil;
import com.ibm.dom.util.NOOPVisitor;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class CanonicalizerVisitor
extends NOOPVisitor {
    protected Writer writer = null;
    protected int nsIndex;
    private boolean debug = false;
    private static final int[] fixTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, -2048, -2048, -2048, -2048};

    public CanonicalizerVisitor(Writer w) {
        this.writer = w;
    }

    public void setWriter(Writer w) {
        this.writer = w;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitElementPre(Element element) throws Exception {
        int i;
        String name = element.getNodeName();
        String baseName = CanonicalizerVisitor.getBaseName(name);
        String expandedName = CanonicalizerVisitor.createExpandedName(element, element);
        boolean qualified = expandedName.charAt(0) != '\u0000';
        this.nsIndex = 0;
        if (qualified) {
            String nsuri = DOMUtil.getNamespaceForPrefix(CanonicalizerVisitor.getPrefix(name), element);
            this.writer.write("<n1:" + baseName + " xmlns:n1=\"");
            DOMUtil.writeEscapedAttribute(this.writer, nsuri);
            this.writer.write("\"");
            ++this.nsIndex;
        } else {
            this.writer.write("<" + baseName);
        }
        NamedNodeMap nnm = element.getAttributes();
        int atlen = nnm.getLength();
        int lenWithoutXmlns = 0;
        String[] as = new String[atlen];
        int[] indexMap = new int[atlen];
        Attr[] attrs = new Attr[atlen];
        NamedNodeMap namedNodeMap = nnm;
        synchronized (namedNodeMap) {
            i = 0;
            while (i < atlen) {
                Attr attr = (Attr)nnm.item(i);
                if (!attr.getName().equals("xmlns") && !CanonicalizerVisitor.getPrefix(attr.getName()).equals("xmlns")) {
                    indexMap[lenWithoutXmlns] = lenWithoutXmlns;
                    attrs[lenWithoutXmlns++] = attr;
                    as[i] = CanonicalizerVisitor.createExpandedName(attr, element);
                }
                ++i;
            }
        }
        CanonicalizerVisitor.heapSort(indexMap, as, lenWithoutXmlns);
        i = 0;
        while (i < lenWithoutXmlns) {
            this.visitAttributePre(attrs[indexMap[i]], element);
            ++i;
        }
        this.writer.write(">");
    }

    public void visitElementPost(Element element) throws Exception {
        boolean qualified;
        String name = element.getNodeName();
        String baseName = CanonicalizerVisitor.getBaseName(name);
        String expandedName = CanonicalizerVisitor.createExpandedName(element, element);
        boolean bl = qualified = expandedName.charAt(0) != '\u0000';
        if (qualified) {
            this.writer.write("</n1:" + CanonicalizerVisitor.getBaseName(element.getNodeName()));
        } else {
            this.writer.write("</" + CanonicalizerVisitor.getBaseName(element.getNodeName()));
        }
        this.writer.write(">");
        Node parent = element.getParentNode();
        if (parent != null && parent.getNodeType() == 9) {
            this.writer.write("\n");
        }
    }

    public void visitAttributePre(Attr attribute, Element el) throws Exception {
        this.writer.write(" ");
        String name = attribute.getName();
        int index = name.indexOf(58);
        if (index <= 0) {
            this.writer.write(name);
            this.writer.write("=\"");
            this.printEntityReferenceInAttribute(attribute);
            this.writer.write("\"");
        } else {
            String nsuri = DOMUtil.getNamespaceForPrefix(CanonicalizerVisitor.getPrefix(name), el);
            if (nsuri != null && !nsuri.equals("")) {
                ++this.nsIndex;
                this.writer.write("n" + this.nsIndex + ":");
            }
            this.writer.write(CanonicalizerVisitor.getBaseName(name));
            this.writer.write("=\"");
            this.printEntityReferenceInAttribute(attribute);
            this.writer.write("\"");
            if (nsuri != null && !nsuri.equals("")) {
                this.writer.write(" xmlns:n" + this.nsIndex + "=\"");
                DOMUtil.writeEscapedAttribute(this.writer, nsuri);
                this.writer.write("\"");
            }
        }
    }

    private void printEntityReferenceInAttribute(Node child) throws IOException {
        Node node = child.getFirstChild();
        while (node != null) {
            short type = node.getNodeType();
            if (type == 3) {
                DOMUtil.writeEscapedAttribute(this.writer, node.getNodeValue());
            } else if (type == 5) {
                this.printEntityReferenceInAttribute(node);
            } else {
                throw new RuntimeException("This attribute has invalid node.");
            }
            node = node.getNextSibling();
        }
    }

    public void visitTextPre(Text text) throws Exception {
        if (this.debug) {
            System.out.println("text.getData()=" + text.getData());
        }
        DOMUtil.writeEscapedCharData(this.writer, text.getData());
    }

    public void visitCDATASectionPre(CDATASection cdata) throws Exception {
        DOMUtil.writeEscapedCharData(this.writer, cdata.getData());
    }

    public void visitProcessingInstructionPre(ProcessingInstruction pi) throws Exception {
        this.writer.write("<?" + pi.getTarget());
        if (pi.getData() != null && pi.getData().length() > 0) {
            this.writer.write(" " + pi.getData());
        }
        this.writer.write("?>");
        if (pi.getParentNode().getNodeType() == 9) {
            this.writer.write("\n");
        }
    }

    private static String getBaseName(String name) {
        int index = name.lastIndexOf(58);
        if (index <= 0) {
            return name;
        }
        return name.substring(index + 1);
    }

    private static String getPrefix(String name) {
        int index = name.indexOf(58);
        if (index <= 0) {
            return "";
        }
        return name.substring(0, index);
    }

    private static String createExpandedName(Node node, Node element) {
        String ret;
        if (node.getNodeType() == 1 || node.getNodeType() == 2) {
            String uri;
            String name = node.getNodeName();
            int index = name.indexOf(58);
            String prefix = index <= 0 ? "" : name.substring(0, index).intern();
            String string = uri = node.getNodeType() == 2 ? null : DOMUtil.getNamespaceForPrefix(prefix, element);
            ret = uri == null || uri.length() == 0 ? "\u0000" + name : uri + "\u0000" + name.substring(index + 1).intern();
        } else {
            throw new IllegalArgumentException("Requires Element or Attr node.");
        }
        return ret;
    }

    public static void heapSort(int[] indexMap, String[] pd, int length) {
        int i = length / 2;
        while (i >= 0) {
            CanonicalizerVisitor.fall(indexMap, pd, length, i);
            --i;
        }
        i = length - 1;
        while (i > 0) {
            int t = indexMap[0];
            indexMap[0] = indexMap[i];
            indexMap[i] = t;
            CanonicalizerVisitor.fall(indexMap, pd, i, 0);
            --i;
        }
    }

    private static void fall(int[] indexMap, String[] pd, int n, int i) {
        int j = 2 * i + 1;
        if (j < n) {
            if (j + 1 < n && 0 > pd[indexMap[j]].compareTo(pd[indexMap[j + 1]])) {
                j = 2 * i + 2;
            }
            if (0 > CanonicalizerVisitor.compareInUCS(pd[indexMap[i]], pd[indexMap[j]])) {
                int t = indexMap[i];
                indexMap[i] = indexMap[j];
                indexMap[j] = t;
                CanonicalizerVisitor.fall(indexMap, pd, n, j);
            }
        }
    }

    public static final int lengthInUCS(String str) {
        int length = 0;
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if ('\ud800' <= ch && ch < '\udc00') {
                ++i;
            }
            ++length;
            ++i;
        }
        return length;
    }

    public static final int compareInUCS(String s1, String s2) {
        int len2;
        int len1 = s1.length();
        int minlen = len1 < (len2 = s2.length()) ? len1 : len2;
        int i1 = 0;
        int i2 = 0;
        while (minlen-- != 0) {
            int c1 = s1.charAt(i1++);
            c1 += fixTable[c1 >> 11];
            int c2 = s2.charAt(i2++);
            if (c1 == (c2 += fixTable[c2 >> 11])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }
}

