/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMDuplicator {
    public static Node cloneNode(Document factory, Node node) {
        Node ret = null;
        switch (node.getNodeType()) {
            case 1: {
                ret = factory.createElement(node.getNodeName());
                NamedNodeMap nnm = node.getAttributes();
                int i = 0;
                while (i < nnm.getLength()) {
                    Node a = nnm.item(i);
                    ret.setAttribute(a.getNodeName(), a.getNodeValue());
                    ++i;
                }
                break;
            }
            case 3: {
                ret = factory.createTextNode(node.getNodeValue());
                break;
            }
            case 4: {
                ret = factory.createCDATASection(node.getNodeValue());
                break;
            }
            case 2: {
                ret = factory.createAttribute(node.getNodeName());
                break;
            }
            case 7: {
                ret = factory.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                ret = factory.createComment(node.getNodeValue());
                break;
            }
            case 5: {
                ret = factory.createEntityReference(node.getNodeName());
                break;
            }
            default: {
                throw new RuntimeException("Converter#cloneNode(): Internal Error:" + node.getNodeType());
            }
        }
        if (ret != null && node.hasChildNodes()) {
            Node child = node.getFirstChild();
            while (child != null) {
                ret.insertBefore(DOMDuplicator.cloneNode(factory, child), null);
                child = child.getNextSibling();
            }
        }
        return ret;
    }
}

