/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import com.ibm.dom.util.IndentConfig;
import com.ibm.dom.util.XPathCanonicalizer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtil {
    public static final String S_XMLNS = "xmlns";
    public static final String S_XMLNAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    private static final String[] INDENT_STRINGS = new String[]{"\n", "\n ", "\n  ", "\n   ", "\n    ", "\n     ", "\n      ", "\n       ", "\n        ", "\n         ", "\n          "};
    public static IndentConfig DEFAULT_INDENT = new IndentConfig(){

        public boolean doIndentation() {
            return true;
        }

        public int getUnit() {
            return 2;
        }
    };

    private DOMUtil() {
    }

    public static String getStringValue(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 5: 
            case 9: {
                Node child = node.getFirstChild();
                if (child == null) {
                    return "";
                }
                if (child == node.getLastChild() && (child.getNodeType() == 3 || child.getNodeType() == 4)) {
                    return child.getNodeValue();
                }
                StringBuffer buf = new StringBuffer();
                DOMUtil.getStringValue0(node, buf);
                return new String(buf);
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        throw new RuntimeException("Internal Error: Unexpected node type: " + node.getNodeType());
    }

    private static void getStringValue0(Node n, StringBuffer buf) {
        switch (n.getNodeType()) {
            case 1: 
            case 5: {
                Node ch = n.getFirstChild();
                while (ch != null) {
                    DOMUtil.getStringValue0(ch, buf);
                    ch = ch.getNextSibling();
                }
                break;
            }
            case 3: 
            case 4: {
                buf.append(n.getNodeValue());
                break;
            }
        }
    }

    public static final Element createTextElement(Document doc, String qname, String value) {
        Element el = doc.createElement(qname);
        el.appendChild(doc.createTextNode(value));
        return el;
    }

    public static final Element createTextElementNS(Document doc, String ns, String qname, String value) {
        Element el = doc.createElementNS(ns, qname);
        el.appendChild(doc.createTextNode(value));
        return el;
    }

    public static final void appendText(Element el, String text) {
        el.appendChild(el.getOwnerDocument().createTextNode(text));
    }

    public static final void removeAllChildren(Element el) {
        while (el.hasChildNodes()) {
            el.removeChild(el.getFirstChild());
        }
    }

    public static String getNamespaceForPrefix(String prefix, Node current) {
        if (prefix.equals("xml")) {
            return S_XMLNAMESPACEURI;
        }
        if (prefix.equals(S_XMLNS)) {
            return prefix;
        }
        String attributeName = prefix.length() == 0 ? S_XMLNS : "xmlns:" + prefix;
        Node element = current;
        do {
            short type;
            Attr attr;
            Attr attr2 = attr = element.getAttributes().getLength() == 0 ? null : ((Element)element).getAttributeNode(attributeName);
            if (attr != null) {
                return attr.getNodeValue();
            }
            do {
                if ((element = element.getParentNode()) != null) continue;
                return attributeName == S_XMLNS ? "" : null;
            } while ((type = element.getNodeType()) == 5);
            if (type == 1) continue;
            return attributeName == S_XMLNS ? "" : null;
        } while (element != null);
        return null;
    }

    public static String getNamespace(Element el) {
        String name = el.getNodeName();
        int index = name.indexOf(58);
        String prefix = index <= 0 ? "" : name.substring(0, index);
        String uri = DOMUtil.getNamespaceForPrefix(prefix, el);
        if (uri == null || uri.length() == 0) {
            uri = null;
        }
        return uri;
    }

    public static String getLocalPart(Element el) {
        String name = el.getNodeName();
        int index = name.indexOf(58);
        return index < 0 ? name : name.substring(index + 1).intern();
    }

    /*
     * Unable to fully structure code
     */
    public static Node getPreviousSibling2(Node node) {
        block6: {
            ret = node.getPreviousSibling();
            if (ret != null) ** GOTO lbl14
            parent = node.getParentNode();
            if (parent == null) {
                return null;
            }
            if (parent.getNodeType() != 5) break block6;
            ret = DOMUtil.getPreviousSibling2(parent);
            break block6;
lbl-1000:
            // 1 sources

            {
                last = ret.getLastChild();
                if (last == null) {
                    ret = DOMUtil.getPreviousSibling2(ret);
                    break;
                }
                ret = last;
lbl14:
                // 2 sources

                ** while (ret.getNodeType() == 5)
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static Node getNextSibling2(Node node) {
        block6: {
            ret = node.getNextSibling();
            if (ret != null) ** GOTO lbl14
            parent = node.getParentNode();
            if (parent == null) {
                return null;
            }
            if (parent.getNodeType() != 5) break block6;
            ret = DOMUtil.getNextSibling2(parent);
            break block6;
lbl-1000:
            // 1 sources

            {
                first = ret.getFirstChild();
                if (first == null) {
                    ret = DOMUtil.getNextSibling2(ret);
                    break;
                }
                ret = first;
lbl14:
                // 2 sources

                ** while (ret.getNodeType() == 5)
            }
        }
        return ret;
    }

    public static Node getFirstChild2(Node node) {
        Node ret = node.getFirstChild();
        while (ret != null && ret.getNodeType() == 5) {
            Node first = ret.getFirstChild();
            if (first == null) {
                ret = DOMUtil.getNextSibling2(ret);
                break;
            }
            ret = first;
        }
        return ret;
    }

    public static Node getLastChild2(Node node) {
        Node ret = node.getLastChild();
        while (ret != null && ret.getNodeType() == 5) {
            Node last = ret.getLastChild();
            if (last == null) {
                ret = DOMUtil.getPreviousSibling2(ret);
                break;
            }
            ret = last;
        }
        return ret;
    }

    public static Element getNextElement(Node element) {
        Node next = element;
        while ((next = DOMUtil.getNextSibling2(next)) != null) {
            if (next.getNodeType() == 1) break;
        }
        return (Element)next;
    }

    public static Element getFirstChildElement(Node parent) {
        Node child = DOMUtil.getFirstChild2(parent);
        while (child != null) {
            if (child.getNodeType() == 1) break;
            child = DOMUtil.getNextSibling2(child);
        }
        return (Element)child;
    }

    public static Element getFirstChildElementNamed(Node parent, String qname) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && child.getNodeName().equals(qname)) break;
            child = DOMUtil.getNextSibling2(child);
        }
        return (Element)child;
    }

    public static Element getFirstChildElementNamed(Node parent, String ns, String local) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                Element el = (Element)child;
                String elns = DOMUtil.getNamespace(el);
                if ((local.equals("*") || DOMUtil.getLocalPart(el).equals(local)) && (ns == null && elns == null || ns != null && ns.equals("*") || ns != null && ns.equals(elns))) break;
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return (Element)child;
    }

    public static boolean checkAllSpaces(String str) {
        int s = 0;
        while (s < str.length()) {
            char ch = str.charAt(s);
            if (ch > ' ' || 0 > " \t\r\n".indexOf(ch)) {
                return false;
            }
            ++s;
        }
        return true;
    }

    public static void writeEscapedAttribute(Writer writer, String string) throws IOException {
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if ('<' == ch) {
                writer.write("&lt;");
            } else if ('&' == ch) {
                writer.write("&amp;");
            } else if ('\t' == ch) {
                writer.write("&#x9;");
            } else if ('\n' == ch) {
                writer.write("&#xA;");
            } else if ('\r' == ch) {
                writer.write("&#xD;");
            } else if ('\"' == ch) {
                writer.write("&quot;");
            } else {
                writer.write(ch);
            }
            ++i;
        }
    }

    public static void writeEscapedCharData(Writer writer, String string) throws IOException {
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if ('<' == ch) {
                writer.write("&lt;");
            } else if ('&' == ch) {
                writer.write("&amp;");
            } else if ('>' == ch) {
                writer.write("&gt;");
            } else if ('\r' == ch) {
                writer.write("&#xD;");
            } else {
                writer.write(ch);
            }
            ++i;
        }
    }

    public static String escapeAttribute(String string) {
        StringBuffer buffer = null;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if ("<&\t\n\r\"".indexOf(ch) >= 0) {
                if (buffer == null) {
                    buffer = new StringBuffer(string.length() * 2);
                    buffer.append(string.substring(0, i));
                }
                if ('<' == ch) {
                    buffer.append("&lt;");
                } else if ('&' == ch) {
                    buffer.append("&amp;");
                } else if ('\t' == ch) {
                    buffer.append("&#x9;");
                } else if ('\n' == ch) {
                    buffer.append("&#xA;");
                } else if ('\r' == ch) {
                    buffer.append("&#xD;");
                } else if ('\"' == ch) {
                    buffer.append("&quot;");
                }
            } else if (buffer != null) {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer == null ? string : new String(buffer);
    }

    public static String escapeCharData(String string) {
        StringBuffer buffer = null;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if ("<&>\r".indexOf(ch) >= 0) {
                if (buffer == null) {
                    buffer = new StringBuffer(string.length() * 2);
                    buffer.append(string.substring(0, i));
                }
                if ('<' == ch) {
                    buffer.append("&lt;");
                } else if ('&' == ch) {
                    buffer.append("&amp;");
                } else if ('>' == ch) {
                    buffer.append("&gt;");
                } else if ('\r' == ch) {
                    buffer.append("&#xD;");
                }
            } else if (buffer != null) {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer == null ? string : new String(buffer);
    }

    public static DocumentBuilder newDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return null;
        }
        return builder;
    }

    public static Document newDocument() {
        return DOMUtil.newDocumentBuilder().newDocument();
    }

    public static String serializeElement(Element elem) throws IOException {
        StringWriter writer = new StringWriter();
        XPathCanonicalizer.serializeSubset(elem, true, (Writer)writer);
        return writer.toString();
    }

    public static void printElement(Element elem) throws IOException {
        System.out.println(DOMUtil.serializeElement(elem));
    }

    public static void replacePrefix(Element el, String ns, String prefix) {
        if (ns == null && el.getNamespaceURI() == null || ns != null && ns.equals(el.getNamespaceURI())) {
            el.setPrefix(prefix);
        }
        Node child = DOMUtil.getFirstChild2(el);
        while (child != null) {
            if (child.getNodeType() == 1) {
                DOMUtil.replacePrefix((Element)child, ns, prefix);
            }
            child = DOMUtil.getNextSibling2(child);
        }
    }

    private static String getIndentText(IndentConfig iconf, int level) {
        String text;
        if (!iconf.doIndentation()) {
            return null;
        }
        int sp = iconf.getUnit() * level;
        if (sp < INDENT_STRINGS.length) {
            text = INDENT_STRINGS[sp];
        } else {
            StringBuffer buffer = new StringBuffer(1 + sp);
            buffer.append(INDENT_STRINGS[INDENT_STRINGS.length - 1]);
            int i = INDENT_STRINGS.length - 1;
            while (i < sp) {
                buffer.append(' ');
                ++i;
            }
            text = new String(buffer);
        }
        return text;
    }

    public static String getSpaces(IndentConfig iconf, int level) {
        if (iconf == null) {
            iconf = DEFAULT_INDENT;
        }
        int sp = iconf.getUnit() * level;
        StringBuffer buffer = new StringBuffer(sp);
        int i = 0;
        while (i < sp) {
            buffer.append(' ');
            ++i;
        }
        return new String(buffer);
    }

    private static Node getIndentNode(Document factory, IndentConfig iconf, int level) {
        return factory.createTextNode(DOMUtil.getIndentText(iconf, level));
    }

    public static void addIndent(Element el, IndentConfig iconf, int level) {
        if (iconf == null) {
            iconf = DEFAULT_INDENT;
        }
        if (!iconf.doIndentation()) {
            return;
        }
        el.appendChild(DOMUtil.getIndentNode(el.getOwnerDocument(), iconf, level));
    }

    public static void addIndentBefore(Element parent, Node next, IndentConfig iconf, int level) {
        if (iconf == null) {
            iconf = DEFAULT_INDENT;
        }
        if (!iconf.doIndentation()) {
            return;
        }
        parent.insertBefore(DOMUtil.getIndentNode(parent.getOwnerDocument(), iconf, level), next);
    }
}

