/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import com.ibm.dom.util.C14nUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class Exclusive2 {
    static final boolean DEBUG = false;

    Exclusive2() {
    }

    public static final void serializeNode(Map prefixList, Node node, boolean comments, Writer wr) throws IOException {
        Map initialDecls = Exclusive2.initializeDecls(node.getParentNode());
        Exclusive2.serializeNode(prefixList, node, comments, initialDecls, null, wr);
        wr.flush();
    }

    private static final void serializeElement(Map prefixList, Node node, boolean comments, Map decls, Map rendered, Writer wr) throws IOException {
        String min;
        Map currentDecls = Exclusive2.putDecls(decls, node);
        HashMap<String, String> rendering = rendered == null ? new HashMap<String, String>() : new HashMap(rendered);
        wr.write("<");
        wr.write(node.getNodeName());
        if ((prefixList != null && prefixList.containsKey("") || node.getPrefix() == null) && !currentDecls.containsKey("xmlns") && rendered != null && rendered.containsKey("xmlns")) {
            wr.write(" xmlns=\"\"");
        }
        do {
            min = null;
            Iterator iter = currentDecls.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                boolean inPrefixList = false;
                if (rendering.containsKey(key) && rendering.get(key).equals(currentDecls.get(key))) continue;
                if (prefixList != null) {
                    String prefix = key.equals("xmlns") ? "" : key.substring(6);
                    inPrefixList = prefixList.containsKey(prefix);
                }
                if (!inPrefixList && !Exclusive2.isVisiblyUtilized(key, node)) continue;
                if (min == null) {
                    min = key;
                    continue;
                }
                if (min.compareTo(key) <= 0) continue;
                min = key;
            }
            if (min == null) continue;
            String v = (String)currentDecls.get(min);
            C14nUtil.serializeAttribute(min, v, wr);
            rendering.put(min, v);
        } while (min != null);
        NamedNodeMap attrs = node.getAttributes();
        int nattrs = attrs.getLength();
        if (nattrs == 1) {
            Node a = attrs.item(0);
            String name = a.getNodeName();
            if (!name.equals("xmlns") && !name.startsWith("xmlns:")) {
                C14nUtil.serializeAttribute(a, wr);
            }
        } else if (nattrs > 1) {
            Node[] array = new Node[nattrs];
            int n = 0;
            int i = 0;
            while (i < nattrs) {
                Node a = attrs.item(i);
                String name = a.getNodeName();
                if (!name.equals("xmlns") && !name.startsWith("xmlns:")) {
                    array[n++] = a;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < n - 1) {
                Node base = array[i2];
                int j = i2 + 1;
                while (j < n) {
                    int comp;
                    Node n2 = array[j];
                    String basens = base.getNamespaceURI();
                    String n2ns = n2.getNamespaceURI();
                    if (basens == null) {
                        basens = "";
                    }
                    if (n2ns == null) {
                        n2ns = "";
                    }
                    if ((comp = basens.compareTo(n2ns)) == 0) {
                        String bln = base.getLocalName();
                        String nln = n2.getLocalName();
                        if (bln == null) {
                            bln = base.getNodeName();
                        }
                        if (nln == null) {
                            nln = n2.getNodeName();
                        }
                        comp = bln.compareTo(nln);
                    }
                    if (comp > 0) {
                        array[j] = base;
                        base = n2;
                        array[i2] = n2;
                    }
                    ++j;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < n) {
                C14nUtil.serializeAttribute(array[i3], wr);
                ++i3;
            }
        }
        wr.write(">");
        Node child = node.getFirstChild();
        while (child != null) {
            Exclusive2.serializeNode(prefixList, child, comments, currentDecls, rendering, wr);
            child = child.getNextSibling();
        }
        wr.write("</");
        wr.write(node.getNodeName());
        wr.write(">");
    }

    private static final void serializeNode(Map prefixList, Node node, boolean comments, Map decls, Map rendered, Writer wr) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                Exclusive2.serializeElement(prefixList, node, comments, decls, rendered, wr);
                break;
            }
            case 3: 
            case 4: {
                C14nUtil.serializeText(node.getNodeValue(), wr);
                break;
            }
            case 5: 
            case 9: {
                Node child = node.getFirstChild();
                while (child != null) {
                    Exclusive2.serializeNode(prefixList, child, comments, decls, rendered, wr);
                    child = child.getNextSibling();
                }
                break;
            }
            case 7: {
                C14nUtil.serializePI(node, wr);
                break;
            }
            case 8: {
                if (!comments) break;
                C14nUtil.serializeComment(node, wr);
                break;
            }
            case 10: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid Node Type: " + node.getNodeType());
            }
        }
    }

    private static final boolean isVisiblyUtilized(String key, Node el) {
        if (key.equals("xmlns")) {
            return el.getPrefix() == null;
        }
        String prefix = key.substring(6);
        if (prefix.equals(el.getPrefix())) {
            return true;
        }
        NamedNodeMap map = el.getAttributes();
        int len = map.getLength();
        int i = 0;
        while (i < len) {
            if (prefix.equals(map.item(i).getPrefix())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final Map initializeDecls(Node node) {
        HashMap<String, String> decls = new HashMap<String, String>();
        while (node != null) {
            NamedNodeMap map = node.getAttributes();
            int len = map == null ? 0 : map.getLength();
            int i = 0;
            while (i < len) {
                Node n = map.item(i);
                String name = n.getNodeName();
                if ((name.startsWith("xmlns:") || name.equals("xmlns")) && !decls.containsKey(name)) {
                    decls.put(name, n.getNodeValue());
                }
                ++i;
            }
            node = node.getParentNode();
        }
        if (decls.containsKey("xmlns") && "".equals(decls.get("xmlns"))) {
            decls.remove("xmlns");
        }
        return decls;
    }

    private static final Map putDecls(Map parent, Node el) {
        HashMap<String, String> newmap = parent == null ? new HashMap<String, String>() : new HashMap(parent);
        NamedNodeMap map = el.getAttributes();
        int len = map.getLength();
        int i = 0;
        while (i < len) {
            Node n = map.item(i);
            String name = n.getNodeName();
            if (name.startsWith("xmlns:")) {
                newmap.put(name, n.getNodeValue());
            } else if (name.equals("xmlns")) {
                if (!n.getNodeValue().equals("")) {
                    newmap.put(name, n.getNodeValue());
                } else {
                    newmap.remove(name);
                }
            }
            ++i;
        }
        return newmap;
    }
}

