/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import com.ibm.dom.util.Exclusive2;
import com.ibm.dom.util.XPathCanonicalizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class ExclusiveCanonicalizer {
    private static final boolean DEBUG = false;

    private ExclusiveCanonicalizer() {
    }

    public static void serializeSubset(Hashtable prefixList, NodeList nodeList, boolean withComments, Writer wr) throws IOException {
        Vector<Object> nodeVector = new Vector<Object>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 2) {
                nodeVector.addElement(node);
                if (node.getNodeType() == 1) {
                    Node attr;
                    Hashtable<String, Node> attributes = new Hashtable<String, Node>();
                    if (i + 1 < nodeList.getLength() && (attr = nodeList.item(i + 1)).getNodeType() == 2 && ((Attr)attr).getOwnerElement() == node) {
                        ++i;
                        while (i < nodeList.getLength()) {
                            node2 = nodeList.item(i);
                            if (node2.getNodeType() != 2 || node != ((Attr)node2).getOwnerElement()) break;
                            attributes.put(node2.getNodeName(), node2);
                            ++i;
                        }
                        if (attributes.containsKey("xmlns") && ((Attr)attributes.get("xmlns")).getNodeValue().length() == 0) {
                            attributes.remove("xmlns");
                        }
                        --i;
                    }
                    nodeVector.addElement(new XPathCanonicalizer.Attributes(node, attributes));
                }
            } else {
                Element owner = ((Attr)node).getOwnerElement();
                Hashtable<String, Node> attributes = new Hashtable<String, Node>();
                while (i < nodeList.getLength()) {
                    node2 = nodeList.item(i);
                    if (node2.getNodeType() != 2 || owner != ((Attr)node2).getOwnerElement()) break;
                    attributes.put(node2.getNodeName(), node2);
                    ++i;
                }
                nodeVector.addElement(new XPathCanonicalizer.Attributes(owner, attributes));
                --i;
            }
            ++i;
        }
        Stack stack = new Stack();
        int i2 = 0;
        while (i2 < nodeVector.size()) {
            ExclusiveCanonicalizer.serializeSubset(stack, prefixList, nodeVector, i2, withComments, wr);
            ++i2;
        }
    }

    private static void serializeSubset(Stack stack, Hashtable prefixList, Vector nodeVector, int i, boolean withComments, Writer wr) throws IOException {
        Node parent;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof XPathCanonicalizer.Attributes) {
            nodeVector.setElementAt(null, i);
            ((XPathCanonicalizer.Attributes)obj).serialize(null, prefixList, null, wr);
            return;
        }
        Node node = (Node)obj;
        short type = node.getNodeType();
        if (type == 9) {
            return;
        }
        if (type != 1) {
            XPathCanonicalizer.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        wr.write(node.getNodeName());
        XPathCanonicalizer.Attributes ancestorAttrs = stack.empty() ? null : (XPathCanonicalizer.Attributes)stack.peek();
        XPathCanonicalizer.Attributes attrs = null;
        int next = i + 1;
        boolean printXmlns = prefixList == null || prefixList.get("") == null ? node.getPrefix() == null : true;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof Node) {
            parent = node.getParentNode();
            if (printXmlns && parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                wr.write(" xmlns=\"\"");
            }
        } else {
            String prefix;
            attrs = (XPathCanonicalizer.Attributes)nodeVector.elementAt(next);
            if (!attrs.contains("xmlns")) {
                parent = node.getParentNode();
                if (printXmlns && parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                    wr.write(" xmlns=\"\"");
                }
            }
            if ((prefix = node.getPrefix()) == null) {
                prefix = "";
            }
            attrs.serialize(stack, prefixList, prefix, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        stack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!XPathCanonicalizer.isAncestor(nodeVector.elementAt(next), node)) break;
            ExclusiveCanonicalizer.serializeSubset(stack, prefixList, nodeVector, next, withComments, wr);
            nodeVector.setElementAt(null, next++);
        }
        stack.pop();
        wr.write("</");
        wr.write(node.getNodeName());
        wr.write(">");
    }

    public static void serializeAll(Hashtable prefixList, Document doc, boolean withComments, Writer wr) throws IOException {
        Exclusive2.serializeNode(prefixList, doc, withComments, wr);
    }

    public static void serializeSubset(Hashtable prefixList, Node node, boolean withComments, Writer wr) throws IOException {
        Exclusive2.serializeNode(prefixList, node, withComments, wr);
    }

    /*
     * WARNING - void declaration
     */
    public static void serializeSubset(Hashtable prefixList, NodeIterator iter, boolean withComments, Writer wr) throws IOException {
        Node n;
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        while ((n = iter.nextNode()) != null) {
            void var5_5;
            list.add((Node)var5_5);
        }
        ExclusiveCanonicalizer.serializeSubset(prefixList, list, withComments, wr);
    }

    public static byte[] serializeAll(Hashtable prefixList, Document doc, boolean withComments) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            Exclusive2.serializeNode(prefixList, doc, withComments, wr);
            ((Writer)wr).close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static byte[] serializeSubset(Hashtable prefixList, Node node, boolean withComments) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            Exclusive2.serializeNode(prefixList, node, withComments, wr);
            ((Writer)wr).close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static byte[] serializeSubset(Hashtable prefixList, NodeIterator iter, boolean withComments) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            ExclusiveCanonicalizer.serializeSubset(prefixList, iter, withComments, (Writer)wr);
            ((Writer)wr).close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static byte[] serializeSubset(Hashtable prefixList, NodeList nodeList, boolean withComments) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            ExclusiveCanonicalizer.serializeSubset(prefixList, nodeList, withComments, (Writer)wr);
            ((Writer)wr).close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static Hashtable parsePrefixList(String ssv) {
        Hashtable<String, String> prefixList = null;
        if (ssv == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(ssv, " \t\r\n");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (prefixList == null) {
                prefixList = new Hashtable<String, String>();
            }
            if (tok.equals("#default")) {
                tok = "";
            }
            prefixList.put(tok, tok);
        }
        return prefixList;
    }
}

