/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import com.ibm.dom.util.NOOPVisitor;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class PrintNodeTreeVisitor
extends NOOPVisitor {
    protected Writer writer = null;
    protected int indent = 0;
    protected int dx = 2;

    public PrintNodeTreeVisitor(Writer writer) {
        this.writer = writer;
    }

    public void visitElementPre(Element node) throws Exception {
        this.indent();
        this.writer.write("[Element] " + node.getNodeName() + "\n");
        this.indent += this.dx;
    }

    public void visitElementPost(Element node) throws Exception {
        this.indent -= this.dx;
    }

    public void visitTextPre(Text node) throws Exception {
        this.indent();
        this.writer.write("[Text] \"");
        this.printText(node.getNodeValue());
        this.writer.write("\"\n");
    }

    public void visitCDATASectionPre(CDATASection node) throws Exception {
        this.indent();
        this.writer.write("[CDATASection] \"" + node.getNodeValue() + "\"\n");
    }

    public void visitEntityReferencePre(EntityReference node) throws Exception {
        this.indent();
        this.writer.write("[EntityReference] &" + node.getNodeName() + ";\n");
    }

    public void visitEntityPre(Entity node) throws Exception {
        this.indent();
        this.writer.write("[Entity] " + node.getNodeName() + "\n");
    }

    public void visitProcessingInstructionPre(ProcessingInstruction node) throws Exception {
        this.indent();
        this.writer.write("[ProcessingInstruction] " + node.getNodeName() + " \"");
        this.printText(node.getNodeValue());
        this.writer.write("\"\n");
    }

    public void visitCommentPre(Comment node) throws Exception {
        this.indent();
        this.writer.write("[Comment] \"" + node.getNodeValue() + "\"\n");
    }

    public void visitDocumentPre(Document node) throws Exception {
        this.indent();
        this.writer.write("[Document]\n");
        this.indent += this.dx;
    }

    public void visitDocumentPost(Document node) throws Exception {
        this.indent -= this.dx;
        this.writer.flush();
    }

    public void visitDocumentTypePre(DocumentType node) throws Exception {
        this.indent();
        this.writer.write("[DocumentType] " + node.getNodeValue() + "\n");
    }

    public void visitDocumentFragmentPre(DocumentFragment node) throws Exception {
        this.indent();
        this.writer.write("[DocumentFragment]\n");
    }

    public void visitNotationPre(Notation node) throws Exception {
        this.indent();
        this.writer.write("[Notation]\n");
    }

    public void visitUnknownPre(Node node) throws Exception {
        this.indent();
        this.writer.write("[???Unknown]\n");
    }

    protected void indent() throws IOException {
        int i = 0;
        while (i < this.indent) {
            this.writer.write(" ");
            ++i;
        }
    }

    protected void printText(String str) throws IOException {
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\r': {
                    this.writer.write("&#x0d;");
                    break;
                }
                case '\n': {
                    this.writer.write("&#x0a;");
                    break;
                }
                case '\"': {
                    this.writer.write("&#x22;");
                    break;
                }
                default: {
                    this.writer.write(ch);
                }
            }
            ++i;
        }
    }
}

