/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import com.ibm.dom.util.NOOPVisitor;
import com.ibm.dom.util.TreeTraversal;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class ToXMLVisitor
extends NOOPVisitor {
    protected Writer writer = null;
    protected String encoding = null;
    protected boolean isPrintNonSpecifiedAttributes = true;

    public ToXMLVisitor(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    public ToXMLVisitor(Writer writer) {
        this(writer, null);
    }

    public void setPrintNonSpecifiedAttributes(boolean print) {
        this.isPrintNonSpecifiedAttributes = print;
    }

    public boolean getPrintNonSpecifiedAttributes() {
        return this.isPrintNonSpecifiedAttributes;
    }

    public void visitDocumentPre(Document document) throws Exception {
        this.writer.write("<?xml version=\"1.0\"?>");
    }

    public void visitDocumentPost(Document document) throws Exception {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitElementPre(Element element) throws Exception {
        NamedNodeMap nnm;
        this.writer.write("<");
        this.writer.write(element.getTagName());
        NamedNodeMap namedNodeMap = nnm = element.getAttributes();
        synchronized (namedNodeMap) {
            int i = 0;
            while (i < nnm.getLength()) {
                Attr attr = (Attr)nnm.item(i);
                if (this.isPrintNonSpecifiedAttributes || attr.getSpecified()) {
                    this.visitAttributePre(attr);
                }
                ++i;
            }
        }
        if (element.hasChildNodes()) {
            this.writer.write(">");
        } else {
            this.writer.write("/>");
        }
    }

    public void visitElementPost(Element element) throws Exception {
        if (element.hasChildNodes()) {
            this.writer.write("</");
            this.writer.write(element.getTagName());
            this.writer.write(">");
        }
    }

    public void visitAttributePre(Attr attribute) throws Exception {
        this.writer.write(" ");
        this.writer.write(attribute.getName());
        this.writer.write("=\"");
        Node child = attribute.getFirstChild();
        while (child != null) {
            short type = child.getNodeType();
            if (type == 3) {
                this.escapedWrite(this.writer, child.getNodeValue(), "<&\"", this.encoding);
            } else if (type == 5) {
                this.writer.write("&");
                this.writer.write(child.getNodeName());
                this.writer.write(";");
            }
            child = child.getNextSibling();
        }
        this.writer.write("\"");
    }

    public void visitProcessingInstructionPre(ProcessingInstruction pi) throws Exception {
        this.writer.write("<?");
        this.writer.write(pi.getNodeName());
        String data = pi.getData();
        if (pi.getData().length() > 0) {
            this.writer.write(" ");
            this.writer.write(pi.getData());
        }
        this.writer.write("?>");
    }

    public void visitCommentPre(Comment comment) throws Exception {
        this.writer.write("<!--");
        this.writer.write(comment.getData());
        this.writer.write("-->");
    }

    public void visitTextPre(Text text) throws Exception {
        this.escapedWrite(this.writer, text.getData(), "<&", this.encoding);
    }

    public void visitCDATASectionPre(CDATASection cdata) throws Exception {
        this.writer.write("<![CDATA[");
        this.writer.write(cdata.getData());
        this.writer.write("]]>");
    }

    public void visitDocumentTypePre(DocumentType doctype) throws Exception {
        this.writer.write("<!DOCTYPE ");
        this.writer.write(doctype.getName());
        this.writer.write(">");
    }

    public void visitEntityReference(EntityReference ref) throws Exception {
        this.writer.write("&");
        this.writer.write(ref.getNodeName());
        this.writer.write(";");
        throw new TreeTraversal.ToNextSiblingTraversalException();
    }

    public void escapedWrite(Writer writer, String string, String encoding) throws IOException {
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if ('<' == ch) {
                writer.write("&lt;");
            } else if ('>' == ch) {
                writer.write("&gt;");
            } else if ('&' == ch) {
                writer.write("&amp;");
            } else if ('\ud800' <= ch && ch < '\udc00') {
                int next;
                if (i + 1 >= string.length()) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " ?");
                }
                if (56320 > (next = string.charAt(++i)) || next >= 57344) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " " + Integer.toHexString(next));
                }
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                writer.write("&#x");
                writer.write(Integer.toHexString(next));
                writer.write(";");
            } else {
                writer.write(ch);
            }
            ++i;
        }
    }

    public void escapedWrite(Writer writer, String string, String specials, String encoding) throws IOException {
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            int index = specials.indexOf(ch);
            if (index >= 0) {
                writer.write("&#");
                writer.write(Integer.toString(ch));
                writer.write(";");
            } else if ('\ud800' <= ch && ch < '\udc00') {
                int next;
                if (i + 1 >= string.length()) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " ?");
                }
                if (56320 > (next = string.charAt(++i)) || next >= 57344) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " " + Integer.toHexString(next));
                }
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                writer.write("&#x");
                writer.write(Integer.toHexString(next));
                writer.write(";");
            } else {
                writer.write(ch);
            }
            ++i;
        }
    }
}

