/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.xml.dsig.Canonicalizer;
import com.ibm.xml.dsig.SignatureMethod;
import com.ibm.xml.dsig.Transform;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Hashtable;

public class AlgorithmFactory {
    protected String provider;
    protected Hashtable signatureMethodTable;
    protected Hashtable digestMethodTable;
    protected Hashtable transformTable;
    protected Hashtable canonicalizerTable;

    public AlgorithmFactory(String provider) {
        this.provider = provider;
        this.signatureMethodTable = new Hashtable();
        this.signatureMethodTable.put("http://www.w3.org/2000/09/xmldsig#dsa-sha1", "SHA1withDSA");
        this.signatureMethodTable.put("http://www.w3.org/2000/09/xmldsig#dsa", "SHA1withDSA");
        this.signatureMethodTable.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "SHA1withRSA");
        this.digestMethodTable = new Hashtable();
        this.digestMethodTable.put("http://www.w3.org/2000/09/xmldsig#sha1", "SHA");
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmldsig-more#md5", "md5");
        this.transformTable = new Hashtable();
        this.transformTable.put("http://www.w3.org/TR/1999/WD-xml-c14n-19991115", "com.ibm.xml.dsig.transform.W3CCanonicalizer");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000119", "com.ibm.xml.dsig.transform.W3CCanonicalizer");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000601", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#", "com.ibm.xml.dsig.transform.ExclusiveC11r");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "com.ibm.xml.dsig.transform.ExclusiveC11rWC");
        this.transformTable.put("http://www.w3.org/2000/09/xmldsig#base64", "com.ibm.xml.dsig.transform.Base64Transformer");
        this.transformTable.put("http://www.w3.org/2000/09/xmldsig#enveloped-signature", "com.ibm.xml.dsig.transform.Enveloped");
        this.transformTable.put("http://www.w3.org/TR/1999/REC-xslt-19991116", "com.ibm.xml.dsig.transform.XSLTTransformer");
        this.transformTable.put("http://www.w3.org/TR/1999/REC-xpath-19991116", "com.ibm.xml.dsig.transform.XPathTransformer");
        this.canonicalizerTable = new Hashtable();
        this.canonicalizerTable.put("http://www.w3.org/TR/1999/WD-xml-c14n-19991115", "com.ibm.xml.dsig.transform.W3CCanonicalizer");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000119", "com.ibm.xml.dsig.transform.W3CCanonicalizer");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000601", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/2001/10/xml-exc-c14n#", "com.ibm.xml.dsig.transform.ExclusiveC11r");
        this.canonicalizerTable.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "com.ibm.xml.dsig.transform.ExclusiveC11rWC");
    }

    public String getProvider() {
        return this.provider;
    }

    public SignatureMethod getSignatureMethod(String uri, Object parameter) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (uri == null) {
            throw new NoSuchAlgorithmException("No SignatureMethod for null.");
        }
        if (uri.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
            return new SignatureMethod.SignatureMethodHMAC((Integer)parameter);
        }
        String name = (String)this.signatureMethodTable.get(uri);
        if (name == null) {
            throw new NoSuchAlgorithmException("No SignatureMethod for " + uri);
        }
        return new SignatureMethod.SignatureMethodImpl(name, uri, this.provider);
    }

    public MessageDigest getDigestMethod(String uri) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (uri == null) {
            throw new NoSuchAlgorithmException("null parameter.");
        }
        String algName = (String)this.digestMethodTable.get(uri);
        if (algName == null) {
            throw new NoSuchAlgorithmException("No DigestMethod for " + uri);
        }
        return this.provider == null ? MessageDigest.getInstance(algName) : MessageDigest.getInstance(algName, this.provider);
    }

    public Transform getTransform(String uri) throws NoSuchAlgorithmException {
        Object obj;
        if (uri == null) {
            throw new NoSuchAlgorithmException("null parameter.");
        }
        String className = (String)this.transformTable.get(uri);
        if (className == null) {
            throw new NoSuchAlgorithmException("Unknown algorithm URI: " + uri);
        }
        try {
            obj = Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae.getMessage());
        }
        return (Transform)obj;
    }

    public Canonicalizer getCanonicalizer(String uri) {
        Object obj;
        if (uri == null) {
            return null;
        }
        String className = (String)this.canonicalizerTable.get(uri);
        if (className == null) {
            return null;
        }
        try {
            obj = Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (InstantiationException ie) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
        return (Canonicalizer)obj;
    }
}

