/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.xml.dsig.KeyInfo;
import com.ibm.xml.dsig.SignatureStructureException;
import com.ibm.xml.dsig.XSignatureException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.security.cert.CertPath;
import javax.security.cert.CertPathBuilder;
import javax.security.cert.CertPathBuilderException;
import javax.security.cert.CertPathParameters;
import javax.security.cert.CertPathValidator;
import javax.security.cert.CertPathValidatorException;
import javax.security.cert.CertStore;
import javax.security.cert.CertStoreParameters;
import javax.security.cert.CertificateFactory;
import javax.security.cert.CollectionCertStoreParameters;
import javax.security.cert.PKIXBuilderParameters;
import javax.security.cert.PKIXParameters;
import javax.security.cert.X509CertSelector;
import org.w3c.dom.Element;

public class CertUtil {
    public static final int CHAINS_ANY = 100;
    public static final int CHAINS_ALL = 101;

    public static Key verify(Element signature, int chainsFlag, PKIXParameters params) throws XSignatureException {
        return CertUtil.verifyAndGetCert(signature, chainsFlag, params).getPublicKey();
    }

    public static X509Certificate verifyAndGetCert(Element signature, int chainsFlag, PKIXParameters params) throws XSignatureException {
        Key publicKey;
        KeyInfo.X509Data[] x5data;
        X509Certificate cert = null;
        byte[] encodedKey = null;
        try {
            KeyInfo keyInfo = CertUtil.getKeyInfo(signature);
            x5data = keyInfo.getX509Data();
            if (x5data == null || x5data.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            publicKey = keyInfo.getKeyValue();
            if (publicKey != null) {
                encodedKey = publicKey.getEncoded();
            }
        }
        catch (SignatureStructureException sse) {
            throw new XSignatureException(sse);
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance((String)"X.509", (String)"IBMCertPath");
            CertPathValidator validator = CertPathValidator.getInstance((String)"PKIX");
            CertPathValidatorException exception = null;
            int i = 0;
            while (i < x5data.length) {
                List certList = CertUtil.orderCertificates(x5data[i].getCertificates());
                if (certList.size() == 0) {
                    if (chainsFlag != 100) {
                        throw new CertPathValidatorException("Incomplete certificate chain.");
                    }
                } else {
                    cert = (X509Certificate)certList.get(0);
                    PublicKey ckey = cert.getPublicKey();
                    if (encodedKey == null) {
                        publicKey = ckey;
                        encodedKey = ckey.getEncoded();
                    } else if (!MessageDigest.isEqual(encodedKey, ckey.getEncoded())) {
                        throw new CertPathValidatorException("A certificate has different key.");
                    }
                    CertPath certPath = factory.generateCertPath(certList);
                    if (chainsFlag == 101) {
                        validator.validate(certPath, (CertPathParameters)params);
                    } else {
                        try {
                            validator.validate(certPath, (CertPathParameters)params);
                            return cert;
                        }
                        catch (CertPathValidatorException cpve) {
                            exception = cpve;
                        }
                    }
                }
                ++i;
            }
            if (chainsFlag == 101) {
                return cert;
            }
            if (exception == null) {
                throw new CertPathValidatorException("No valid certificate chain.");
            }
            throw new CertPathValidatorException("No valid certificate chain: Last exception: " + exception);
        }
        catch (GeneralSecurityException gse) {
            throw new XSignatureException(gse);
        }
    }

    public static X509DataUtil[] getX509Data(Element signature) throws XSignatureException {
        try {
            KeyInfo keyInfo = CertUtil.getKeyInfo(signature);
            KeyInfo.X509Data[] x5data = keyInfo.getX509Data();
            if (x5data == null || x5data.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            Key k = keyInfo.getKeyValue();
            X509DataUtil[] x5u = new X509DataUtil[x5data.length];
            int i = 0;
            while (i < x5data.length) {
                x5u[i] = new X509DataUtil(x5data[i], k);
                ++i;
            }
            return x5u;
        }
        catch (SignatureStructureException sse) {
            throw new XSignatureException(sse);
        }
    }

    public static List orderCertificates(X509Certificate[] certs) throws CertPathValidatorException {
        LinkedList<X509Certificate> list = new LinkedList<X509Certificate>();
        if (certs == null || certs.length == 0) {
            return list;
        }
        if (certs.length == 1) {
            list.add(certs[0]);
            return list;
        }
        X509Certificate[] certs2 = new X509Certificate[certs.length];
        System.arraycopy(certs, 0, certs2, 0, certs.length);
        int i = 0;
        while (i < certs2.length) {
            Principal subject = certs2[i].getSubjectDN();
            boolean found = false;
            int j = 0;
            while (j < certs.length) {
                Principal issuer;
                if (j != i && subject.equals(issuer = certs2[j].getIssuerDN())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                list.add(certs2[i]);
                certs2[i] = null;
                break;
            }
            ++i;
        }
        if (list.size() == 0) {
            return list;
        }
        Principal issuer = ((X509Certificate)list.get(0)).getIssuerDN();
        int remains = certs2.length - 1;
        while (remains > 0) {
            boolean found = false;
            int i2 = 0;
            while (i2 < certs2.length) {
                X509Certificate c = certs2[i2];
                if (c != null && c.getSubjectDN().equals(issuer)) {
                    found = true;
                    list.add(c);
                    certs2[i2] = null;
                    --remains;
                    issuer = c.getIssuerDN();
                    break;
                }
                ++i2;
            }
            if (found) continue;
            throw new CertPathValidatorException("The chain is incomplete: No certificate of an issuer `" + issuer + "'");
        }
        return list;
    }

    private static KeyInfo getKeyInfo(Element signature) throws SignatureStructureException, XSignatureException {
        Element keyInfoElement = KeyInfo.searchForKeyInfo(signature);
        if (keyInfoElement == null) {
            throw new SignatureStructureException("No KeyInfo element.");
        }
        return new KeyInfo(keyInfoElement);
    }

    public static class X509DataUtil {
        KeyInfo.X509Data x5data;
        CertStore docStore = null;
        Key publicKey;

        public X509DataUtil(KeyInfo.X509Data x5d, Key k) {
            this.x5data = x5d;
            this.publicKey = k;
        }

        private CertStore createCertStore() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
            Vector<X509Certificate> certs = new Vector<X509Certificate>();
            X509Certificate[] srccerts = this.x5data.getCertificates();
            if (srccerts != null) {
                int j = 0;
                while (j < srccerts.length) {
                    certs.addElement(srccerts[j]);
                    ++j;
                }
            }
            return CertStore.getInstance((String)"Collection", (CertStoreParameters)new CollectionCertStoreParameters(certs));
        }

        public Key validate(PKIXBuilderParameters params) throws XSignatureException {
            return this.validateAndGetCert(params).getPublicKey();
        }

        public X509Certificate validateAndGetCert(PKIXBuilderParameters params) throws XSignatureException {
            CertPath path;
            List storeList = params.getCertStores();
            ArrayList newList = new ArrayList((storeList == null ? 0 : storeList.size()) + 1);
            int i = 0;
            while (i < storeList.size()) {
                newList.add(storeList.get(i));
                ++i;
            }
            try {
                newList.add(this.createCertStore());
                params.setCertStores(newList);
                CertPathBuilder builder = CertPathBuilder.getInstance((String)"PKIX");
                CertPathValidator validator = CertPathValidator.getInstance((String)"PKIX");
                path = builder.build((CertPathParameters)params).getCertPath();
                validator.validate(path, (CertPathParameters)params);
            }
            catch (InvalidAlgorithmParameterException iape) {
                params.setCertStores(storeList);
                throw new XSignatureException(iape);
            }
            catch (NoSuchAlgorithmException nsae) {
                params.setCertStores(storeList);
                throw new XSignatureException(nsae);
            }
            catch (CertPathBuilderException cpbe) {
                params.setCertStores(storeList);
                throw new XSignatureException((Exception)((Object)cpbe));
            }
            catch (CertPathValidatorException cpve) {
                params.setCertStores(storeList);
                throw new XSignatureException((Exception)((Object)cpve));
            }
            List certs = path.getCertificates();
            return certs.isEmpty() ? null : (X509Certificate)certs.get(0);
        }

        public X509CertSelector createSelector() throws IOException {
            X509Certificate[] certs;
            String[] subjects;
            X509CertSelector selector = new X509CertSelector();
            String[] issuers = this.x5data.getIssuerNames();
            if (issuers != null && issuers.length > 0) {
                BigInteger[] serials = this.x5data.getSerialNumbers();
                selector.setIssuer(issuers[0]);
                selector.setSerialNumber(serials[0]);
            }
            if ((subjects = this.x5data.getSubjectNames()) != null && subjects.length > 0) {
                selector.setSubject(subjects[0]);
            } else {
                X509Certificate[] certs2 = this.x5data.getCertificates();
                if (certs2 != null && certs2.length > 0) {
                    selector.setSubject(certs2[0].getSubjectDN().getName());
                }
            }
            Object[] skis = this.x5data.getSKIs();
            if (skis != null && skis.length > 0) {
                selector.setSubjectKeyIdentifier((byte[])skis[0]);
            }
            if ((certs = this.x5data.getCertificates()) != null && certs.length == 1) {
                selector.setCertificate(certs[0]);
            }
            if (this.publicKey != null) {
                selector.setSubjectPublicKey(this.publicKey.getEncoded());
            }
            return selector;
        }
    }
}

