/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.dom.util.DOMUtil;
import com.ibm.dom.util.IndentConfig;
import com.ibm.xml.dsig.KeyInfoGenerator;
import com.ibm.xml.dsig.ProcessKey;
import com.ibm.xml.dsig.SignatureStructureException;
import com.ibm.xml.dsig.XSignature;
import com.ibm.xml.dsig.XSignatureException;
import com.ibm.xml.dsig.util.Base64;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyInfo
implements KeyInfoGenerator {
    public static final String DSAKEYVALUE = "http://www.w3.org/2000/09/xmldsig#DSAKeyValue";
    public static final String RSAKEYVALUE = "http://www.w3.org/2000/09/xmldsig#RSAKeyValue";
    public static final String X509DATA = "http://www.w3.org/2000/09/xmldsig#X509Data";
    public static final String PGPDATA = "http://www.w3.org/2000/09/xmldsig#PGPData";
    public static final String SPKIDATA = "http://www.w3.org/2000/09/xmldsig#SPKIData";
    public static final String MGMTDATA = "http://www.w3.org/2000/09/xmldsig#MgmtData";
    public static final String RAWX509CERT = "http://www.w3.org/2000/09/xmldsig#rawX509Certificate";
    Element keyInfo = null;
    String[] keyNames = null;
    Key keyValue = null;
    X509Data[] x5data = null;
    PGPData[] pgpData = null;
    SPKIData[] spkiData = null;
    String[] mgmtData = null;
    Element[] unknowns = null;
    Element[] rmethods = null;

    public static Element searchForKeyInfo(Element signature) {
        Element keyInfo = null;
        Node ch = DOMUtil.getFirstChild2(signature);
        while (ch != null) {
            Element el;
            if (ch.getNodeType() == 1 && XSignature.isDsigElement(el = (Element)ch, "KeyInfo")) {
                keyInfo = el;
                break;
            }
            ch = DOMUtil.getNextSibling2(ch);
        }
        return keyInfo;
    }

    public KeyInfo(Element keyInfo) throws XSignatureException {
        this.keyInfo = keyInfo;
        try {
            this.traverse();
        }
        catch (Exception ex) {
            throw new XSignatureException(ex);
        }
    }

    public KeyInfo() {
    }

    public Element getKeyInfo() {
        return this.keyInfo;
    }

    public Element getKeyInfoElement(Document factory) {
        return this.getKeyInfoElement(factory, DOMUtil.DEFAULT_INDENT);
    }

    public Element getKeyInfoElement(Document factory, IndentConfig iconf) {
        int i;
        Element ki = factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (this.keyNames != null && this.keyNames.length > 0) {
            i = 0;
            while (i < this.keyNames.length) {
                DOMUtil.addIndent(ki, iconf, 2);
                ki.appendChild(DOMUtil.createTextElementNS(factory, "http://www.w3.org/2000/09/xmldsig#", "KeyName", this.keyNames[i]));
                ++i;
            }
        }
        if (this.keyValue != null) {
            DOMUtil.addIndent(ki, iconf, 2);
            ki.appendChild(ProcessKey.createKeyValue(factory, iconf, this.keyValue));
        }
        if (this.x5data != null && this.x5data.length > 0) {
            i = 0;
            while (i < this.x5data.length) {
                DOMUtil.addIndent(ki, iconf, 2);
                ki.appendChild(this.x5data[i].createNode(factory, iconf));
                ++i;
            }
        }
        if (this.pgpData != null && this.pgpData.length > 0) {
            i = 0;
            while (i < this.pgpData.length) {
                DOMUtil.addIndent(ki, iconf, 2);
                ki.appendChild(this.pgpData[i].createNode(factory, iconf));
                ++i;
            }
        }
        if (this.spkiData != null && this.spkiData.length > 0) {
            i = 0;
            while (i < this.spkiData.length) {
                DOMUtil.addIndent(ki, iconf, 2);
                ki.appendChild(this.spkiData[i].createNode(factory, iconf));
                ++i;
            }
        }
        if (this.mgmtData != null && this.mgmtData.length > 0) {
            i = 0;
            while (i < this.mgmtData.length) {
                DOMUtil.addIndent(ki, iconf, 2);
                ki.appendChild(DOMUtil.createTextElementNS(factory, "http://www.w3.org/2000/09/xmldsig#", "MgmtData", this.mgmtData[i]));
                ++i;
            }
        }
        if (this.unknowns != null && this.unknowns.length > 0) {
            i = 0;
            while (i < this.unknowns.length) {
                DOMUtil.addIndent(ki, iconf, 2);
                ki.appendChild(this.unknowns[i]);
                ++i;
            }
        }
        DOMUtil.addIndent(ki, iconf, 1);
        return ki;
    }

    public void insertTo(Element signature) throws SignatureStructureException {
        this.insertTo(signature, null);
    }

    public void insertTo(Element signature, String prefix) throws SignatureStructureException {
        this.insertTo(signature, prefix, DOMUtil.DEFAULT_INDENT);
    }

    public void insertTo(Element signature, String prefix, IndentConfig iconf) throws SignatureStructureException {
        Element signatureValue = XSignature.getFirstChild(signature, "SignatureValue");
        if (signatureValue == null) {
            throw new SignatureStructureException("The Signature element has no SignatureValue element.");
        }
        Node next = signatureValue.getNextSibling();
        Document factory = signature.getOwnerDocument();
        Element keyInfo = this.getKeyInfoElement(factory, iconf);
        if (prefix == null) {
            if (!signature.getTagName().equals("Signature")) {
                keyInfo.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
            }
        } else {
            DOMUtil.replacePrefix(keyInfo, "http://www.w3.org/2000/09/xmldsig#", prefix);
            if (!prefix.equals(signature.getPrefix())) {
                keyInfo.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, "http://www.w3.org/2000/09/xmldsig#");
            }
            if ("http://www.w3.org/2000/09/xmldsig#".equals(keyInfo.getAttribute("xmlns"))) {
                keyInfo.removeAttribute("xmlns");
            }
        }
        DOMUtil.addIndentBefore(signature, next, iconf, 1);
        signature.insertBefore(keyInfo, next);
    }

    private void traverse() throws CertificateException, CRLException, SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        Vector<String> keynamev = null;
        Vector<X509Data> x5v = null;
        Vector<Element> rmv = null;
        Vector<PGPData> pgpv = null;
        Vector<SPKIData> spkiv = null;
        Vector<String> mgmtv = null;
        Vector<Element> unknownv = null;
        Node ch = DOMUtil.getFirstChild2(this.keyInfo);
        while (ch != null) {
            Element el;
            if (ch.getNodeType() == 1 && XSignature.isDsigElement(el = (Element)ch)) {
                if (XSignature.isDsigElement(el, "KeyValue")) {
                    if (this.keyValue != null) {
                        throw new SignatureStructureException("Multiple KeyValue elements.");
                    }
                    this.keyValue = ProcessKey.createKey(el);
                } else if (XSignature.isDsigElement(el, "KeyName")) {
                    if (keynamev == null) {
                        keynamev = new Vector<String>();
                    }
                    keynamev.addElement(DOMUtil.getStringValue(el));
                } else if (XSignature.isDsigElement(el, "RetrievalMethod")) {
                    if (rmv == null) {
                        rmv = new Vector<Element>();
                    }
                    rmv.addElement(el);
                } else if (XSignature.isDsigElement(el, "X509Data")) {
                    if (x5v == null) {
                        x5v = new Vector<X509Data>();
                    }
                    x5v.addElement(new X509Data(el));
                } else if (XSignature.isDsigElement(el, "PGPData")) {
                    if (pgpv == null) {
                        pgpv = new Vector<PGPData>();
                    }
                    pgpv.addElement(new PGPData(el));
                } else if (XSignature.isDsigElement(el, "SPKIData")) {
                    if (spkiv == null) {
                        spkiv = new Vector<SPKIData>();
                    }
                    spkiv.addElement(new SPKIData(el));
                } else if (XSignature.isDsigElement(el, "MgmtData")) {
                    if (mgmtv == null) {
                        mgmtv = new Vector<String>();
                    }
                    mgmtv.addElement(DOMUtil.getStringValue(el));
                } else {
                    if (unknownv == null) {
                        unknownv = new Vector<Element>();
                    }
                    unknownv.addElement(el);
                }
            }
            ch = DOMUtil.getNextSibling2(ch);
        }
        if (keynamev != null && keynamev.size() > 0) {
            this.keyNames = new String[keynamev.size()];
            int i = 0;
            while (i < keynamev.size()) {
                this.keyNames[i] = (String)keynamev.elementAt(i);
                ++i;
            }
        }
        if (x5v != null && x5v.size() > 0) {
            this.x5data = new X509Data[x5v.size()];
            int i = 0;
            while (i < x5v.size()) {
                this.x5data[i] = (X509Data)x5v.elementAt(i);
                ++i;
            }
        }
        if (pgpv != null && pgpv.size() > 0) {
            this.pgpData = new PGPData[pgpv.size()];
            int i = 0;
            while (i < pgpv.size()) {
                this.pgpData[i] = (PGPData)pgpv.elementAt(i);
                ++i;
            }
        }
        if (spkiv != null && spkiv.size() > 0) {
            this.spkiData = new SPKIData[spkiv.size()];
            int i = 0;
            while (i < spkiv.size()) {
                this.spkiData[i] = (SPKIData)spkiv.elementAt(i);
                ++i;
            }
        }
        if (mgmtv != null && mgmtv.size() > 0) {
            this.mgmtData = new String[mgmtv.size()];
            int i = 0;
            while (i < mgmtv.size()) {
                this.mgmtData[i] = (String)mgmtv.elementAt(i);
                ++i;
            }
        }
        if (rmv != null && rmv.size() > 0) {
            this.rmethods = new Element[rmv.size()];
            int i = 0;
            while (i < rmv.size()) {
                this.rmethods[i] = (Element)rmv.elementAt(i);
                ++i;
            }
        }
        if (unknownv != null && unknownv.size() > 0) {
            this.unknowns = new Element[unknownv.size()];
            int i = 0;
            while (i < unknownv.size()) {
                this.unknowns[i] = (Element)unknownv.elementAt(i);
                ++i;
            }
        }
    }

    public Element[] getRetrievalMethods() {
        return this.rmethods;
    }

    public String[] getKeyNames() {
        return this.keyNames;
    }

    public void setKeyNames(String[] names) {
        this.keyNames = names;
    }

    public Key getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(Key key) {
        this.keyValue = key;
    }

    public X509Data[] getX509Data() {
        return this.x5data;
    }

    public void setX509Data(X509Data[] xdata) {
        this.x5data = xdata;
    }

    public PGPData[] getPGPData() {
        return this.pgpData;
    }

    public void setPGPData(PGPData[] pdata) {
        this.pgpData = pdata;
    }

    public SPKIData[] getSPKIData() {
        return this.spkiData;
    }

    public void setSPKIData(SPKIData[] sdata) {
        this.spkiData = sdata;
    }

    public String[] getMgmtData() {
        return this.mgmtData;
    }

    public void setMgmtData(String[] mgmts) {
        this.mgmtData = mgmts;
    }

    public Element[] getUnknownChildren() {
        return this.unknowns;
    }

    public void setUnknownChildren(Element[] elems) {
        this.unknowns = elems;
    }

    private static byte[] convertBoolean2Binary(boolean[] bools) {
        int binsize = bools.length >> 3;
        if ((bools.length & 7) != 0) {
            ++binsize;
        }
        byte[] bin = new byte[binsize];
        byte b = 0;
        int i = 0;
        while (i < binsize << 3) {
            int r = i & 7;
            if (i < bools.length && bools[i]) {
                b = (byte)(b | 1 << 7 - r);
            }
            if (r == 7) {
                bin[i >> 3] = b;
                b = 0;
            }
            ++i;
        }
        return bin;
    }

    public static class X509Data {
        String[] issuerNames = null;
        BigInteger[] serialNumbers = null;
        Object[] skis = null;
        String[] subjectNames = null;
        X509Certificate[] certs = null;
        X509CRL crl = null;
        private static final String OID_KEYIDENTIFIER = "2.5.29.14";

        X509Data(Element x5data) throws CertificateException, CRLException, SignatureStructureException {
            Vector<Object> isVector = null;
            Vector<byte[]> skiVector = null;
            Vector<String> snVector = null;
            Vector<X509Certificate> certsVector = null;
            CertificateFactory certFactory = null;
            Node x5 = DOMUtil.getFirstChild2(x5data);
            while (x5 != null) {
                Element x5Element;
                if (x5.getNodeType() == 1 && XSignature.isDsigElement(x5Element = (Element)x5)) {
                    ByteArrayInputStream bais;
                    if (XSignature.isDsigElement(x5Element, "X509Certificate")) {
                        if (certsVector == null) {
                            certsVector = new Vector<X509Certificate>();
                        }
                        if (certFactory == null) {
                            certFactory = CertificateFactory.getInstance("X.509");
                        }
                        byte[] certbytes = Base64.decode(DOMUtil.getStringValue(x5Element));
                        bais = new ByteArrayInputStream(certbytes);
                        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(bais);
                        certsVector.addElement(cert);
                    } else if (XSignature.isDsigElement(x5Element, "X509IssuerSerial")) {
                        Element firstChild;
                        if (isVector == null) {
                            isVector = new Vector<Object>();
                        }
                        if ((firstChild = DOMUtil.getFirstChildElement(x5Element)) != null && XSignature.isDsigElement(firstChild, "X509IssuerName")) {
                            String issuerName = X509Data.decodeDName(DOMUtil.getStringValue(firstChild));
                            Element nextChild = DOMUtil.getNextElement(firstChild);
                            if (nextChild != null && XSignature.isDsigElement(nextChild, "X509SerialNumber")) {
                                BigInteger serial = new BigInteger(DOMUtil.getStringValue(nextChild));
                                isVector.addElement(issuerName);
                                isVector.addElement(serial);
                            }
                        }
                    } else if (XSignature.isDsigElement(x5Element, "X509SKI")) {
                        if (skiVector == null) {
                            skiVector = new Vector<byte[]>();
                        }
                        skiVector.addElement(Base64.decode(DOMUtil.getStringValue(x5Element)));
                    } else if (XSignature.isDsigElement(x5Element, "X509SubjectName")) {
                        if (snVector == null) {
                            snVector = new Vector<String>();
                        }
                        snVector.addElement(X509Data.decodeDName(DOMUtil.getStringValue(x5Element)));
                    } else if (XSignature.isDsigElement(x5Element, "X509CRL")) {
                        if (certFactory == null) {
                            certFactory = CertificateFactory.getInstance("X.509");
                        }
                        byte[] bincrl = Base64.decode(DOMUtil.getStringValue(x5Element));
                        bais = new ByteArrayInputStream(bincrl);
                        this.crl = (X509CRL)certFactory.generateCRL(bais);
                    }
                }
                x5 = DOMUtil.getNextSibling2(x5);
            }
            if (isVector != null && isVector.size() > 0) {
                int n = isVector.size() / 2;
                this.issuerNames = new String[n];
                this.serialNumbers = new BigInteger[n];
                int i = 0;
                while (i < n) {
                    this.issuerNames[i] = (String)isVector.elementAt(i * 2);
                    this.serialNumbers[i] = (BigInteger)isVector.elementAt(i * 2 + 1);
                    ++i;
                }
            }
            if (skiVector != null && skiVector.size() > 0) {
                this.skis = new Object[skiVector.size()];
                int i = 0;
                while (i < skiVector.size()) {
                    this.skis[i] = skiVector.elementAt(i);
                    ++i;
                }
            }
            if (snVector != null && snVector.size() > 0) {
                this.subjectNames = new String[snVector.size()];
                int i = 0;
                while (i < snVector.size()) {
                    this.subjectNames[i] = (String)snVector.elementAt(i);
                    ++i;
                }
            }
            if (certsVector != null && certsVector.size() > 0) {
                this.certs = new X509Certificate[certsVector.size()];
                int i = 0;
                while (i < certsVector.size()) {
                    this.certs[i] = (X509Certificate)certsVector.elementAt(i);
                    ++i;
                }
            }
        }

        public X509Data() {
        }

        public String[] getIssuerNames() {
            return this.issuerNames;
        }

        public void setIssuerNames(String[] issuerNames) {
            if (this.issuerNames == null) {
                this.serialNumbers = new BigInteger[issuerNames.length];
                Arrays.fill(this.serialNumbers, BigInteger.ZERO);
                this.issuerNames = issuerNames;
            }
        }

        public BigInteger[] getSerialNumbers() {
            return this.serialNumbers;
        }

        public String[] getSubjectNames() {
            return this.subjectNames;
        }

        public Object[] getSKIs() {
            return this.skis;
        }

        public X509Certificate[] getCertificates() {
            return this.certs;
        }

        public void setCertificates(X509Certificate[] certs) {
            this.certs = certs;
        }

        public void setCertificate(X509Certificate cert) {
            this.certs = new X509Certificate[1];
            this.certs[0] = cert;
        }

        public X509CRL getCRL() {
            return this.crl;
        }

        public void setCRL(X509CRL crl) {
            this.crl = crl;
        }

        public void setParameters(X509Certificate signerCert, boolean issuer, boolean subjectId, boolean subject) {
            byte[] der;
            this.crl = null;
            this.issuerNames = null;
            this.serialNumbers = null;
            if (issuer) {
                this.issuerNames = new String[1];
                this.serialNumbers = new BigInteger[1];
                this.issuerNames[0] = signerCert.getIssuerDN().getName();
                this.serialNumbers[0] = signerCert.getSerialNumber();
            }
            this.skis = null;
            if (subjectId && (der = signerCert.getExtensionValue(OID_KEYIDENTIFIER)) != null) {
                byte[] ki = new byte[der.length - 4];
                System.arraycopy(der, 4, ki, 0, der.length - 4);
                this.skis = new Object[1];
                this.skis[0] = ki;
            }
            this.subjectNames = null;
            if (subject) {
                this.subjectNames = new String[1];
                this.subjectNames[0] = signerCert.getSubjectDN().getName();
            }
        }

        public Element createNode(Document factory) {
            return this.createNode(factory, null);
        }

        public Element createNode(Document factory, IndentConfig iconf) {
            int i;
            Element x5 = factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Data");
            if (this.issuerNames != null && this.issuerNames.length > 0) {
                i = 0;
                while (i < this.issuerNames.length) {
                    Element is = factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
                    DOMUtil.addIndent(is, iconf, 4);
                    is.appendChild(DOMUtil.createTextElementNS(factory, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerName", X509Data.encodeDName(this.issuerNames[i])));
                    DOMUtil.addIndent(is, iconf, 4);
                    String num = this.serialNumbers[i].toString(10);
                    is.appendChild(DOMUtil.createTextElementNS(factory, "http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber", num));
                    DOMUtil.addIndent(is, iconf, 3);
                    DOMUtil.addIndent(x5, iconf, 3);
                    x5.appendChild(is);
                    ++i;
                }
            }
            if (this.skis != null && this.skis.length > 0) {
                i = 0;
                while (i < this.skis.length) {
                    DOMUtil.addIndent(x5, iconf, 3);
                    x5.appendChild(DOMUtil.createTextElementNS(factory, "http://www.w3.org/2000/09/xmldsig#", "X509SKI", Base64.encode((byte[])this.skis[i])));
                    ++i;
                }
            }
            if (this.subjectNames != null && this.subjectNames.length > 0) {
                i = 0;
                while (i < this.subjectNames.length) {
                    DOMUtil.addIndent(x5, iconf, 3);
                    x5.appendChild(DOMUtil.createTextElementNS(factory, "http://www.w3.org/2000/09/xmldsig#", "X509SubjectName", X509Data.encodeDName(this.subjectNames[i])));
                    ++i;
                }
            }
            if (this.certs != null && this.certs.length > 0) {
                i = 0;
                while (i < this.certs.length) {
                    String base64;
                    DOMUtil.addIndent(x5, iconf, 3);
                    try {
                        byte[] raw = this.certs[i].getEncoded();
                        base64 = Base64.encode(raw);
                        if (iconf == null || iconf.doIndentation()) {
                            base64 = Base64.format(base64, 0, "\n", DOMUtil.getSpaces(iconf, 3));
                        }
                    }
                    catch (CertificateEncodingException cee) {
                        base64 = "*** Internal error: java.security.cert.CertificateEncodingException: " + this.certs[i];
                    }
                    x5.appendChild(DOMUtil.createTextElementNS(factory, "http://www.w3.org/2000/09/xmldsig#", "X509Certificate", base64));
                    ++i;
                }
            }
            if (this.crl != null) {
                String base64;
                DOMUtil.addIndent(x5, iconf, 3);
                try {
                    base64 = Base64.encode(this.crl.getEncoded());
                }
                catch (CRLException ce) {
                    base64 = "*** Internal error: java.security.cert.CRLException: " + this.crl;
                }
                if (iconf == null || iconf.doIndentation()) {
                    base64 = Base64.format(base64, 0, "\n", DOMUtil.getSpaces(iconf, 3));
                }
                x5.appendChild(DOMUtil.createTextElementNS(factory, "http://www.w3.org/2000/09/xmldsig#", "X509CRL", base64));
            }
            DOMUtil.addIndent(x5, iconf, 2);
            return x5;
        }

        private static void encodeXS(StringBuffer buffer, StringBuffer attrv) {
            int space_pos = -1;
            int length = attrv.length();
            if (length < 1) {
                return;
            }
            if (attrv.charAt(0) == '#') {
                buffer.append('\\');
            }
            int i = 0;
            while (i < length) {
                char ch = attrv.charAt(i);
                if (",+\"\\<>;".indexOf(ch) >= 0) {
                    buffer.append('\\');
                    buffer.append(ch);
                } else if (ch <= '\u001f') {
                    buffer.append('\\');
                    buffer.append("0123456789abcdef".charAt(ch >> 4 & 0xF));
                    buffer.append("0123456789abcdef".charAt(ch & 0xF));
                } else if (ch == ' ') {
                    if (i == length - 1) {
                        buffer.append("\\20");
                    } else {
                        buffer.append(ch);
                    }
                } else {
                    buffer.append(ch);
                }
                ++i;
            }
        }

        private static void encodeJ(StringBuffer buffer, StringBuffer attrv) {
            char ch;
            int i;
            int length = attrv.length();
            if (length < 1) {
                return;
            }
            boolean quote = false;
            if (attrv.charAt(0) == '#' || attrv.charAt(0) == ' ' || attrv.charAt(length - 1) == ' ') {
                quote = true;
            } else {
                i = 0;
                while (i < length) {
                    ch = attrv.charAt(i);
                    if (",=+<>#;".indexOf(ch) >= 0) {
                        quote = true;
                        break;
                    }
                    ++i;
                }
            }
            if (quote) {
                buffer.append('\"');
            }
            i = 0;
            while (i < length) {
                ch = attrv.charAt(i);
                if (ch == '\\' || ch == '\"') {
                    buffer.append('\\');
                }
                buffer.append(ch);
                ++i;
            }
            if (quote) {
                buffer.append('\"');
            }
        }

        private static int decodeAttributeType(StringBuffer buffer, String dname, int read) {
            int length = dname.length();
            while (read < length && dname.charAt(read) == ' ') {
                ++read;
            }
            if (read >= length) {
                return read;
            }
            int typestart = read;
            while (read < length && dname.charAt(read) != '=') {
                ++read;
            }
            if (read >= length) {
                return read;
            }
            buffer.append(dname.substring(typestart, read));
            buffer.append('=');
            return ++read;
        }

        private static int decodeAttributeValue(StringBuffer buffer, String dname, int read) {
            int length = dname.length();
            if (read >= length) {
                return read;
            }
            if (dname.charAt(read) == '#') {
                // empty if block
            }
            boolean quote = false;
            if (dname.charAt(read) == '\"') {
                ++read;
                quote = true;
            }
            while (read < length) {
                char ch;
                if ((ch = dname.charAt(read++)) == '\\') {
                    char ch2;
                    if (read >= length) {
                        buffer.append(ch);
                        continue;
                    }
                    if ("0123456789abcdefABCDEF".indexOf(ch = dname.charAt(read++)) < 0) {
                        buffer.append(ch);
                        continue;
                    }
                    char decoded = (char)("0123456789abcdef".indexOf(Character.toLowerCase(ch)) << 4);
                    if (read >= length) {
                        buffer.append('\\');
                        buffer.append(ch);
                        continue;
                    }
                    if ("0123456789abcdefABCDEF".indexOf(ch2 = dname.charAt(read++)) < 0) {
                        buffer.append('\\');
                        buffer.append(ch);
                        buffer.append(ch2);
                        continue;
                    }
                    decoded = (char)(decoded + "0123456789abcdef".indexOf(Character.toLowerCase(ch2)));
                    buffer.append(decoded);
                    continue;
                }
                if (quote && ch == '\"') break;
                if (!quote && ch == ',') {
                    --read;
                    break;
                }
                buffer.append(ch);
            }
            return read;
        }

        public static String encodeDName(String dname) {
            int length = dname.length();
            StringBuffer buffer = new StringBuffer(length * 2);
            StringBuffer attr = new StringBuffer(length);
            int read = 0;
            while (read < length) {
                if ((read = X509Data.decodeAttributeType(buffer, dname, read)) >= length) break;
                attr.setLength(0);
                read = X509Data.decodeAttributeValue(attr, dname, read);
                X509Data.encodeXS(buffer, attr);
                if (read >= length || dname.charAt(read) != ',') continue;
                buffer.append(',');
                ++read;
            }
            return new String(buffer);
        }

        public static String decodeDName(String dname) {
            int length = dname.length();
            StringBuffer buffer = new StringBuffer(length * 2);
            StringBuffer attr = new StringBuffer(length);
            int read = 0;
            while (read < length) {
                if ((read = X509Data.decodeAttributeType(buffer, dname, read)) >= length) break;
                attr.setLength(0);
                read = X509Data.decodeAttributeValue(attr, dname, read);
                X509Data.encodeJ(buffer, attr);
                if (read >= length || dname.charAt(read) != ',') continue;
                buffer.append(", ");
                ++read;
            }
            return new String(buffer);
        }
    }

    public static class PGPData {
        String keyId;
        byte[] keyPacket;

        PGPData(Element pd) throws SignatureStructureException {
            Element firstChild = DOMUtil.getFirstChildElement(pd);
            if (firstChild == null) {
                throw new SignatureStructureException("PGPData element has no children.");
            }
            if (XSignature.isDsigElement(firstChild, "PGPKeyID")) {
                this.keyId = DOMUtil.getStringValue(firstChild);
                Element nextChild = DOMUtil.getNextElement(firstChild);
                if (nextChild == null || !XSignature.isDsigElement(nextChild, "PGPKeyPacket")) {
                    throw new SignatureStructureException("The next element of PGPKeyID is not PGPKeyPacket.");
                }
                this.keyPacket = Base64.decode(DOMUtil.getStringValue(nextChild));
            }
        }

        public PGPData(String keyId, byte[] packet) {
            this.keyId = keyId;
            this.keyPacket = packet;
        }

        public String getKeyID() {
            return this.keyId;
        }

        public void setKeyID(String keyid) {
            this.keyId = keyid;
        }

        public byte[] getKeyPacket() {
            return this.keyPacket;
        }

        public void setKeyPacket(byte[] packet) {
            this.keyPacket = packet;
        }

        public Element createNode(Document factory) {
            return this.createNode(factory, null);
        }

        public Element createNode(Document factory, IndentConfig iconf) {
            Element pgpData = factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", "PGPData");
            Element pgpKeyId = factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", "PGPKeyID");
            Element pgpKeyPacket = factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", "PGPKeyPacket");
            DOMUtil.appendText(pgpKeyId, this.keyId);
            DOMUtil.appendText(pgpKeyPacket, Base64.encode(this.keyPacket));
            DOMUtil.addIndent(pgpData, iconf, 3);
            pgpData.appendChild(pgpKeyId);
            DOMUtil.addIndent(pgpData, iconf, 3);
            pgpData.appendChild(pgpKeyPacket);
            DOMUtil.addIndent(pgpData, iconf, 2);
            return pgpData;
        }
    }

    public static class SPKIData {
        Object[] exps = null;
        Element[] unknowns = null;

        public SPKIData() {
        }

        SPKIData(Element sd) {
            int i;
            Vector<byte[]> expv = null;
            Vector<Element> unknownv = null;
            Element child = DOMUtil.getFirstChildElement(sd);
            while (child != null) {
                if (XSignature.isDsigElement(child, "SPKISexp")) {
                    if (expv == null) {
                        expv = new Vector<byte[]>();
                    }
                    expv.addElement(Base64.decode(DOMUtil.getStringValue(child)));
                } else {
                    if (unknownv == null) {
                        unknownv = new Vector<Element>();
                    }
                    unknownv.addElement(child);
                }
                child = DOMUtil.getNextElement(child);
            }
            if (expv != null && expv.size() > 0) {
                this.exps = new Object[expv.size()];
                i = 0;
                while (i < expv.size()) {
                    this.exps[i] = expv.elementAt(i);
                    ++i;
                }
            }
            if (unknownv != null && unknownv.size() > 0) {
                this.unknowns = new Element[unknownv.size()];
                i = 0;
                while (i < unknownv.size()) {
                    this.unknowns[i] = (Element)unknownv.elementAt(i);
                    ++i;
                }
            }
        }

        public Object[] getSexps() {
            return this.exps;
        }

        public void setSexps(Object[] exps) {
            this.exps = exps;
        }

        public Element[] getUnknownChildren() {
            return this.unknowns;
        }

        public void setUnknownChildren(Element[] elems) {
            this.unknowns = elems;
        }

        public Element createNode(Document factory) {
            return this.createNode(factory, null);
        }

        public Element createNode(Document factory, IndentConfig iconf) {
            int i;
            Element spki = factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
            if (this.exps != null && this.exps.length > 0) {
                i = 0;
                while (i < this.exps.length) {
                    DOMUtil.addIndent(spki, iconf, 3);
                    spki.appendChild(DOMUtil.createTextElementNS(factory, "http://www.w3.org/2000/09/xmldsig#", "SPKISexp", Base64.encode((byte[])this.exps[i])));
                    ++i;
                }
            }
            if (this.unknowns != null && this.unknowns.length > 0) {
                i = 0;
                while (i < this.unknowns.length) {
                    DOMUtil.addIndent(spki, iconf, 3);
                    spki.appendChild(this.unknowns[i]);
                    ++i;
                }
            }
            DOMUtil.addIndent(spki, iconf, 2);
            return spki;
        }
    }
}

