/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.dom.util.DOMUtil;
import com.ibm.dom.util.IndentConfig;
import com.ibm.xml.dsig.TemplateGenerator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Reference {
    String uri;
    String id;
    String type;
    TemplateGenerator gen;
    Element objectElement;
    Vector transforms;
    String digester;

    protected Reference(TemplateGenerator tg, String uri, Element objectElement) {
        this.gen = tg;
        this.uri = uri;
        this.objectElement = objectElement;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addTransform(Element transform) {
        if (this.transforms == null) {
            this.transforms = new Vector();
        }
        this.transforms.addElement(transform);
    }

    public void addTransform(String algorithm) {
        Element transform = this.gen.createElementNS("Transform");
        transform.setAttributeNS("http://www.w3.org/2000/09/xmldsig#", "Algorithm", algorithm);
        this.addTransform(transform);
    }

    public void addXPathTransform(String expression) {
        Element transform = this.gen.createElementNS("Transform");
        transform.setAttributeNS("http://www.w3.org/2000/09/xmldsig#", "Algorithm", "http://www.w3.org/TR/1999/REC-xpath-19991116");
        Element xpath = this.gen.createElementNS("XPath");
        DOMUtil.appendText(xpath, expression);
        transform.appendChild(xpath);
        this.addTransform(transform);
    }

    public void setDigestMethod(String digester) {
        this.digester = digester;
    }

    protected String getDigestMethod() {
        return this.digester;
    }

    public Element getReferenceElement() {
        return this.getReferenceElement(null);
    }

    public Element getReferenceElement(IndentConfig iconf) {
        Document factory = this.gen.getDocument();
        Element or = this.gen.createElementNS("Reference");
        or.setAttributeNS("http://www.w3.org/2000/09/xmldsig#", "URI", this.uri);
        if (this.id != null) {
            or.setAttributeNS("http://www.w3.org/2000/09/xmldsig#", "Id", this.id);
        }
        if (this.type != null) {
            or.setAttributeNS("http://www.w3.org/2000/09/xmldsig#", "Type", this.type);
        }
        DOMUtil.addIndent(or, iconf, 3);
        if (this.transforms != null) {
            Element transformsElement = this.gen.createElementNS("Transforms");
            int i = 0;
            while (i < this.transforms.size()) {
                Element transformElement = (Element)this.transforms.elementAt(i);
                DOMUtil.addIndent(transformsElement, iconf, 4);
                transformsElement.appendChild(transformElement);
                ++i;
            }
            DOMUtil.addIndent(transformsElement, iconf, 3);
            or.appendChild(transformsElement);
            DOMUtil.addIndent(or, iconf, 3);
        }
        Element digestMethod = this.gen.createElementNS("DigestMethod");
        digestMethod.setAttributeNS("http://www.w3.org/2000/09/xmldsig#", "Algorithm", this.digester);
        or.appendChild(digestMethod);
        DOMUtil.addIndent(or, iconf, 3);
        or.appendChild(this.gen.createElementNS("DigestValue"));
        DOMUtil.addIndent(or, iconf, 2);
        return or;
    }

    protected Element getObjectElement() {
        return this.objectElement;
    }

    protected boolean isEnvelopedObject() {
        return this.objectElement != null;
    }
}

