/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.dom.util.DOMUtil;
import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.xml.dsig.AlgorithmFactory;
import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.NullURIHandler;
import com.ibm.xml.dsig.ReferenceValidity;
import com.ibm.xml.dsig.SignatureContext;
import com.ibm.xml.dsig.SignatureStructureException;
import com.ibm.xml.dsig.Transform;
import com.ibm.xml.dsig.TransformContext;
import com.ibm.xml.dsig.TransformException;
import com.ibm.xml.dsig.URITransportSetter;
import com.ibm.xml.dsig.XSignature;
import com.ibm.xml.dsig.util.Base64;
import com.ibm.xml.dsig.util.XPathUtil;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ReferenceProcessor {
    static final boolean DEBUG = true;
    public static long digestTime;

    private ReferenceProcessor() {
    }

    static byte[] getTransformedOctets(SignatureContext scontext, Document doc, Element reference, int refno) throws IOException, SignatureStructureException, TransformException, NoSuchAlgorithmException {
        String type;
        Attr uriAttr = reference.getAttributeNode("URI");
        String uriref = null;
        TransformContext context = null;
        Vector decls = null;
        Attr typeAttr = reference.getAttributeNode("Type");
        String string = type = typeAttr == null ? null : typeAttr.getNodeValue();
        if (uriAttr == null) {
            NullURIHandler nuh = scontext.getNullURIHandler();
            if (nuh == null) {
                throw new TransformException("A Reference element has no URI attribute, but NullURIHandler is not registered.");
            }
            context = nuh.getContent();
            if (context.getType() == 3) {
                Node node = context.getNode();
                if (node.getOwnerDocument() != null && node.getOwnerDocument() == doc || node == doc) {
                    decls = XPathUtil.fixTree(node);
                } else {
                    XPathUtil.fixTree(node);
                }
            }
        } else {
            String targetURI;
            uriref = uriAttr.getNodeValue();
            if (uriref == null) {
                uriref = "";
            }
            int idIndex = -1;
            Element transforms = XSignature.getFirstChild(reference, "Transforms");
            if (uriref.length() > 0 && (idIndex = uriref.indexOf(35)) < 0 && transforms == null) {
                byte[] result = URITransportSetter.getContent(uriref, scontext.getEntityResolver(), null);
                if (scontext.getResourceShower() != null) {
                    scontext.getResourceShower().showSignedResource(scontext.getOwnerElement(), refno, uriref, type, result, null);
                }
                return result;
            }
            String targetID = null;
            if (idIndex >= 0) {
                targetURI = uriref.substring(0, idIndex);
                targetID = uriref.substring(idIndex + 1);
            } else {
                targetURI = uriref;
            }
            if (targetURI.length() > 0 && targetID == null) {
                context = new TransformContext(scontext, targetURI);
            } else {
                Document targetDoc = null;
                if (targetURI.length() == 0) {
                    targetDoc = doc;
                    decls = XPathUtil.fixTree(doc);
                } else if (targetID != null) {
                    try {
                        InputSource src = null;
                        if (scontext.getEntityResolver() != null) {
                            src = scontext.getEntityResolver().resolveEntity(null, targetURI);
                        }
                        targetDoc = src == null ? scontext.parse(new InputSource(targetURI)) : scontext.parse(src);
                    }
                    catch (SAXException se) {
                        throw TransformException.create(se);
                    }
                    catch (ParserConfigurationException pce) {
                        throw TransformException.create(pce);
                    }
                }
                context = targetID != null ? ReferenceProcessor.idToInput(scontext, targetURI, targetDoc, targetID) : new TransformContext(scontext, targetDoc);
            }
        }
        ReferenceProcessor.transform(reference, context, scontext.getAlgorithmFactory());
        if (scontext.getResourceShower() != null) {
            scontext.getResourceShower().showSignedResource(scontext.getOwnerElement(), refno, uriref, type, context.getOctets(), context.getEncoding());
        }
        byte[] result = context.getOctets();
        if (decls != null) {
            XPathUtil.cleanTree(decls);
        }
        return result;
    }

    private static String getIdFromXPointer(String xpointer) {
        if (!xpointer.endsWith(")")) {
            return null;
        }
        if (!(xpointer = xpointer.substring("xpointer(".length(), xpointer.length() - 1).trim()).startsWith("id(") || !xpointer.endsWith(")")) {
            return null;
        }
        if ((xpointer = xpointer.substring("id(".length(), xpointer.length() - 1).trim()).length() < 3) {
            return null;
        }
        char first = xpointer.charAt(0);
        char last = xpointer.charAt(xpointer.length() - 1);
        if ((first == '\"' || first == '\'') && first == last) {
            return xpointer.substring(1, xpointer.length() - 1);
        }
        return null;
    }

    private static TransformContext idToInput(SignatureContext scontext, String targetURI, Document targetDoc, String targetID) throws IllegalArgumentException {
        TransformContext context;
        IDResolver iresolver = scontext.getIDResolver0();
        if (targetID.startsWith("xpointer(")) {
            if (targetID.equals("xpointer(/)")) {
                NodeList allnodes = XPathCanonicalizer.toNodeset(targetDoc, null, true);
                context = new TransformContext(scontext, allnodes);
            } else {
                String realID = ReferenceProcessor.getIdFromXPointer(targetID);
                if (realID == null) {
                    throw new IllegalArgumentException("No support for xpointer '" + targetID + "'");
                }
                targetID = realID;
                if (iresolver == null) {
                    throw new IllegalArgumentException("No IDResolver is registered.");
                }
                Element targetNode = iresolver.resolveID(targetDoc, targetID);
                if (targetNode == null) {
                    throw new IllegalArgumentException("Can't resolve ID: '" + targetID + "' in '" + targetURI + "'");
                }
                NodeList allnodes = XPathCanonicalizer.toNodeset(targetNode, null, true);
                context = new TransformContext(scontext, allnodes);
            }
        } else {
            if (iresolver == null) {
                throw new IllegalArgumentException("No IDResolver is registered.");
            }
            Element targetNode = iresolver.resolveID(targetDoc, targetID);
            if (targetNode == null) {
                throw new IllegalArgumentException("Can't resolve ID: '" + targetID + "' in '" + targetURI + "'");
            }
            context = new TransformContext(scontext, targetNode);
        }
        return context;
    }

    private static byte[] transform(Element reference, TransformContext context, AlgorithmFactory afactory) throws SignatureStructureException, TransformException, NoSuchAlgorithmException {
        Element transforms = XSignature.getFirstChild(reference, "Transforms");
        if (transforms == null) {
            return context.getOctets();
        }
        Node child = DOMUtil.getFirstChild2(transforms);
        while (child != null) {
            Element transform;
            if (child.getNodeType() == 1 && XSignature.isDsigElement(transform = (Element)child, "Transform")) {
                String alg = transform.getAttribute("Algorithm");
                if (alg == null || alg.length() == 0) {
                    throw new SignatureStructureException("No Algorithm in a Transform element.");
                }
                Transform transformer = afactory.getTransform(alg);
                if (transformer == null) {
                    throw new TransformException("No such algorithm: " + alg);
                }
                transformer.setParameter(DOMUtil.getFirstChildElement(transform));
                transformer.transform(context);
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return context.getOctets();
    }

    static byte[] calculateDigestValue(Element reference, byte[] transformed, AlgorithmFactory afactory) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException {
        Element digestMethod = XSignature.getFirstChild(reference, "DigestMethod");
        if (digestMethod == null) {
            throw new SignatureStructureException("No DigestMethod element.");
        }
        String digestAlgorithm = digestMethod.getAttribute("Algorithm");
        if (digestAlgorithm == null || digestAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute, or empty Algorithm attribute.");
        }
        MessageDigest digester = afactory.getDigestMethod(digestAlgorithm);
        if (digester == null) {
            throw new NoSuchAlgorithmException("No digest algorithm: " + digestAlgorithm);
        }
        long start = System.currentTimeMillis();
        digester.reset();
        digester.update(transformed);
        byte[] ret = digester.digest();
        digestTime += System.currentTimeMillis() - start;
        return ret;
    }

    private static byte[] digest(SignatureContext scontext, Element reference, int refno) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, TransformException, IOException {
        Document doc = reference.getOwnerDocument();
        byte[] transformed = ReferenceProcessor.getTransformedOctets(scontext, doc, reference, refno);
        return ReferenceProcessor.calculateDigestValue(reference, transformed, scontext.getAlgorithmFactory());
    }

    static void substDigest(SignatureContext scontext, Element reference, int refno) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, TransformException, IOException {
        byte[] value = ReferenceProcessor.digest(scontext, reference, refno);
        Element digestValue = XSignature.getFirstChild(reference, "DigestValue");
        if (digestValue == null) {
            throw new SignatureStructureException("No DigestValue element.");
        }
        DOMUtil.removeAllChildren(digestValue);
        Document factory = reference.getOwnerDocument();
        digestValue.appendChild(factory.createTextNode(Base64.encode(value)));
    }

    static ReferenceValidity verify(SignatureContext scontext, Element reference, int refno) {
        ReferenceValidity validity;
        block5: {
            Attr uri = reference.getAttributeNode("URI");
            Attr type = reference.getAttributeNode("Type");
            validity = new ReferenceValidity(uri == null ? null : uri.getNodeValue(), type == null ? null : type.getNodeValue());
            byte[] value = null;
            try {
                value = ReferenceProcessor.digest(scontext, reference, refno);
                Element digestValue = XSignature.getFirstChild(reference, "DigestValue");
                if (digestValue == null) {
                    throw new SignatureStructureException("No DigestValue element.");
                }
                byte[] valueInSig = Base64.decode(DOMUtil.getStringValue(digestValue));
                validity.valid = MessageDigest.isEqual(value, valueInSig);
                if (validity.valid) {
                    validity.message = "Ok.";
                    break block5;
                }
                validity.message = "Digest value mismatch: calculated: " + Base64.encode(value);
            }
            catch (Exception ex) {
                validity.valid = false;
                validity.message = ex.getMessage();
                if (validity.message == null) {
                    validity.message = ex.getClass().getName();
                }
                System.err.println("Error on URI='" + validity.uri + "'");
                ex.printStackTrace();
            }
        }
        return validity;
    }
}

