/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.dom.util.DOMUtil;
import com.ibm.dom.util.IndentConfig;
import com.ibm.xml.dsig.KeyInfoGenerator;
import com.ibm.xml.dsig.Reference;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemplateGenerator
implements IndentConfig {
    Vector objects;
    String defaultDigestAlgorithm;
    String c11r;
    String signatureMethod;
    KeyInfoGenerator keyGen;
    Document factory;
    Element signedInfoElement;
    Element manifestElement;
    Element signatureElement;
    String prefix = null;
    boolean doIndent = true;
    int indentUnit = 2;

    public TemplateGenerator() {
    }

    public TemplateGenerator(Document factory, String defaultDigestMethod, String c14nURI, String signatureMethod) {
        this();
        this.setDocument(factory);
        this.setDefaultDigestMethod(defaultDigestMethod);
        this.setCanonicalizer(c14nURI);
        this.setSignatureMethod(signatureMethod);
    }

    public TemplateGenerator(Document factory, String defaultDigestMethod, String c14nURI, String signatureMethod, KeyInfoGenerator keyGen) {
        this();
        this.setDocument(factory);
        this.setDefaultDigestMethod(defaultDigestMethod);
        this.setCanonicalizer(c14nURI);
        this.setSignatureMethod(signatureMethod);
        this.setKeyInfoGenerator(keyGen);
    }

    public void setDefaultDigestMethod(String algorithmURI) {
        this.defaultDigestAlgorithm = algorithmURI;
    }

    public Reference createReference(String uri) {
        Reference or = new Reference(this, uri, null);
        or.setDigestMethod(this.defaultDigestAlgorithm);
        return or;
    }

    public Reference createReference(Element objectElement) {
        String idname = objectElement.getAttribute("Id");
        if (idname == null || idname.length() == 0) {
            throw new IllegalArgumentException("This Object element has no Id attribute.");
        }
        Reference or = new Reference(this, "#" + idname, objectElement);
        or.setDigestMethod(this.defaultDigestAlgorithm);
        return or;
    }

    public Reference createReference(Element objectElement, String idname) {
        if (idname == null || idname.length() == 0) {
            throw new IllegalArgumentException("This Object element has no Id attribute.");
        }
        Reference or = new Reference(this, "#" + idname, objectElement);
        or.setDigestMethod(this.defaultDigestAlgorithm);
        return or;
    }

    public Element wrapWithObject(Node resource, String idname) {
        Element object = this.createElementNS("dsig:Object");
        TemplateGenerator.fixupNamespace(object);
        object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        object.setAttributeNS("http://www.w3.org/2000/09/xmldsig#", "Id", idname);
        if (this.factory != resource.getOwnerDocument()) {
            if (resource.getNodeType() == 9) {
                Node child = resource.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() != 10) {
                        object.appendChild(this.factory.importNode(child, true));
                    }
                    child = child.getNextSibling();
                }
            } else {
                object.appendChild(this.factory.importNode(resource, true));
            }
        } else {
            object.appendChild(resource);
        }
        return object;
    }

    public void addReference(Reference obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (this.objects == null) {
            this.objects = new Vector();
        }
        this.objects.addElement(obj);
    }

    public void removeAllReferences() {
        if (this.objects != null) {
            this.objects.removeAllElements();
        }
    }

    public void setCanonicalizer(String algorithmURI) {
        this.c11r = algorithmURI;
    }

    public void setSignatureMethod(String algorithmURI) {
        this.signatureMethod = algorithmURI;
    }

    public void setKeyInfoGenerator(KeyInfoGenerator keyGen) {
        this.keyGen = keyGen;
    }

    public void setDocument(Document factory) {
        this.factory = factory;
    }

    public Document getDocument() {
        return this.factory;
    }

    public void setPrefix(String pre) {
        this.prefix = pre;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setIndentation(boolean ind) {
        this.doIndent = ind;
    }

    public boolean doIndentation() {
        return this.doIndent;
    }

    public void setUnit(int u) {
        this.indentUnit = u;
    }

    public int getUnit() {
        return this.indentUnit;
    }

    public synchronized Element getSignedInfoElement() {
        if (this.signedInfoElement != null) {
            return this.signedInfoElement;
        }
        this.signatureElement = this.createElementNS("Signature");
        TemplateGenerator.fixupNamespace(this.signatureElement);
        DOMUtil.addIndent(this.signatureElement, this, 1);
        this.signedInfoElement = this.createElementNS("SignedInfo");
        this.signatureElement.appendChild(this.signedInfoElement);
        Element signedInfo = this.signedInfoElement;
        DOMUtil.addIndent(signedInfo, this, 2);
        if (this.c11r == null) {
            throw new RuntimeException("You must specify a CanonicalizationMethod in this implementation.");
        }
        Element c14nMethod = this.createElementNS("CanonicalizationMethod");
        c14nMethod.setAttributeNS("http://www.w3.org/2000/09/xmldsig#", "Algorithm", this.c11r);
        signedInfo.appendChild(c14nMethod);
        DOMUtil.addIndent(signedInfo, this, 2);
        if (this.signatureMethod == null) {
            throw new RuntimeException("You must specify a SignatureMethod.");
        }
        Element sigMethod = this.createElementNS("SignatureMethod");
        sigMethod.setAttributeNS("http://www.w3.org/2000/09/xmldsig#", "Algorithm", this.signatureMethod);
        signedInfo.appendChild(sigMethod);
        DOMUtil.addIndent(signedInfo, this, 2);
        if (this.objects == null || this.objects.size() == 0) {
            throw new RuntimeException("No resources are registered.");
        }
        int i = 0;
        while (i < this.objects.size()) {
            Reference ref = (Reference)this.objects.elementAt(i);
            Element refElement = ref.getReferenceElement(this);
            signedInfo.appendChild(refElement);
            DOMUtil.addIndent(signedInfo, this, i == this.objects.size() - 1 ? 1 : 2);
            ++i;
        }
        return signedInfo;
    }

    public synchronized Element getManifestElement() {
        if (this.manifestElement != null) {
            return this.manifestElement;
        }
        this.manifestElement = this.createElementNS("Manifest");
        TemplateGenerator.fixupNamespace(this.manifestElement);
        DOMUtil.addIndent(this.manifestElement, this, 2);
        if (this.objects == null || this.objects.size() == 0) {
            throw new RuntimeException("No resources are registered.");
        }
        int i = 0;
        while (i < this.objects.size()) {
            Reference ref = (Reference)this.objects.elementAt(i);
            Element refElement = ref.getReferenceElement(this);
            this.manifestElement.appendChild(refElement);
            DOMUtil.addIndent(this.manifestElement, this, i == this.objects.size() - 1 ? 1 : 2);
            ++i;
        }
        return this.manifestElement;
    }

    public synchronized Element getSignatureElement() {
        if (this.signatureElement != null) {
            return this.signatureElement;
        }
        this.getSignedInfoElement();
        Element el = this.signatureElement;
        DOMUtil.addIndent(el, this, 1);
        el.appendChild(this.createElementNS("SignatureValue"));
        if (this.keyGen != null) {
            DOMUtil.addIndent(el, this, 1);
            el.appendChild(this.keyGen.getKeyInfoElement(this.factory));
        }
        Vector<Element> v = new Vector<Element>(this.objects.size());
        int i = 0;
        while (i < this.objects.size()) {
            Element objectElement;
            Reference ref = (Reference)this.objects.elementAt(i);
            if (ref.isEnvelopedObject() && !TemplateGenerator.contains(v, objectElement = ref.getObjectElement())) {
                v.addElement(objectElement);
                DOMUtil.addIndent(el, this, 1);
                el.appendChild(objectElement);
            }
            ++i;
        }
        DOMUtil.addIndent(el, this, 0);
        return el;
    }

    private static boolean contains(Vector v, Object obj) {
        int i = 0;
        while (i < v.size()) {
            if (v.elementAt(i) == obj) {
                return true;
            }
            ++i;
        }
        return false;
    }

    final Element createElementNS(String qname) {
        int index = qname.indexOf(58);
        if (index >= 0 || this.prefix == null || this.prefix.length() == 0) {
            return this.factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", qname);
        }
        return this.factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.prefix + ":" + qname);
    }

    private static void fixupNamespace(Element el) {
        String p = el.getPrefix();
        if (p == null) {
            el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", el.getNamespaceURI());
        } else {
            el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + p, el.getNamespaceURI());
        }
    }
}

