/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.SignatureContext;
import com.ibm.xml.dsig.TransformException;
import com.ibm.xml.dsig.URITransportSetter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TransformContext
implements URITransportSetter.Receiver {
    private SignatureContext scontext;
    private byte[] content;
    private String encoding;
    private Node node;
    private NodeList nodeset;
    private String uri;
    private int type;
    public static final int TYPE_BINARY = 0;
    public static final int TYPE_URI = 1;
    public static final int TYPE_NODESET = 2;
    public static final int TYPE_NODE = 3;

    private TransformContext(SignatureContext scontext) {
        this.scontext = scontext;
        this.clearData();
    }

    private void clearData() {
        this.content = null;
        this.encoding = null;
        this.node = null;
        this.nodeset = null;
        this.uri = null;
    }

    TransformContext(SignatureContext scontext, byte[] cont, String enc) {
        this(scontext);
        this.content = cont;
        this.encoding = enc;
        this.type = 0;
    }

    TransformContext(SignatureContext scontext, Node node) {
        this(scontext);
        this.node = node;
        this.type = 3;
    }

    TransformContext(SignatureContext scontext, String uri) {
        this(scontext);
        this.uri = uri;
        this.type = 1;
    }

    TransformContext(SignatureContext scontext, NodeList nodeset) {
        this(scontext);
        this.nodeset = nodeset;
        this.type = 2;
    }

    public int getType() {
        return this.type;
    }

    public boolean isOctetsOrURI() {
        return this.type == 0 || this.type == 1;
    }

    public void setContent(byte[] cont, String enc) {
        this.clearData();
        this.content = cont;
        this.encoding = enc;
        this.type = 0;
    }

    public void setContent(NodeList nodeset) {
        this.clearData();
        this.nodeset = nodeset;
        this.type = 2;
    }

    public byte[] getOctets() throws TransformException {
        switch (this.type) {
            case 3: {
                this.content = XPathCanonicalizer.serializeSubset(this.node, false);
                this.encoding = "UTF-8";
                this.node = null;
                this.type = 0;
                break;
            }
            case 2: {
                this.content = XPathCanonicalizer.serializeSubset(this.nodeset, false);
                this.encoding = "UTF-8";
                this.nodeset = null;
                this.type = 0;
                break;
            }
            case 1: {
                try {
                    URITransportSetter.getContent(this.uri, this.getEntityResolver(), this);
                    break;
                }
                catch (IOException ioe) {
                    throw TransformException.create(ioe);
                }
            }
        }
        return this.content;
    }

    public String getEncoding() throws TransformException {
        this.getOctets();
        return this.encoding;
    }

    public Node getNode() throws TransformException {
        if (this.type != 3) {
            throw new RuntimeException("Internal Error: Type mismatch: requested=TYPE_NODE, type=" + this.type);
        }
        return this.node;
    }

    public NodeList getNodeset() throws TransformException {
        switch (this.type) {
            case 0: 
            case 1: {
                return XPathCanonicalizer.toNodeset(this.getDocument(), null, true);
            }
            case 3: {
                Node node = this.getNode();
                if (node.getNodeType() == 9) {
                    return XPathCanonicalizer.toNodeset(node, null, true);
                }
                return XPathCanonicalizer.toNodeset(node, null, false);
            }
            case 2: {
                return this.nodeset;
            }
        }
        throw new RuntimeException("Internal Error: Unknown type: type=" + this.type);
    }

    public Document getDocument() throws TransformException {
        Document doc;
        try {
            InputSource src = null;
            if (this.type == 1) {
                if (this.getEntityResolver() != null) {
                    try {
                        src = this.getEntityResolver().resolveEntity(null, this.uri);
                    }
                    catch (SAXException saxe) {
                        // empty catch block
                    }
                }
                if (src == null) {
                    src = new InputSource(this.uri);
                }
            } else {
                src = new InputSource(new ByteArrayInputStream(this.getOctets()));
                if (this.getEncoding() != null) {
                    src.setEncoding(this.getEncoding());
                }
            }
            doc = this.scontext.parse(src);
        }
        catch (IOException ioe) {
            throw TransformException.create(ioe);
        }
        catch (SAXException saxe) {
            throw TransformException.create(saxe);
        }
        catch (ParserConfigurationException pce) {
            throw TransformException.create(pce);
        }
        return doc;
    }

    public EntityResolver getEntityResolver() {
        return this.scontext.getEntityResolver();
    }

    public IDResolver getIDResolver() {
        return this.scontext.getIDResolver();
    }

    public Element getSignatureElement() {
        return this.scontext.getSignatureElement();
    }

    public boolean isDebug() {
        return this.scontext.isDebug();
    }
}

