/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.transform;

import com.ibm.dom.util.CanonicalizerVisitor;
import com.ibm.dom.util.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

class Canonicalizer {
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";

    Canonicalizer() {
    }

    public static byte[] serializeSubset(NodeList nodeList, boolean withComments, Map replNodeSets) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            Canonicalizer.serializeSubset(nodeList, withComments, replNodeSets, wr);
            ((Writer)wr).close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static void serializeSubset(NodeList nodeList, boolean withComments, Map replNodeSets, Writer wr) throws IOException {
        Canonicalizer.serializeSubset(nodeList, withComments, replNodeSets, wr, new HashSet());
    }

    static void serializeSubset(NodeList nodeList, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes) throws IOException {
        Vector<Object> nodeVector = new Vector<Object>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (replNodeSets.containsKey(node)) {
                NodeList nl;
                nodeVector.add(new ReplacedNode(node));
                Node n = node.getParentNode();
                if ((i <= 0 || n != null && !com.ibm.xml.enc.util.DOMUtil.contains((NodeList)nodeList, (int)0, (int)i, (Node)n)) && (nl = (NodeList)replNodeSets.get(node)).getLength() > 0) {
                    Element e = (Element)nl.item(0).getParentNode();
                    Hashtable h = Canonicalizer.collectXMLPrefixAttributesInAncestors(node);
                    Iterator j = h.values().iterator();
                    while (j.hasNext()) {
                        Attr a = (Attr)j.next();
                        e.setAttributeNS(a.getNamespaceURI(), a.getName(), a.getValue());
                    }
                }
                int j = i + 1;
                int l = nodeList.getLength();
                while (j <= l) {
                    if (j >= l || !com.ibm.xml.enc.util.DOMUtil.isDescendantNode((Node)nodeList.item(j), (Node)node)) {
                        i = j - 1;
                        break;
                    }
                    ++j;
                }
            } else if (node.getNodeType() != 2) {
                nodeVector.addElement(node);
                if (node.getNodeType() == 1) {
                    Node attr;
                    Hashtable<String, Node> attributes = Canonicalizer.collectXMLPrefixAttributesInAncestors(node);
                    if (i + 1 < nodeList.getLength() && (attr = nodeList.item(i + 1)).getNodeType() == 2 && ((Attr)attr).getOwnerElement() == node) {
                        if (attributes == null) {
                            attributes = new Hashtable<String, Node>();
                        }
                        ++i;
                        while (i < nodeList.getLength()) {
                            Node node2 = nodeList.item(i);
                            if (node2.getNodeType() != 2 || node != ((Attr)node2).getOwnerElement()) break;
                            attributes.put(node2.getNodeName(), node2);
                            ++i;
                        }
                        if (attributes.containsKey("xmlns") && ((Attr)attributes.get("xmlns")).getNodeValue().length() == 0) {
                            attributes.remove("xmlns");
                        }
                        --i;
                        nodeVector.addElement(new Attributes(node, attributes));
                    } else if (attributes != null) {
                        nodeVector.addElement(new Attributes(node, attributes));
                    }
                }
            } else {
                Element owner = ((Attr)node).getOwnerElement();
                Hashtable<String, Node> attributes = new Hashtable<String, Node>();
                while (i < nodeList.getLength()) {
                    Node node2 = nodeList.item(i);
                    if (node2.getNodeType() != 2 || owner != ((Attr)node2).getOwnerElement()) break;
                    attributes.put(node2.getNodeName(), node2);
                    ++i;
                }
                nodeVector.addElement(new Attributes(owner, attributes));
                --i;
            }
            ++i;
        }
        Stack stack = new Stack();
        int i2 = 0;
        while (i2 < nodeVector.size()) {
            Canonicalizer.serializeSubset(stack, nodeVector, i2, withComments, replNodeSets, wr, apexNodes);
            ++i2;
        }
    }

    private static void serializeSubset(Stack stack, Vector nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes) throws IOException {
        Node parent;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof Attributes) {
            nodeVector.setElementAt(null, i);
            ((Attributes)obj).serialize(null, wr);
            return;
        }
        if (obj instanceof ReplacedNode) {
            NodeList nl = (NodeList)replNodeSets.get(((ReplacedNode)obj).getNode());
            HashSet<Node> s = new HashSet<Node>();
            int j = 0;
            int l = nl.getLength();
            block0: while (j < l) {
                Node n = nl.item(j);
                s.add(n);
                int k = j + 1;
                while (k <= l) {
                    if (k >= l || !com.ibm.xml.enc.util.DOMUtil.isDescendantNode((Node)nl.item(k), (Node)n)) {
                        j = k;
                        continue block0;
                    }
                    ++k;
                }
            }
            Canonicalizer.serializeSubset(nl, false, replNodeSets, wr, s);
            return;
        }
        Node node = (Node)obj;
        short type = node.getNodeType();
        if (type == 9) {
            return;
        }
        if (type != 1) {
            Canonicalizer.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        wr.write(node.getNodeName());
        Attributes ancestorAttrs = stack.empty() ? null : (Attributes)stack.peek();
        Attributes attrs = null;
        int next = i + 1;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof Node || nodeVector.elementAt(next) instanceof ReplacedNode) {
            parent = node.getParentNode();
            if (parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns") || apexNodes.contains(node)) {
                wr.write(" xmlns=\"\"");
            }
        } else {
            attrs = (Attributes)nodeVector.elementAt(next);
            if (!attrs.contains("xmlns") && ((parent = node.getParentNode()).getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns") || apexNodes.contains(node))) {
                wr.write(" xmlns=\"\"");
            }
            attrs.serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        stack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!Canonicalizer.isAncestor(nodeVector.elementAt(next), node)) break;
            Canonicalizer.serializeSubset(stack, nodeVector, next, withComments, replNodeSets, wr, apexNodes);
            nodeVector.setElementAt(null, next++);
        }
        stack.pop();
        wr.write("</");
        wr.write(node.getNodeName());
        wr.write(">");
    }

    static boolean isAncestor(Object me, Node anc) {
        Node parent = me instanceof Attributes ? ((Attributes)me).parent : (me instanceof ReplacedNode ? ((ReplacedNode)me).getNode() : (Node)me);
        while (parent != anc) {
            if ((parent = parent.getNodeType() == 2 ? ((Attr)parent).getOwnerElement() : parent.getParentNode()) != null) continue;
            return false;
        }
        return true;
    }

    static void serializeNode(Node topNode, Node node, Node exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        Canonicalizer.serializeNode(topNode, null, node, exceptedNode, withComments, xmlAttributes, wr);
    }

    private static void serializeNode(Node topNode, Stack stack, Node node, Node exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        if (exceptedNode == node) {
            return;
        }
        boolean lesser = false;
        boolean greater = false;
        switch (node.getNodeType()) {
            case 1: {
                if (stack == null) {
                    stack = new Stack();
                }
                wr.write("<");
                wr.write(node.getNodeName());
                Canonicalizer.serializeAttributes(topNode, stack, (Element)node, xmlAttributes, wr);
                wr.write(">");
                Node child = node.getFirstChild();
                while (child != null) {
                    Canonicalizer.serializeNode(topNode, stack, child, exceptedNode, withComments, xmlAttributes, wr);
                    child = child.getNextSibling();
                }
                stack.pop();
                wr.write("</");
                wr.write(node.getNodeName());
                wr.write(">");
                break;
            }
            case 3: 
            case 4: {
                String text = node.getNodeValue();
                int i = 0;
                while (i < text.length()) {
                    char ch = text.charAt(i);
                    if (ch == '<') {
                        wr.write("&lt;");
                    } else if (ch == '>') {
                        wr.write("&gt;");
                    } else if (ch == '&') {
                        wr.write("&amp;");
                    } else if (ch == '\r') {
                        wr.write("&#xD;");
                    } else {
                        wr.write(ch);
                    }
                    ++i;
                }
                break;
            }
            case 5: 
            case 9: {
                Node child = node.getFirstChild();
                while (child != null) {
                    Canonicalizer.serializeNode(topNode, stack, child, exceptedNode, withComments, xmlAttributes, wr);
                    child = child.getNextSibling();
                }
                break;
            }
            case 7: {
                if (node.getParentNode().getNodeType() == 9) {
                    Node prev = node;
                    while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
                    }
                    if (prev == null) {
                        lesser = true;
                    } else {
                        greater = true;
                    }
                }
                ProcessingInstruction pi = (ProcessingInstruction)node;
                if (greater) {
                    wr.write("\n");
                }
                wr.write("<?");
                wr.write(pi.getTarget());
                if (pi.getData() != null && pi.getData().length() > 0) {
                    wr.write(" ");
                    String data = pi.getData();
                    int start = 0;
                    int index = 0;
                    while (index < data.length()) {
                        if (data.charAt(index) == '\r') {
                            if (index > start) {
                                wr.write(data, start, index - start);
                            }
                            wr.write("&#xD;");
                            start = index + 1;
                        }
                        ++index;
                    }
                    if (start < data.length()) {
                        wr.write(data, start, data.length() - start);
                    }
                }
                wr.write("?>");
                if (!lesser) break;
                wr.write("\n");
                break;
            }
            case 8: {
                if (!withComments) break;
                if (node.getParentNode().getNodeType() == 9) {
                    Node prev = node;
                    while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
                    }
                    if (prev == null) {
                        lesser = true;
                    } else {
                        greater = true;
                    }
                }
                if (greater) {
                    wr.write("\n");
                }
                wr.write("<!--");
                wr.write(node.getNodeValue());
                wr.write("-->");
                if (!lesser) break;
                wr.write("\n");
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                Canonicalizer.serializeAttribute((Attr)node, wr);
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid Node Type: " + node.getNodeType());
            }
        }
    }

    private static boolean isTopElement(Node topNode, Element element) {
        if (topNode == element) {
            return true;
        }
        Node parent = element.getParentNode();
        if (parent != null) {
            switch (parent.getNodeType()) {
                case 9: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 5: {
                    parent = parent.getParentNode();
                }
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + parent.getNodeType());
        }
        return true;
    }

    private static void serializeAttributes(Node topNode, Stack stack, Element element, boolean xmlAttributes, Writer wr) throws IOException {
        Hashtable xmlattrs;
        Hashtable nsattrs = Canonicalizer.collectNamespaceNodesInAncestors(element, false);
        NamedNodeMap nnm = element.getAttributes();
        int atlen = nnm.getLength();
        int i = 0;
        while (i < atlen) {
            nsattrs.put(nnm.item(i).getNodeName(), nnm.item(i));
            ++i;
        }
        if (xmlAttributes && (xmlattrs = Canonicalizer.collectXMLPrefixAttributesInAncestors(element)) != null) {
            Enumeration enumeration = xmlattrs.elements();
            while (enumeration.hasMoreElements()) {
                Attr attr = (Attr)enumeration.nextElement();
                nsattrs.put(attr.getNodeName(), attr);
            }
        }
        Hashtable parentAttrs = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(nsattrs);
        atlen = nsattrs.size();
        String[] as = new String[atlen];
        int[] indexMap = new int[atlen];
        Attr[] attrs = new Attr[atlen];
        int i2 = 0;
        Enumeration en = nsattrs.elements();
        while (en.hasMoreElements()) {
            Attr attr = (Attr)en.nextElement();
            indexMap[i2] = i2;
            attrs[i2] = attr;
            as[i2] = Canonicalizer.createSortedString(attr, element);
            ++i2;
        }
        CanonicalizerVisitor.heapSort(indexMap, as, atlen);
        int j = 0;
        while (j < atlen) {
            block11: {
                Attr xa;
                Attr nsa;
                String attrName;
                Attr a;
                block12: {
                    a = attrs[indexMap[j]];
                    attrName = a.getNodeName();
                    if (attrName.equals("xmlns:xml")) break block11;
                    if (!attrName.equals("xmlns") || a.getNodeValue().length() != 0) break block12;
                    if (Canonicalizer.isTopElement(topNode, element)) break block11;
                    int depth = stack.size() - 1;
                    boolean found = false;
                    while (depth >= 0) {
                        Hashtable attrs2 = (Hashtable)stack.elementAt(depth);
                        Attr attr = (Attr)attrs2.get("xmlns");
                        if (attr != null && attr.getNodeValue().length() > 0) {
                            found = true;
                            break;
                        }
                        --depth;
                    }
                    if (!found) break block11;
                }
                if (!(attrName.equals("xmlns") || attrName.startsWith("xmlns:") ? parentAttrs != null && (nsa = (Attr)parentAttrs.get(attrName)) != null && nsa.getNodeValue().equals(a.getNodeValue()) : attrName.startsWith("xml:") && parentAttrs != null && (xa = (Attr)parentAttrs.get(attrName)) != null && xa.getNodeValue().equals(a.getNodeValue()))) {
                    Canonicalizer.serializeAttribute(a, wr);
                }
            }
            ++j;
        }
    }

    private static void serializeAttribute(Attr attr, Writer wr) throws IOException {
        String name = attr.getNodeName();
        boolean checkURI = name.equals("xmlns") || name.startsWith("xmlns:");
        wr.write(" ");
        wr.write(name);
        wr.write("=\"");
        String value = attr.getNodeValue();
        boolean hasColon = false;
        int j = 0;
        while (j < value.length()) {
            char ch = value.charAt(j);
            if (ch == '&') {
                wr.write("&amp;");
            } else if (ch == '<') {
                wr.write("&lt;");
            } else if (ch == '\"') {
                wr.write("&quot;");
            } else if (ch == '\t') {
                wr.write("&#x9;");
            } else if (ch == '\n') {
                wr.write("&#xA;");
            } else if (ch == '\r') {
                wr.write("&#xD;");
            } else {
                if (checkURI) {
                    if (ch == ':') {
                        hasColon = true;
                    } else if (ch == '/' && !hasColon) {
                        throw new RuntimeException("Found a relative URI: " + value);
                    }
                }
                wr.write(ch);
            }
            ++j;
        }
        if (value.length() > 0 && checkURI && !hasColon) {
            throw new RuntimeException("Found a relative URI: " + value);
        }
        wr.write("\"");
    }

    public static Hashtable collectNamespaceNodesInAncestors(Node startNode, boolean useProxy) {
        Node node = startNode;
        Hashtable<String, Attr> nsnodes = new Hashtable<String, Attr>();
        Document factory = startNode.getOwnerDocument();
        if (node.getNodeType() == 1 && ((Element)node).getAttributeNode("xmlns:xml") == null) {
            if (useProxy) {
                nsnodes.put("xmlns:xml", new AttrProxy(startNode, factory, XMLNS_NS, "xmlns:xml", XML_NAMESPACE));
            } else {
                Attr xa = factory.createAttributeNS(XMLNS_NS, "xmlns:xml");
                xa.setNodeValue(XML_NAMESPACE);
                nsnodes.put("xmlns:xml", xa);
            }
        }
        do {
            NamedNodeMap attributeList;
            if ((attributeList = node.getAttributes()) == null) continue;
            int nAttrs = attributeList.getLength();
            int j = 0;
            while (j < nAttrs) {
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if ((attrName.equals("xmlns") || attrName.startsWith("xmlns:")) && !nsnodes.containsKey(attrName)) {
                    Attr newAttr;
                    if (node == startNode) {
                        nsnodes.put(attrName, attr);
                    } else if (useProxy) {
                        newAttr = new AttrProxy(startNode, factory, XMLNS_NS, attrName, attr.getNodeValue());
                        nsnodes.put(attrName, newAttr);
                    } else {
                        newAttr = factory.createAttributeNS(XMLNS_NS, attrName);
                        newAttr.setNodeValue(attr.getNodeValue());
                        nsnodes.put(attrName, newAttr);
                    }
                }
                ++j;
            }
        } while ((node = node.getParentNode()) != null);
        return nsnodes;
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(Node startNode) {
        String attrName;
        Attr attr;
        int j;
        int nAttrs;
        NamedNodeMap attributeList;
        Hashtable<String, Attr> attrs = null;
        Node node = startNode.getParentNode();
        while (node != null) {
            attributeList = node.getAttributes();
            if (attributeList != null) {
                nAttrs = attributeList.getLength();
                j = 0;
                while (j < nAttrs) {
                    attr = (Attr)attributeList.item(j);
                    attrName = attr.getNodeName();
                    if (attrName.startsWith("xml:") && (attrs == null || !attrs.containsKey(attrName))) {
                        if (attrs == null) {
                            attrs = new Hashtable<String, Attr>();
                        }
                        attrs.put(attrName, attr);
                    }
                    ++j;
                }
            }
            node = node.getParentNode();
        }
        if (attrs != null && (attributeList = startNode.getAttributes()) != null) {
            nAttrs = attributeList.getLength();
            j = 0;
            while (j < nAttrs) {
                attr = (Attr)attributeList.item(j);
                attrName = attr.getNodeName();
                if (attrName.startsWith("xml:") && attrs.containsKey(attrName)) {
                    attrs.remove(attrName);
                }
                ++j;
            }
        }
        return attrs;
    }

    private static String createSortedString(Attr node, Node element) {
        String ret;
        if (node.getNodeType() == 2) {
            String name = node.getNodeName();
            if (name.equals("xmlns")) {
                return "\u0000";
            }
            int index = name.indexOf(58);
            if (index <= 0) {
                return "\u0001" + name;
            }
            String prefix = name.substring(0, index).intern();
            if (prefix.equals("xmlns")) {
                return "\u0000" + name.substring(index + 1);
            }
            String uri = DOMUtil.getNamespaceForPrefix(prefix, element);
            ret = uri == null || uri.length() == 0 ? "\u0001" + name : uri + "\u0001" + name.substring(index + 1);
        } else {
            throw new IllegalArgumentException("Requires an Attr node.");
        }
        return ret;
    }

    private static class AttrProxy
    implements Attr {
        Attr real;
        Element owner;

        AttrProxy(Node owner, Document factory, String ns, String qname, String value) {
            this.real = factory.createAttributeNS(ns, qname);
            this.real.setValue(value);
            this.owner = (Element)owner;
        }

        public Element getOwnerElement() {
            return this.owner;
        }

        public String getName() {
            return this.real.getName();
        }

        public boolean getSpecified() {
            return false;
        }

        public String getValue() {
            return this.real.getValue();
        }

        public void setValue(String value) {
            this.real.setValue(value);
        }

        public Node appendChild(Node newChild) {
            return this.real.appendChild(newChild);
        }

        public Node cloneNode(boolean deep) {
            return this.real.cloneNode(deep);
        }

        public NamedNodeMap getAttributes() {
            return this.real.getAttributes();
        }

        public NodeList getChildNodes() {
            return this.real.getChildNodes();
        }

        public Node getFirstChild() {
            return this.real.getFirstChild();
        }

        public Node getLastChild() {
            return this.real.getLastChild();
        }

        public String getLocalName() {
            return this.real.getLocalName();
        }

        public String getNamespaceURI() {
            return this.real.getNamespaceURI();
        }

        public Node getNextSibling() {
            return this.real.getNextSibling();
        }

        public String getNodeName() {
            return this.real.getNodeName();
        }

        public short getNodeType() {
            return this.real.getNodeType();
        }

        public String getNodeValue() {
            return this.real.getNodeValue();
        }

        public Document getOwnerDocument() {
            return this.real.getOwnerDocument();
        }

        public Node getParentNode() {
            return this.real.getParentNode();
        }

        public String getPrefix() {
            return this.real.getPrefix();
        }

        public Node getPreviousSibling() {
            return this.real.getPreviousSibling();
        }

        public boolean hasAttributes() {
            return false;
        }

        public boolean hasChildNodes() {
            return this.real.hasChildNodes();
        }

        public Node insertBefore(Node newChild, Node refChild) {
            return this.real.insertBefore(newChild, refChild);
        }

        public void normalize() {
            this.real.normalize();
        }

        public Node removeChild(Node oldChild) {
            return this.real.removeChild(oldChild);
        }

        public Node replaceChild(Node newChild, Node oldChild) {
            return this.real.replaceChild(newChild, oldChild);
        }

        public void setNodeValue(String nodeValue) {
            this.real.setNodeValue(nodeValue);
        }

        public void setPrefix(String prefix) {
            this.real.setPrefix(prefix);
        }

        public boolean isSupported(String feature, String version) {
            return this.real.isSupported(feature, version);
        }
    }

    private static class ReplacedNode {
        private Node fNode;

        ReplacedNode(Node node) {
            this.fNode = node;
        }

        Node getNode() {
            return this.fNode;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Attributes {
        Node parent;
        Hashtable attributes;

        Attributes(Node node, Hashtable attrs) {
            this.parent = node;
            this.attributes = attrs;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
        }

        boolean contains(String attrname) {
            return this.attributes.containsKey(attrname);
        }

        void serialize(Attributes parent, Writer wr) throws IOException {
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            Attr[] attrArray = new Attr[attrLength];
            Enumeration enumeration = this.attributes.elements();
            int j = 0;
            while (j < attrLength) {
                Attr attr = (Attr)enumeration.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = Canonicalizer.createSortedString(attr, this.parent);
                ++j;
            }
            CanonicalizerVisitor.heapSort(indexMap, as, attrLength);
            int j2 = 0;
            while (j2 < attrLength) {
                Attr attr = attrArray[indexMap[j2]];
                String attrName = attr.getNodeName();
                if (!attrName.equals("xmlns:xml") && !(attrName.equals("xmlns") || attrName.startsWith("xmlns:") ? parent != null && parent.contains(attrName) && parent.get(attrName).getNodeValue().equals(attr.getNodeValue()) : attrName.startsWith("xml:") && parent != null && parent.contains(attrName) && parent.get(attrName).getNodeValue().equals(attr.getNodeValue()))) {
                    Canonicalizer.serializeAttribute(attr, wr);
                }
                ++j2;
            }
        }

        Enumeration enum() {
            return this.attributes.elements();
        }

        Attr get(String name) {
            return (Attr)this.attributes.get(name);
        }

        private void remove(String name) {
            Object attr = this.attributes.remove(name);
            if (attr == null) {
                System.err.println("Internal logic error: No attribute named " + name);
            }
        }

        private boolean usePrefix(String prefix) {
            if (prefix.length() == 0) {
                return false;
            }
            Enumeration en = this.enum();
            while (en.hasMoreElements()) {
                Attr attr = (Attr)en.nextElement();
                String p = attr.getPrefix();
                if (p == null || !p.equals(prefix)) continue;
                return true;
            }
            return false;
        }

        static boolean inAncestors(Stack ancestors, String name, String ns) {
            if (ancestors == null || ancestors.isEmpty()) {
                return false;
            }
            int i = ancestors.size() - 1;
            while (i >= 0) {
                Attributes attrs = (Attributes)ancestors.elementAt(i);
                if (attrs.contains(name) && attrs.get(name).getNodeValue().equals(ns)) {
                    return true;
                }
                --i;
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        void serialize(Stack ancestors, Hashtable prefixList, String elprefix, Writer wr) throws IOException {
            attrLength = this.attributes.size();
            as = new String[attrLength];
            indexMap = new int[attrLength];
            attrArray = new Attr[attrLength];
            enum = this.attributes.elements();
            j = 0;
            while (j < attrLength) {
                attr = (Attr)enum.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = Canonicalizer.access$000(attr, this.parent);
                ++j;
            }
            CanonicalizerVisitor.heapSort(indexMap, as, attrLength);
            j = 0;
            while (j < attrLength) {
                block7: {
                    block6: {
                        attr = attrArray[indexMap[j]];
                        attrName = attr.getNodeName();
                        if (!attrName.equals("xmlns:xml")) break block6;
                        this.remove(attrName);
                        break block7;
                    }
                    if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:")) ** GOTO lbl-1000
                    if (Attributes.inAncestors(ancestors, attrName, attr.getNodeValue())) {
                        this.remove(attrName);
                    } else {
                        v0 = prefix = attrName.equals("xmlns") != false ? "" : attrName.substring(6);
                        if (!(prefixList != null && prefixList.get(prefix) != null || elprefix == null || elprefix.equals(prefix) || this.usePrefix(prefix))) {
                            this.remove(attrName);
                        } else lbl-1000:
                        // 2 sources

                        {
                            Canonicalizer.access$100(attr, wr);
                        }
                    }
                }
                ++j;
            }
        }

        public String toString() {
            return "Attributes[#=" + this.attributes.size() + "]";
        }
    }
}

