/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.transform;

import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.Transform;
import com.ibm.xml.enc.AlgorithmFactoryExtn;
import com.ibm.xml.enc.DecryptionContext;
import com.ibm.xml.enc.EncryptedKeyRetriever;
import com.ibm.xml.enc.KeyInfoResolver;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.EncryptedData;
import com.ibm.xml.enc.type.Except;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public abstract class DecryptionTransformer
extends Transform {
    public static final String XML = "http://www.w3.org/2001/04/decrypt#";
    public static final String XML2 = "http://www.w3.org/2002/07/decrypt#XML";
    public static final String BINARY = "http://www.w3.org/2002/07/decrypt#Binary";
    private AlgorithmFactoryExtn fAlgorithmFactory;
    private KeyInfoResolver fKeyInfoResolver;
    private IDResolver fIdResolver;
    private EntityResolver fEntityResolver;
    private EncryptedKeyRetriever fEncryptedKeyRetriever;
    private List fParameters = new ArrayList();
    private Set fExceptedIds;

    DecryptionTransformer() {
    }

    public void setAlgorithmFactory(AlgorithmFactoryExtn factory) {
        this.fAlgorithmFactory = factory;
    }

    public void setKeyInfoResolver(KeyInfoResolver resolver) {
        this.fKeyInfoResolver = resolver;
    }

    public void setIdResolver(IDResolver resolver) {
        this.fIdResolver = resolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.fEntityResolver = resolver;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever retriever) {
        this.fEncryptedKeyRetriever = retriever;
    }

    boolean isEncryptedData(Node node) throws StructureException {
        Element e;
        boolean encData = false;
        if (node.getNodeType() == 1 && EncryptedData.isOfType((Element)(e = (Element)node))) {
            if (this.fExceptedIds == null) {
                this.setExceptedIds();
            }
            encData = !e.hasAttribute("Id") || !this.fExceptedIds.contains(e.getAttribute("Id"));
        }
        return encData;
    }

    private void setExceptedIds() throws StructureException {
        this.fExceptedIds = new HashSet();
        Iterator i = this.fParameters.iterator();
        while (i.hasNext()) {
            String s = ((Except)i.next()).getURI();
            if (s == null) {
                throw new StructureException("URI attribute not specified");
            }
            if (!(s = s.trim()).startsWith("#") || s.length() < 2) {
                throw new StructureException("Wrong URI: " + s);
            }
            s = s.substring(1);
            s = this.getId(s);
            this.fExceptedIds.add(s);
        }
    }

    private String getId(String xptr) {
        char c;
        String s;
        String id = xptr;
        if (xptr.startsWith("xpointer(") && xptr.endsWith(")") && (s = id.substring(9, xptr.length() - 1).trim()).startsWith("id(") && s.endsWith(")") && (s = s.substring(3, id.length() - 1).trim()).length() > 2 && ((c = s.charAt(0)) == '\"' || c == '\'') && c == s.charAt(s.length() - 1)) {
            id = s.substring(1, s.length() - 1);
        }
        return id;
    }

    DecryptionContext createDecryptionContext() {
        DecryptionContext context = new DecryptionContext();
        context.setAlgorithmFactory(this.fAlgorithmFactory);
        context.setKeyInfoResolver(this.fKeyInfoResolver);
        context.setIdResolver(this.fIdResolver);
        context.setEntityResolver(this.fEntityResolver);
        context.setEncryptedKeyRetriever(this.fEncryptedKeyRetriever);
        return context;
    }

    public void setParameter(Node node) {
        Node n = node;
        while (n != null) {
            switch (n.getNodeType()) {
                case 1: {
                    Element el = (Element)n;
                    if (!Except.isOfType((Element)el)) break;
                    Except ex = new Except(el);
                    this.fParameters.add(ex);
                    break;
                }
                case 5: {
                    this.setParameter(n.getFirstChild());
                }
            }
            n = n.getNextSibling();
        }
    }

    public Element createTransformElement(Document factory) {
        Element trans = super.createTransformElement(factory);
        Iterator i = this.fParameters.iterator();
        while (i.hasNext()) {
            try {
                Element e = ((Except)i.next()).createElement(factory, true);
                trans.appendChild(e);
            }
            catch (StructureException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        return trans;
    }
}

