/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.transform;

import com.ibm.dom.util.CanonicalizerVisitor;
import com.ibm.dom.util.TreeTraversal;
import com.ibm.xml.dsig.Canonicalizer;
import com.ibm.xml.dsig.Transform;
import com.ibm.xml.dsig.TransformContext;
import com.ibm.xml.dsig.TransformException;
import com.ibm.xml.sax.NamespaceAdapter;
import com.ibm.xml.sax.SAXCanonicalizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class W3CCanonicalizer
extends Transform
implements Canonicalizer {
    CanonicalizerVisitor c11rv = null;

    public String getURI() {
        return "http://www.w3.org/TR/2000/WD-xml-c14n-20000119";
    }

    public String getType() {
        return null;
    }

    public String getCharset() {
        return null;
    }

    public void transform(TransformContext context) throws TransformException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(context.getOctets().length);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            NamespaceAdapter nsa = new NamespaceAdapter(factory.newSAXParser().getParser());
            if (context.getEntityResolver() != null) {
                nsa.setEntityResolver(context.getEntityResolver());
            }
            nsa.setDocumentHandler(new SAXCanonicalizer(wr));
            InputSource is = new InputSource(new ByteArrayInputStream(context.getOctets()));
            is.setEncoding(context.getEncoding());
            nsa.parse(is);
            ((Writer)wr).close();
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
            throw TransformException.create(saxe);
        }
        catch (IOException ioe) {
            throw TransformException.create(ioe);
        }
        catch (ParserConfigurationException pce) {
            throw TransformException.create(pce);
        }
        context.setContent(baos.toByteArray(), "UTF-8");
    }

    public void canonicalize(Node node, OutputStream stream) throws IOException {
        OutputStreamWriter wr = new OutputStreamWriter(stream, "UTF8");
        if (this.c11rv == null) {
            this.c11rv = new CanonicalizerVisitor(wr);
        } else {
            this.c11rv.setWriter(wr);
        }
        try {
            new TreeTraversal(this.c11rv).traverse(node);
            ((Writer)wr).flush();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Internal Error: " + e);
        }
    }
}

