/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.transform;

import com.ibm.dom.util.DOMUtil;
import com.ibm.dom.util.IndentConfig;
import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.xml.dsig.Transform;
import com.ibm.xml.dsig.TransformContext;
import com.ibm.xml.dsig.TransformException;
import com.ibm.xml.dsig.util.XPathUtil;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.functions.Function;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XNodeSetForDOM;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathTransformer
extends Transform
implements ErrorListener {
    Element xpathExpression;

    public void setParameter(Node node) {
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("The parameter must be ELEMENT_NODE.");
        }
        this.xpathExpression = (Element)node;
    }

    public String getURI() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    public void transform(TransformContext context) throws TransformException {
        NodeList nodeset = context.getNodeset();
        Node here = this.xpathExpression.getFirstChild();
        if (here == null) {
            here = this.xpathExpression;
        }
        XPathUtil.XPathContextWithIR xcontext = new XPathUtil.XPathContextWithIR(here, context.getIDResolver());
        PrefixResolverDefault presolver = new PrefixResolverDefault((Node)this.xpathExpression);
        XPathCanonicalizer.NodeListImpl resultNodeset = new XPathCanonicalizer.NodeListImpl(nodeset.getLength());
        try {
            FunctionTable.installFunction((String)"here", (Expression)new FuncHere());
            XPath xpath = new XPath(DOMUtil.getStringValue(this.xpathExpression), null, (PrefixResolver)presolver, 0);
            int i = 0;
            while (i < nodeset.getLength()) {
                Node node = nodeset.item(i);
                XObject xobj = xpath.execute((XPathContext)xcontext, node, (PrefixResolver)presolver);
                if (xobj.bool()) {
                    resultNodeset.add(node);
                }
                ++i;
            }
            context.setContent(resultNodeset);
        }
        catch (TransformerException tre) {
            if (context.isDebug()) {
                tre.printStackTrace();
            }
            throw new TransformException("Error occured in an XPath transform: " + tre.getMessage());
        }
        catch (RuntimeException re) {
            if (context.isDebug()) {
                re.printStackTrace();
            }
            throw new TransformException("Error occured in an XPath transform: " + re.getMessage());
        }
    }

    private static void dumpNode(Node n) {
        switch (n.getNodeType()) {
            case 9: {
                System.err.println("#document");
                break;
            }
            case 1: {
                Node parent = n.getParentNode();
                System.err.println(n.getNodeName() + "; ns='" + n.getNamespaceURI() + "'; parent=" + parent.getNodeName());
                if (parent.getNodeType() != 9) break;
                System.err.println("   parent-parent=" + parent.getParentNode());
                break;
            }
            case 2: {
                System.err.println(n.getNodeName() + "='" + n.getNodeValue() + "'; parent=" + ((Attr)n).getOwnerElement().getNodeName());
                break;
            }
            case 3: 
            case 4: {
                System.err.println("#text '" + n.getNodeValue().replace('\n', '*') + "'");
                break;
            }
            case 8: {
                System.err.println("#comment '" + n.getNodeValue().replace('\n', '*') + "'");
                break;
            }
            case 7: {
                System.err.println("<?" + n.getNodeName() + "...?>");
                break;
            }
            default: {
                System.err.println("#others: " + n.getNodeName());
            }
        }
    }

    public void error(TransformerException ex) {
        ex.printStackTrace();
    }

    public void fatalError(TransformerException ex) {
        ex.printStackTrace();
    }

    public void warning(TransformerException ex) {
        ex.printStackTrace();
    }

    public Element createTransformElement(Document factory, IndentConfig iconf) {
        Element xpathElement = this.xpathExpression.getOwnerDocument() != factory ? (Element)factory.importNode(this.xpathExpression, true) : this.xpathExpression;
        Element trElement = super.createTransformElement(factory, iconf);
        DOMUtil.addIndent(trElement, iconf, 5);
        trElement.appendChild(xpathElement);
        DOMUtil.addIndent(trElement, iconf, 4);
        return trElement;
    }

    public static class FuncHere
    extends Function {
        public XObject execute(XPathContext xcontext) throws TransformerException {
            try {
                return new XNodeSetForDOM((Node)xcontext.getOwnerObject(), (DTMManager)xcontext);
            }
            catch (Exception ex) {
                throw new TransformerException("here(): " + ex.getMessage());
            }
        }

        public void checkNumberArgs(int argc) throws WrongNumberArgsException {
            if (argc != 0) {
                throw new WrongNumberArgsException("here() requires no parameter.");
            }
        }

        public void fixupVariables(Vector vars, int size) {
        }
    }
}

