/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.util;

import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.util.DtmProxy;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathUtil {
    private XPathUtil() {
    }

    public static XObject evalXPath(Document doc, String expression) {
        PrefixResolverDefault presolver = new PrefixResolverDefault((Node)doc.getDocumentElement());
        try {
            return XPathAPI.eval((Node)doc, (String)expression, (PrefixResolver)presolver);
        }
        catch (TransformerException trae) {
            throw new RuntimeException(trae.getMessage());
        }
    }

    public static Vector fixTree(Node elem) {
        Vector decls = new Vector();
        XPathUtil.fixElement(elem, decls);
        return decls;
    }

    private static void fixElement(Node elem, Vector decls) {
        if (elem.getNodeType() == 1) {
            Element el = (Element)elem;
            Hashtable alldecls = XPathCanonicalizer.collectNamespaceNodesInAncestors(elem, false);
            Enumeration enumeration = alldecls.elements();
            while (enumeration.hasMoreElements()) {
                Attr ns = (Attr)enumeration.nextElement();
                if (ns.getNodeName().equals("xmlns") && ns.getNodeValue().length() == 0 || el.getAttributeNode(ns.getNodeName()) != null) continue;
                el.setAttributeNode(ns);
                decls.addElement(ns);
            }
        }
        Node child = elem.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 1: 
                case 5: 
                case 9: {
                    XPathUtil.fixElement(child, decls);
                }
            }
            child = child.getNextSibling();
        }
    }

    public static void cleanTree(Vector decls) {
        int i = decls.size() - 1;
        while (i >= 0) {
            Attr attr = (Attr)decls.elementAt(i);
            Element owner = attr.getOwnerElement();
            if (owner != null) {
                owner.removeAttributeNode(attr);
            }
            decls.removeElementAt(i);
            --i;
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            throw new IllegalArgumentException("XPathUtil <expression> <target XML URI>");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        XPathUtil.evalXPath(builder.parse(argv[1]), argv[0]);
    }

    public static class XPathContextWithIR
    extends XPathContext {
        DtmWithIR dtm;

        public XPathContextWithIR(Object owner, IDResolver idr) {
            super(owner);
            this.dtm = new DtmWithIR(idr);
        }

        public DTM getDTM(int h) {
            this.dtm.setDTM(super.getDTM(h));
            return this.dtm;
        }

        public DTM getDTM(Source source, boolean unique, DTMWSFilter wsfilter, boolean incremental, boolean doIndexing) {
            DTM d = super.getDTM(source, unique, wsfilter, incremental, doIndexing);
            this.dtm.setDTM(d);
            return this.dtm;
        }
    }

    public static class DtmWithIR
    extends DtmProxy {
        IDResolver idresolver;

        public DtmWithIR(IDResolver idr) {
            this.idresolver = idr;
        }

        public int getElementById(String elementId) {
            Document doc;
            Element el;
            if (this.idresolver != null && (el = this.idresolver.resolveID(doc = (Document)this.dtm.getNode(this.dtm.getDocument()), elementId)) != null) {
                return ((DOM2DTM)this.dtm).getHandleOfNode((Node)el);
            }
            return super.getElementById(elementId);
        }
    }
}

