/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.sax;

import com.ibm.dom.util.CanonicalizerVisitor;
import com.ibm.xml.sax.NSAttributeList;
import com.ibm.xml.sax.NSDocumentHandler;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DigestFilter
implements NSDocumentHandler {
    protected CharArrayWriter charBuffer = null;
    protected MessageDigest messageDigest;
    protected Stack elementStack = null;
    protected byte[] result;
    protected NSDocumentHandler next = null;
    protected boolean enable = false;
    static final String tab = "0123456789ABCDEF";

    public DigestFilter() {
    }

    public DigestFilter(NSDocumentHandler next) {
        this.next = next;
    }

    public DigestFilter(MessageDigest md) {
        this.enable(md);
    }

    public void enable(MessageDigest md) {
        if (this.enable) {
            if (!this.messageDigest.getAlgorithm().equals(md.getAlgorithm())) {
                throw new RuntimeException("DigestFilter#enable(): Don't use a MessageDigest different from previous one.");
            }
        } else {
            this.enable = true;
            this.messageDigest = md;
        }
        if (this.charBuffer == null) {
            this.charBuffer = new CharArrayWriter();
        }
        if (this.elementStack == null) {
            this.elementStack = new Stack();
        }
    }

    public byte[] getDigest() {
        return this.result;
    }

    public void setNextDocumentHandler(NSDocumentHandler handler) {
        this.next = handler;
    }

    public void startElement(String namespace, String prefix, String localPart, String qname, NSAttributeList atts) throws SAXException {
        this.flushCharBuffer();
        if (this.next != null) {
            this.next.startElement(namespace, prefix, localPart, qname, atts);
        }
        if (!this.enable) {
            return;
        }
        int atlen = atts.getLength();
        int lenWithoutXmlns = 0;
        Hashtable<String, String> hash = new Hashtable<String, String>(atlen);
        String[] as = new String[atlen];
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < atlen) {
            String p = atts.getPrefix(i);
            if (!(atts.getName(i).equals("xmlns") || p != null && p.equals("xmlns"))) {
                String expandedName;
                String ns = atts.getNamespace(i);
                String lp = atts.getLocalPart(i);
                if (ns == null) {
                    expandedName = lp.length() == 0 ? ":" : lp;
                } else {
                    sb.setLength(0);
                    sb.append(ns);
                    sb.append(":");
                    sb.append(lp);
                    expandedName = new String(sb);
                }
                hash.put(expandedName, atts.getName(i));
                as[lenWithoutXmlns++] = expandedName;
            }
            ++i;
        }
        Object[] digestArray = new Object[lenWithoutXmlns];
        DigestFilter.heapSort(as, lenWithoutXmlns);
        int i2 = 0;
        while (i2 < lenWithoutXmlns) {
            String ename = as[i2];
            String value = atts.getValue((String)hash.get(as[i2]));
            this.messageDigest.reset();
            DigestFilter.digestInt(this.messageDigest, 2);
            DigestFilter.digestString(this.messageDigest, ename);
            this.messageDigest.update((byte)0);
            this.messageDigest.update((byte)0);
            DigestFilter.digestString(this.messageDigest, value);
            digestArray[i2] = this.messageDigest.digest();
            ++i2;
        }
        ElementDigest edigest = new ElementDigest(digestArray);
        this.elementStack.push(edigest);
    }

    public void endElement(String namespace, String prefix, String localPart, String qname) throws SAXException {
        this.flushCharBuffer();
        if (this.enable) {
            ElementDigest edigest = (ElementDigest)this.elementStack.pop();
            this.messageDigest.reset();
            DigestFilter.digestInt(this.messageDigest, 1);
            if (namespace != null) {
                DigestFilter.digestString(this.messageDigest, namespace);
                DigestFilter.digestString(this.messageDigest, ":");
            }
            DigestFilter.digestString(this.messageDigest, localPart);
            this.messageDigest.update((byte)0);
            this.messageDigest.update((byte)0);
            DigestFilter.digestInt(this.messageDigest, edigest.attrDigests.length);
            int i = 0;
            while (i < edigest.attrDigests.length) {
                this.messageDigest.update((byte[])edigest.attrDigests[i]);
                ++i;
            }
            DigestFilter.digestInt(this.messageDigest, edigest.getChildrenSize());
            int i2 = 0;
            while (i2 < edigest.getChildrenSize()) {
                this.messageDigest.update((byte[])edigest.childrenDigests.elementAt(i2));
                ++i2;
            }
            this.recordDigest(this.messageDigest.digest());
            if (this.elementStack.size() == 0) {
                this.enable = false;
            }
        }
        if (this.next != null) {
            this.next.endElement(namespace, prefix, localPart, qname);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.next != null) {
            this.next.characters(ch, start, length);
        }
        if (this.enable) {
            this.appendCharBuffer(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.next != null) {
            this.next.ignorableWhitespace(ch, start, length);
        }
        if (this.enable) {
            this.appendCharBuffer(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushCharBuffer();
        if (this.enable) {
            this.messageDigest.reset();
            DigestFilter.digestInt(this.messageDigest, 7);
            DigestFilter.digestString(this.messageDigest, target);
            this.messageDigest.update((byte)0);
            this.messageDigest.update((byte)0);
            int start = 0;
            while (start < data.length()) {
                char ch = data.charAt(start);
                if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') break;
                ++start;
            }
            if (start == 0) {
                DigestFilter.digestString(this.messageDigest, data);
            } else if (start < data.length()) {
                DigestFilter.digestString(this.messageDigest, data.substring(start));
            }
            this.recordDigest(this.messageDigest.digest());
        }
        if (this.next != null) {
            this.next.processingInstruction(target, data);
        }
    }

    private void appendCharBuffer(char[] ch, int start, int length) {
        this.charBuffer.write(ch, start, length);
    }

    private void flushCharBuffer() {
        if (this.enable && this.charBuffer.size() > 0) {
            this.messageDigest.reset();
            DigestFilter.digestInt(this.messageDigest, 3);
            char[] carr = this.charBuffer.toCharArray();
            int i = 0;
            while (i < carr.length) {
                char ch = carr[i];
                this.messageDigest.update((byte)(ch >> 8));
                this.messageDigest.update((byte)(ch & 0xFF));
                ++i;
            }
            this.recordDigest(this.messageDigest.digest());
            this.charBuffer.reset();
        }
    }

    private void recordDigest(byte[] digest) {
        this.result = digest;
        if (!this.elementStack.empty()) {
            ElementDigest edigest = (ElementDigest)this.elementStack.peek();
            edigest.addDigest(digest);
        }
    }

    private static void digestInt(MessageDigest md, int i) {
        md.update((byte)(i >> 24 & 0xFF));
        md.update((byte)(i >> 16 & 0xFF));
        md.update((byte)(i >> 8 & 0xFF));
        md.update((byte)(i & 0xFF));
    }

    private static void digestString(MessageDigest md, String str) {
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            md.update((byte)(ch >> 8));
            md.update((byte)(ch & 0xFF));
            ++i;
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.next != null) {
            this.next.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.next != null) {
            this.next.startDocument();
        }
        if (!this.enable) {
            return;
        }
        ElementDigest edigest = new ElementDigest(null);
        this.elementStack.push(edigest);
    }

    public void endDocument() throws SAXException {
        if (this.next != null) {
            this.next.endDocument();
        }
        if (!this.enable) {
            return;
        }
        ElementDigest edigest = (ElementDigest)this.elementStack.pop();
        this.messageDigest.reset();
        DigestFilter.digestInt(this.messageDigest, 9);
        int csize = edigest.getChildrenSize();
        DigestFilter.digestInt(this.messageDigest, csize);
        int i = 0;
        while (i < csize) {
            this.messageDigest.update((byte[])edigest.childrenDigests.elementAt(i));
            ++i;
        }
        this.recordDigest(this.messageDigest.digest());
    }

    public static void heapSort(String[] pd, int length) {
        int i = length / 2;
        while (i >= 0) {
            DigestFilter.fall(pd, length, i);
            --i;
        }
        i = length - 1;
        while (i > 0) {
            String t = pd[0];
            pd[0] = pd[i];
            pd[i] = t;
            DigestFilter.fall(pd, i, 0);
            --i;
        }
    }

    private static void fall(String[] pd, int n, int i) {
        int j = 2 * i + 1;
        if (j < n) {
            if (j + 1 < n && 0 > CanonicalizerVisitor.compareInUCS(pd[j], pd[j + 1])) {
                j = 2 * i + 2;
            }
            if (0 > CanonicalizerVisitor.compareInUCS(pd[i], pd[j])) {
                String t = pd[i];
                pd[i] = pd[j];
                pd[j] = t;
                DigestFilter.fall(pd, n, j);
            }
        }
    }

    public static void printByteArray(byte[] ab) throws IOException {
        if (null == ab) {
            System.err.print("NULL");
        } else {
            int i = 0;
            while (i < ab.length) {
                System.err.print(tab.charAt(ab[i] >> 4 & 0xF));
                System.err.print(tab.charAt(ab[i] & 0xF));
                ++i;
            }
        }
        System.err.print("\n");
    }

    public static void printByteArray(Writer wr, byte[] ab) throws IOException {
        if (null == ab) {
            wr.write("NULL");
        } else {
            int i = 0;
            while (i < ab.length) {
                DigestFilter.printByte(wr, ab[i]);
                ++i;
            }
        }
        wr.write("\n");
    }

    private static void printByte(Writer wr, byte b) throws IOException {
        wr.write(tab.charAt(b >> 4 & 0xF));
        wr.write(tab.charAt(b & 0xF));
    }

    private static class ElementDigest {
        Object[] attrDigests;
        Vector childrenDigests = null;

        ElementDigest(Object[] ad) {
            this.attrDigests = ad;
        }

        void addDigest(byte[] digest) {
            if (this.childrenDigests == null) {
                this.childrenDigests = new Vector();
            }
            this.childrenDigests.addElement(digest);
        }

        int getChildrenSize() {
            return this.childrenDigests == null ? 0 : this.childrenDigests.size();
        }
    }
}

