/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.sax;

import com.ibm.xml.sax.NSAttributeList;
import com.ibm.xml.sax.NSDocumentHandler;
import com.ibm.xml.sax.SAXEventProducer;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.ParserFactory;

public class NamespaceAdapter
implements DocumentHandler,
ErrorHandler,
SAXEventProducer {
    protected NSDocumentHandler handler;
    protected ErrorHandler errorHandler = null;
    protected Stack elementStack;
    protected NSAttributeListImpl attlist;
    protected Locator lastLocator = new LocatorImpl();
    protected Parser parser;
    protected InputSource source;

    public NamespaceAdapter() throws ClassNotFoundException, IllegalAccessException, InstantiationException, ClassCastException {
        this(ParserFactory.makeParser());
    }

    public NamespaceAdapter(String saxParserName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, ClassCastException {
        this(ParserFactory.makeParser(saxParserName));
    }

    public NamespaceAdapter(Parser parser) {
        this.parser = parser;
        this.parser.setDocumentHandler(this);
        this.parser.setErrorHandler(this);
        this.elementStack = new Stack();
        this.attlist = new NSAttributeListImpl(10);
    }

    public void parse(InputSource source) throws SAXException, IOException {
        this.parser.parse(source);
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parser.parse(systemId);
    }

    public void setInputSource(InputSource src) {
        this.source = src;
    }

    public void start() throws SAXException, IOException {
        this.parser.parse(this.source);
    }

    public void setDocumentHandler(NSDocumentHandler handler) {
        this.handler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.parser.setDTDHandler(handler);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.parser.setEntityResolver(resolver);
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setLocale(Locale locale) throws SAXException {
        this.parser.setLocale(locale);
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        ElementInfo einfo = new ElementInfo(name);
        int i = 0;
        while (i < atts.getLength()) {
            String an = atts.getName(i);
            if (an.equals("xmlns")) {
                einfo.put("", atts.getValue(i));
            } else if (an.startsWith("xmlns:")) {
                einfo.put(an.substring(6).intern(), atts.getValue(i));
            }
            ++i;
        }
        this.elementStack.push(einfo);
        int index = name.indexOf(58);
        if (index < 0) {
            einfo.prefix = null;
            einfo.localPart = name;
            einfo.namespace = this.searchForNamespace("");
        } else {
            einfo.prefix = name.substring(0, index).intern();
            einfo.localPart = name.substring(index + 1).intern();
            if (einfo.prefix.length() == 0) {
                this.error(new SAXParseException("No prefix: `" + name + "'.", this.lastLocator));
            }
            if (einfo.localPart.length() == 0) {
                this.error(new SAXParseException("No localPart: `" + name + "'.", this.lastLocator));
            }
            einfo.namespace = this.searchForNamespace(einfo.prefix);
        }
        int alen = atts.getLength();
        this.attlist.removeAll();
        this.attlist.ensureCapacity(alen);
        int i2 = 0;
        while (i2 < alen) {
            String aname = atts.getName(i2);
            int ind = aname.indexOf(58);
            if (ind < 0) {
                this.attlist.addAttribute(null, null, aname, aname, atts.getType(i2), atts.getValue(i2));
            } else {
                String prefix = aname.substring(0, ind).intern();
                String localPart = aname.substring(ind + 1).intern();
                if (prefix.length() == 0) {
                    this.error(new SAXParseException("No prefix: `" + aname + "'.", this.lastLocator));
                }
                if (localPart.length() == 0) {
                    this.error(new SAXParseException("No localPart: `" + aname + "'.", this.lastLocator));
                }
                this.attlist.addAttribute(this.searchForNamespace(prefix), prefix, localPart, aname, atts.getType(i2), atts.getValue(i2));
            }
            ++i2;
        }
        if (this.handler != null) {
            this.handler.startElement(einfo.namespace, einfo.prefix, einfo.localPart, einfo.qname, this.attlist);
        }
    }

    public void endElement(String name) throws SAXException {
        if (this.elementStack.empty()) {
            return;
        }
        ElementInfo einfo = (ElementInfo)this.elementStack.peek();
        if (!einfo.qname.equals(name)) {
            return;
        }
        this.elementStack.pop();
        if (this.handler != null) {
            this.handler.endElement(einfo.namespace, einfo.prefix, einfo.localPart, einfo.qname);
        }
    }

    public String searchForNamespace(String prefix) throws SAXException {
        if (prefix.equals("xmlns")) {
            return null;
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        Stack stack = this.elementStack;
        synchronized (stack) {
            int i = this.elementStack.size() - 1;
            while (i >= 0) {
                ElementInfo einfo = (ElementInfo)this.elementStack.elementAt(i);
                String namespace = einfo.get(prefix);
                if (namespace != null) {
                    String string = namespace.length() == 0 ? null : namespace;
                    return string;
                }
                --i;
            }
        }
        if (prefix.length() == 0) {
            return null;
        }
        this.error(new SAXParseException("No namespace declaration for prefix `" + prefix + "'.", this.lastLocator));
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        this.lastLocator = locator;
        if (this.handler != null) {
            this.handler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.handler != null) {
            this.handler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.handler != null) {
            this.handler.endDocument();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.handler != null) {
            this.handler.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.handler != null) {
            this.handler.ignorableWhitespace(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.handler != null) {
            this.handler.processingInstruction(target, data);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }

    private static class NSAttribute {
        String qname;
        String prefix;
        String localPart;
        String namespace;
        String value;
        String type;

        NSAttribute(String n, String p, String l, String q, String t, String v) {
            this.qname = q;
            this.prefix = p;
            this.localPart = l;
            this.namespace = n;
            this.value = v;
            this.type = t;
        }
    }

    static class NSAttributeListImpl
    implements NSAttributeList {
        Vector values;

        public NSAttributeListImpl(int len) {
            this.values = new Vector(len);
        }

        public NSAttributeListImpl(NSAttributeList atts) {
            int len = atts.getLength();
            this.values = new Vector(len);
            int i = 0;
            while (i < len) {
                this.values.addElement(new NSAttribute(atts.getNamespace(i), atts.getPrefix(i), atts.getLocalPart(i), atts.getName(i), atts.getType(i), atts.getValue(i)));
                ++i;
            }
        }

        public int getLength() {
            return this.values.size();
        }

        public String getName(int i) {
            if (i >= this.values.size()) {
                return null;
            }
            return ((NSAttribute)this.values.elementAt((int)i)).qname;
        }

        public String getType(int i) {
            if (i >= this.values.size()) {
                return null;
            }
            return ((NSAttribute)this.values.elementAt((int)i)).type;
        }

        public String getValue(int i) {
            if (i >= this.values.size()) {
                return null;
            }
            return ((NSAttribute)this.values.elementAt((int)i)).value;
        }

        public String getType(String name) {
            Vector vector = this.values;
            synchronized (vector) {
                int i = 0;
                while (i < this.values.size()) {
                    NSAttribute nattr = (NSAttribute)this.values.elementAt(i);
                    if (name.equals(nattr.qname)) {
                        String string = nattr.type;
                        return string;
                    }
                    ++i;
                }
            }
            return null;
        }

        public String getValue(String name) {
            Vector vector = this.values;
            synchronized (vector) {
                int i = 0;
                while (i < this.values.size()) {
                    NSAttribute nattr = (NSAttribute)this.values.elementAt(i);
                    if (name.equals(nattr.qname)) {
                        String string = nattr.value;
                        return string;
                    }
                    ++i;
                }
            }
            return null;
        }

        public String getPrefix(int i) {
            if (i >= this.values.size()) {
                return null;
            }
            return ((NSAttribute)this.values.elementAt((int)i)).prefix;
        }

        public String getLocalPart(int i) {
            if (i >= this.values.size()) {
                return null;
            }
            return ((NSAttribute)this.values.elementAt((int)i)).localPart;
        }

        public String getNamespace(int i) {
            if (i >= this.values.size()) {
                return null;
            }
            return ((NSAttribute)this.values.elementAt((int)i)).namespace;
        }

        public void addAttribute(String namespace, String prefix, String localPart, String qname, String type, String value) {
            this.values.addElement(new NSAttribute(namespace, prefix, localPart, qname, type, value));
        }

        public void removeAll() {
            this.values.removeAllElements();
        }

        public void ensureCapacity(int cap) {
            this.values.ensureCapacity(cap);
        }
    }

    private static class ElementInfo {
        Hashtable xmlns;
        String qname;
        String prefix = null;
        String localPart;
        String namespace = null;

        ElementInfo(String name) {
            this.qname = name;
            this.xmlns = new Hashtable();
        }

        void put(String prefix, String namespace) {
            this.xmlns.put(prefix, namespace);
        }

        String get(String prefix) {
            return (String)this.xmlns.get(prefix);
        }
    }
}

