/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.sax;

import com.ibm.dom.util.CanonicalizerVisitor;
import com.ibm.xml.sax.NSAttributeList;
import com.ibm.xml.sax.NSDocumentHandler;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXCanonicalizer
implements NSDocumentHandler {
    private static final boolean DEBUG = false;
    Writer writer;
    int depth;

    public SAXCanonicalizer(Writer wr) {
        this.writer = wr;
        this.depth = 1;
    }

    public void setWriter(Writer wr) {
        this.writer = wr;
        this.depth = 1;
    }

    public void startElement(String namespace, String prefix, String localPart, String qname, NSAttributeList atts) throws SAXException {
        ++this.depth;
        int nsIndex = 0;
        try {
            if (namespace == null) {
                this.writer.write("<");
                this.writer.write(localPart);
            } else {
                this.writer.write("<n1:");
                this.writer.write(localPart);
                this.writer.write(" xmlns:n1=\"");
                SAXCanonicalizer.writeEscapedAttribute(namespace, this.writer);
                this.writer.write("\"");
                ++nsIndex;
            }
            int atlen = atts.getLength();
            int lenWithoutXmlns = 0;
            String[] as = new String[atlen];
            int[] indexMap = new int[atlen];
            int i = 0;
            while (i < atlen) {
                String p;
                if (!(atts.getName(i).equals("xmlns") || (p = atts.getPrefix(i)) != null && p.equals("xmlns"))) {
                    indexMap[lenWithoutXmlns++] = i;
                    as[i] = SAXCanonicalizer.createExpandedName(atts.getNamespace(i), atts.getLocalPart(i));
                }
                ++i;
            }
            CanonicalizerVisitor.heapSort(indexMap, as, lenWithoutXmlns);
            int i2 = 0;
            while (i2 < lenWithoutXmlns) {
                int attIndex = indexMap[i2];
                String ns = atts.getNamespace(attIndex);
                if (ns == null) {
                    this.writer.write(" ");
                    this.writer.write(atts.getLocalPart(attIndex));
                    this.writer.write("=\"");
                    SAXCanonicalizer.writeEscapedAttribute(atts.getValue(attIndex), this.writer);
                    this.writer.write("\"");
                } else {
                    this.writer.write(" n");
                    this.writer.write(Integer.toString(++nsIndex, 10));
                    this.writer.write(":");
                    this.writer.write(atts.getLocalPart(attIndex));
                    this.writer.write("=\"");
                    SAXCanonicalizer.writeEscapedAttribute(atts.getValue(attIndex), this.writer);
                    this.writer.write("\" xmlns:n");
                    this.writer.write(Integer.toString(nsIndex, 10));
                    this.writer.write("=\"");
                    SAXCanonicalizer.writeEscapedAttribute(ns, this.writer);
                    this.writer.write("\"");
                }
                ++i2;
            }
            this.writer.write(">");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    private static String createExpandedName(String ns, String local) {
        String ret = ns == null ? "\u0000" + local : ns + "\u0000" + local;
        return ret;
    }

    private static void writeEscapedAttribute(String string, Writer writer) throws IOException {
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if ('<' == ch) {
                writer.write("&lt;");
            } else if ('&' == ch) {
                writer.write("&amp;");
            } else if ('\t' == ch) {
                writer.write("&#x9;");
            } else if ('\n' == ch) {
                writer.write("&#xA;");
            } else if ('\r' == ch) {
                writer.write("&#xD;");
            } else if ('\"' == ch) {
                writer.write("&quot;");
            } else {
                writer.write(ch);
            }
            ++i;
        }
    }

    public void endElement(String namespace, String prefix, String localPart, String qname) throws SAXException {
        --this.depth;
        try {
            if (namespace == null) {
                this.writer.write("</");
                this.writer.write(localPart);
                this.writer.write(">");
            } else {
                this.writer.write("</n1:");
                this.writer.write(localPart);
                this.writer.write(">");
            }
            if (this.depth == 0) {
                this.writer.write("\n");
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.depth > 0) {
                SAXCanonicalizer.writeEscapedCharData(ch, start, length, this.writer);
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.depth > 0) {
                SAXCanonicalizer.writeEscapedCharData(ch, start, length, this.writer);
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    private static void writeEscapedCharData(char[] data, int start, int length, Writer writer) throws IOException {
        int i = start;
        while (i < start + length) {
            char ch = data[i];
            if ('<' == ch) {
                writer.write("&lt;");
            } else if ('&' == ch) {
                writer.write("&amp;");
            } else if ('>' == ch) {
                writer.write("&gt;");
            } else if ('\r' == ch) {
                writer.write("&#xD;");
            } else {
                writer.write(ch);
            }
            ++i;
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.writer.write("<?");
            this.writer.write(target);
            if (data != null && data.length() > 0) {
                int start = -1;
                int i = 0;
                while (i < data.length()) {
                    char ch = data.charAt(i);
                    if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') {
                        start = i;
                        break;
                    }
                    ++i;
                }
                if (start == 0) {
                    this.writer.write(" ");
                    this.writer.write(data);
                } else if (start > 0) {
                    this.writer.write(" ");
                    this.writer.write(data.substring(start));
                }
            }
            this.writer.write("?>");
            if (this.depth == 0) {
                this.writer.write("\n");
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.depth = 0;
    }

    public void endDocument() throws SAXException {
    }
}

