/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.sax;

import com.ibm.xml.sax.NSAttributeList;
import com.ibm.xml.sax.NSDocumentHandler;
import com.ibm.xml.sax.NamespaceAdapter;
import com.ibm.xml.sax.SAXEventProducer;
import java.io.IOException;
import java.util.Vector;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class SAXEventRecorder
implements SAXEventProducer {
    Vector events = new Vector();
    NSDocumentHandler handler;

    public void reset() {
        this.events.removeAllElements();
    }

    public void addSetDocumentLocator(Locator locator) {
        this.events.addElement(new EventL(locator));
    }

    public void addStartDocument() {
        this.events.addElement(new EventSD());
    }

    public void addEndDocument() {
        this.events.addElement(new EventED());
    }

    public void addStartElement(String namespace, String prefix, String localPart, String qname, NSAttributeList atts) {
        this.events.addElement(new EventSE(namespace, prefix, localPart, qname, atts));
    }

    public void addEndElement(String namespace, String prefix, String localPart, String qname) {
        this.events.addElement(new EventEE(namespace, prefix, localPart, qname));
    }

    public void addCharacters(char[] ch, int start, int length) {
        this.events.addElement(new EventC(ch, start, length));
    }

    public void addIgnorableWhitespace(char[] ch, int start, int length) {
        this.events.addElement(new EventIW(ch, start, length));
    }

    public void addProcessingInstruction(String target, String data) {
        this.events.addElement(new EventPI(target, data));
    }

    public void throwEvents(NSDocumentHandler handler) throws SAXException {
        int i = 0;
        while (i < this.events.size()) {
            Event ev = (Event)this.events.elementAt(i);
            switch (ev.getType()) {
                case 0: {
                    EventL evl = (EventL)ev;
                    handler.setDocumentLocator(evl.loc);
                    break;
                }
                case 1: {
                    handler.startDocument();
                    break;
                }
                case 2: {
                    handler.endDocument();
                    break;
                }
                case 3: {
                    EventSE evse = (EventSE)ev;
                    handler.startElement(evse.namespace, evse.prefix, evse.localPart, evse.qname, evse.atts);
                    break;
                }
                case 4: {
                    EventEE evee = (EventEE)ev;
                    handler.endElement(evee.namespace, evee.prefix, evee.localPart, evee.qname);
                    break;
                }
                case 5: {
                    EventC evc = (EventC)ev;
                    handler.characters(evc.data, 0, evc.data.length);
                    break;
                }
                case 6: {
                    EventIW eviw = (EventIW)ev;
                    handler.ignorableWhitespace(eviw.data, 0, eviw.data.length);
                    break;
                }
                case 7: {
                    EventPI evpi = (EventPI)ev;
                    handler.processingInstruction(evpi.target, evpi.data);
                    break;
                }
                default: {
                    throw new RuntimeException("Internal Error.");
                }
            }
            ++i;
        }
        this.events.removeAllElements();
    }

    public void setDocumentHandler(NSDocumentHandler doch) {
        this.handler = doch;
    }

    public void start() throws SAXException, IOException {
        this.throwEvents(this.handler);
    }

    static class EventPI
    implements Event {
        String target;
        String data;

        EventPI(String target, String data) {
            this.target = target;
            this.data = data;
        }

        public int getType() {
            return 7;
        }
    }

    static class EventIW
    implements Event {
        char[] data;

        EventIW(char[] ch, int start, int length) {
            this.data = new char[length];
            System.arraycopy(ch, start, this.data, 0, length);
        }

        public int getType() {
            return 6;
        }
    }

    static class EventC
    implements Event {
        char[] data;

        EventC(char[] ch, int start, int length) {
            this.data = new char[length];
            System.arraycopy(ch, start, this.data, 0, length);
        }

        public int getType() {
            return 5;
        }
    }

    static class EventEE
    implements Event {
        String namespace;
        String prefix;
        String localPart;
        String qname;

        EventEE(String namespace, String prefix, String localPart, String qname) {
            this.namespace = namespace;
            this.prefix = prefix;
            this.localPart = localPart;
            this.qname = qname;
        }

        public int getType() {
            return 4;
        }
    }

    static class EventSE
    implements Event {
        String namespace;
        String prefix;
        String localPart;
        String qname;
        NSAttributeList atts;

        EventSE(String namespace, String prefix, String localPart, String qname, NSAttributeList atts) {
            this.namespace = namespace;
            this.prefix = prefix;
            this.localPart = localPart;
            this.qname = qname;
            this.atts = new NamespaceAdapter.NSAttributeListImpl(atts);
        }

        public int getType() {
            return 3;
        }
    }

    static class EventL
    implements Event {
        Locator loc;

        EventL(Locator locator) {
            this.loc = new LocatorImpl(locator);
        }

        public int getType() {
            return 0;
        }
    }

    static class EventED
    implements Event {
        EventED() {
        }

        public int getType() {
            return 1;
        }
    }

    static class EventSD
    implements Event {
        EventSD() {
        }

        public int getType() {
            return 1;
        }
    }

    static interface Event {
        public static final int T_LOCATOR = 0;
        public static final int T_START_DOCUMENT = 1;
        public static final int T_END_DOCUMENT = 2;
        public static final int T_START_ELEMENT = 3;
        public static final int T_END_ELEMENT = 4;
        public static final int T_CHARACTERS = 5;
        public static final int T_IGNORABLE_WHITESPACE = 6;
        public static final int T_PROCESSING_INSTRUCTION = 7;

        public int getType();
    }
}

