/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.agent;

import com.ibm.etools.logging.tracing.agent.AgentControllerListener;
import com.ibm.etools.logging.tracing.agent.AgentControllerUnavailableException;
import com.ibm.etools.logging.tracing.agent.AgentNotRegisteredException;
import com.ibm.etools.logging.tracing.agent.MonitorListener;
import com.ibm.etools.logging.tracing.agent.RemoteClientListener;
import com.ibm.etools.logging.tracing.common.CommandElement;
import com.ibm.etools.logging.tracing.common.CommandHandler;
import com.ibm.etools.logging.tracing.control.AgentConfiguration;
import com.ibm.etools.logging.tracing.control.AgentConfigurationEntry;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class LoggingAgent {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static boolean _nativesAvailable = false;
    private boolean _isLogging = false;
    private boolean _isInitialized = false;
    protected Vector _monitorListeners = new Vector();
    protected Vector _serverListeners = new Vector();
    protected CommandHandler _handler = null;
    protected Vector _clientListeners = new Vector();
    private boolean _uuidsValid = false;
    private String _agentUUID;
    private String _nodeUUID;
    private String _jvmUUID;
    private String _name;
    private String _type;
    private boolean _isRegistered = false;
    private long _mechanism = 0L;
    private static boolean _serviceAvailable = false;
    private static int _agentCount = 0;
    private boolean _requestForMonitor = false;
    private AgentConfiguration _defaultConfiguration = null;

    public LoggingAgent(String string, String string2) {
        this.setName(string);
        this.setType(string2);
        this._defaultConfiguration = new AgentConfiguration();
        this._defaultConfiguration.setAgentName(string);
    }

    public void addAgentControllerListener(AgentControllerListener agentControllerListener) {
        Vector vector = this._serverListeners;
        synchronized (vector) {
            this._serverListeners.add(agentControllerListener);
        }
    }

    public void addMonitorListener(MonitorListener monitorListener) {
        Vector vector = this._monitorListeners;
        synchronized (vector) {
            this._monitorListeners.add(monitorListener);
        }
    }

    public void addRemoteClientListener(RemoteClientListener remoteClientListener) {
        Vector vector = this._clientListeners;
        synchronized (vector) {
            this._clientListeners.add(remoteClientListener);
        }
    }

    private void agentControllerActive() {
        _serviceAvailable = true;
        this._uuidsValid = true;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (_agentCount == 0) {
                this.getClass().notify();
            }
        }
        Vector vector = this._serverListeners;
        synchronized (vector) {
            Enumeration enumeration = this._serverListeners.elements();
            while (enumeration.hasMoreElements()) {
                AgentControllerListener agentControllerListener = (AgentControllerListener)enumeration.nextElement();
                agentControllerListener.agentControllerActive();
            }
        }
    }

    private void agentControllerInactive() {
        _serviceAvailable = false;
        this.setLogging(false);
        this._defaultConfiguration.clear();
        Vector vector = this._serverListeners;
        synchronized (vector) {
            Enumeration enumeration = this._serverListeners.elements();
            while (enumeration.hasMoreElements()) {
                AgentControllerListener agentControllerListener = (AgentControllerListener)enumeration.nextElement();
                agentControllerListener.agentControllerInactive();
            }
        }
    }

    private void remoteClientExited() {
        this.setLogging(false);
        Vector vector = this._clientListeners;
        synchronized (vector) {
            Enumeration enumeration = this._clientListeners.elements();
            while (enumeration.hasMoreElements()) {
                RemoteClientListener remoteClientListener = (RemoteClientListener)enumeration.nextElement();
                remoteClientListener.clientInactive();
            }
        }
    }

    public synchronized void deregister() {
        if (this._isInitialized) {
            this.deregister0(this._name);
            this._isInitialized = false;
            --_agentCount;
        }
    }

    private native void deregister0(String var1);

    public void finalize() {
        this.deregister0(this._name);
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public void incommingCommand(CommandElement commandElement) {
        switch ((int)commandElement.getTag()) {
            default: 
        }
        if (this._handler != null) {
            this._handler.incommingCommand(null, commandElement);
        }
    }

    public synchronized void initialize() throws AgentControllerUnavailableException {
        if (!_nativesAvailable) {
            throw new AgentControllerUnavailableException();
        }
        if (!this._isInitialized) {
            this.initializeEngine0(this._name, this._type);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (_agentCount == 0) {
                    try {
                        this.getClass().wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++_agentCount;
            }
            this._isInitialized = true;
        }
        if (!_serviceAvailable) {
            throw new AgentControllerUnavailableException();
        }
    }

    public synchronized void initializeFast() throws AgentControllerUnavailableException {
        if (!_nativesAvailable) {
            throw new AgentControllerUnavailableException();
        }
        if (!this._isInitialized) {
            this.initializeEngine0(this._name, this._type);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                ++_agentCount;
            }
            this._isInitialized = true;
        }
        if (!_serviceAvailable) {
            throw new AgentControllerUnavailableException();
        }
    }

    private native void initializeEngine0(String var1, String var2) throws AgentControllerUnavailableException;

    public boolean isAgentControllerActive() {
        return _serviceAvailable;
    }

    public boolean isLogging() {
        return this._isLogging;
    }

    public synchronized void logMessage(byte[] byArray, int n, int n2) {
        if (this._isLogging) {
            this.logMessage0(this._name, byArray, n, n2);
        }
    }

    public synchronized void logMessage(String string) {
        if (this._isLogging) {
            this.logMessage0(this._name, string);
        }
    }

    private native void logMessage0(String var1, byte[] var2, int var3, int var4);

    private native void logMessage0(String var1, String var2);

    public synchronized void logMessageUTF8(String string) {
        if (this._isLogging) {
            try {
                this.logMessageUTF81(this._name, string.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                this.logMessageUTF80(this._name, string);
            }
        }
    }

    private native void logMessageUTF81(String var1, byte[] var2);

    private native void logMessageUTF80(String var1, String var2);

    public void setCommandHandler(CommandHandler commandHandler) {
        this._handler = commandHandler;
    }

    public void sendMessageToAttachedClient(String string, long l) {
        if (_nativesAvailable) {
            this.sendMessage0(string, l);
        }
    }

    private native void sendMessage0(String var1, long var2);

    public void sendMessageToAttachedClient(byte[] byArray, int n, int n2, long l) {
        if (_nativesAvailable) {
            this.sendMessage0(byArray, n, n2, l);
        }
    }

    private native void sendMessage0(byte[] var1, int var2, int var3, long var4);

    private synchronized void setLogging(boolean bl) {
        Object object;
        this._isLogging = bl;
        Vector vector = this._monitorListeners;
        synchronized (vector) {
            object = this._monitorListeners.elements();
            while (object.hasMoreElements()) {
                MonitorListener monitorListener = (MonitorListener)object.nextElement();
                if (this._isLogging) {
                    monitorListener.monitorActive();
                    continue;
                }
                monitorListener.monitorInactive();
            }
        }
        if (this._isLogging && this._requestForMonitor) {
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
    }

    private void setName(String string) {
        this._name = new String(string);
    }

    private void setType(String string) {
        this._type = new String(string);
    }

    private void setAgentUUID(String string) {
        this._agentUUID = string;
    }

    public String getAgentUUID() {
        return this._agentUUID;
    }

    private void setNodeUUID(String string) {
        this._nodeUUID = string;
    }

    public String getNodeUUID() throws AgentNotRegisteredException {
        if (!this._uuidsValid) {
            throw new AgentNotRegisteredException();
        }
        return this._nodeUUID;
    }

    private void setJVMUUID(String string) {
        this._jvmUUID = string;
    }

    public String getJVMUUID() throws AgentNotRegisteredException {
        if (!this._uuidsValid) {
            throw new AgentNotRegisteredException();
        }
        return this._jvmUUID;
    }

    public void requestMonitorThroughPeer(InetAddress inetAddress, String string, long l) {
        if (!_nativesAvailable) {
            return;
        }
        LoggingAgent loggingAgent = this;
        synchronized (loggingAgent) {
            this._requestForMonitor = true;
            this.requestMonitorThroughPeer0(inetAddress.getAddress(), string);
            try {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    Object var8_6 = null;
                    this._requestForMonitor = false;
                }
                Object var8_5 = null;
                this._requestForMonitor = false;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this._requestForMonitor = false;
                throw throwable;
            }
        }
    }

    private native void requestMonitorThroughPeer0(byte[] var1, String var2);

    public void requestMonitorThroughPeer(InetAddress inetAddress, long l, String string, long l2) {
        if (!_nativesAvailable) {
            return;
        }
        LoggingAgent loggingAgent = this;
        synchronized (loggingAgent) {
            this._requestForMonitor = true;
            this.requestMonitorThroughPeer0(inetAddress.getAddress(), l, string);
            try {
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    Object var10_7 = null;
                    this._requestForMonitor = false;
                }
                Object var10_6 = null;
                this._requestForMonitor = false;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this._requestForMonitor = false;
                throw throwable;
            }
        }
    }

    private native void requestMonitorThroughPeer0(byte[] var1, long var2, String var4);

    private void peerUnreachable() {
        LoggingAgent loggingAgent = this;
        synchronized (loggingAgent) {
            if (this._requestForMonitor) {
                this.notifyAll();
            }
        }
    }

    public AgentConfiguration getDefaultConfiguration() {
        return this._defaultConfiguration;
    }

    private void addEntryToDefaultConfiguration(AgentConfigurationEntry agentConfigurationEntry) {
        this._defaultConfiguration.addEntry(agentConfigurationEntry);
    }

    public void broadcastMessage(String string, long l) {
        this.sendMessageToAttachedClient(string, l);
    }

    public void broadcastMessage(byte[] byArray, int n, int n2, long l) {
        this.sendMessageToAttachedClient(byArray, n, n2, l);
    }

    private Object createObjectInContextOfClassLoader(String string) {
        Object var2_2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var2_2 = clazz.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return var2_2;
    }

    static {
        try {
            System.loadLibrary("LogAgent");
            _nativesAvailable = true;
        }
        catch (Throwable throwable) {
            _nativesAvailable = false;
        }
    }
}

