/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.agent;

import com.ibm.etools.logging.tracing.agent.LoggingAgent;

public class QueueManager {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String[] _queue = new String[100];
    private int _lastMessageIndex = -1;
    private boolean _rolledOver = false;

    public synchronized void flushCurrentQueue(LoggingAgent loggingAgent) {
        try {
            int n;
            if (this._rolledOver) {
                n = this._lastMessageIndex + 1;
                while (n < this._queue.length) {
                    if (this._queue[n] != null) {
                        loggingAgent.logMessageUTF8(this._queue[n]);
                    }
                    this._queue[n] = null;
                    ++n;
                }
            }
            n = 0;
            while (n <= this._lastMessageIndex) {
                loggingAgent.logMessageUTF8(this._queue[n]);
                this._queue[n] = null;
                ++n;
            }
            this._rolledOver = false;
            this._lastMessageIndex = -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void insertInQueue(String string) {
        this._queue[++this._lastMessageIndex] = string;
        if (this._lastMessageIndex == this._queue.length - 1) {
            this._lastMessageIndex = -1;
            this._rolledOver = true;
        }
    }

    public boolean isFlushNeeded() {
        return this._lastMessageIndex != -1 || this._rolledOver;
    }
}

