/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.client;

import com.ibm.etools.logging.tracing.client.AgentInfo;
import com.ibm.etools.logging.tracing.client.IncompleteProcessSpecException;
import com.ibm.etools.logging.tracing.client.ProcessListener;
import com.ibm.etools.logging.tracing.client.RAClientEngine;
import com.ibm.etools.logging.tracing.common.AgentActiveCommand;
import com.ibm.etools.logging.tracing.common.AgentInactiveCommand;
import com.ibm.etools.logging.tracing.common.AttachToAgentCommand;
import com.ibm.etools.logging.tracing.common.CommandElement;
import com.ibm.etools.logging.tracing.common.CommandHandler;
import com.ibm.etools.logging.tracing.common.ControlMessage;
import com.ibm.etools.logging.tracing.common.DetachFromAgentCommand;
import com.ibm.etools.logging.tracing.common.ErrorCommand;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AgentAttacher
implements CommandHandler {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ProcessListener _listener = null;
    protected RAClientEngine _engine = null;

    public AgentAttacher(RAClientEngine rAClientEngine, ProcessListener processListener) {
        this._listener = processListener;
        this._engine = rAClientEngine;
    }

    public void attach(AgentInfo agentInfo) throws UnknownHostException, IncompleteProcessSpecException {
        if (this._engine == null || agentInfo.getHostname() == null) {
            throw new IncompleteProcessSpecException();
        }
        InetAddress inetAddress = this._engine.registerServer(agentInfo.getHostname());
        ControlMessage controlMessage = new ControlMessage();
        AttachToAgentCommand attachToAgentCommand = new AttachToAgentCommand();
        attachToAgentCommand.setAgentName(agentInfo.getAgentName());
        attachToAgentCommand.setProcessId(agentInfo.getProcessId());
        controlMessage.appendCommand(attachToAgentCommand);
        this._engine.sendMessage(inetAddress, controlMessage, this);
    }

    public void detach(AgentInfo agentInfo) throws UnknownHostException, IncompleteProcessSpecException {
        if (this._engine == null || agentInfo.getHostname() == null) {
            throw new IncompleteProcessSpecException();
        }
        InetAddress inetAddress = this._engine.registerServer(agentInfo.getHostname());
        ControlMessage controlMessage = new ControlMessage();
        DetachFromAgentCommand detachFromAgentCommand = new DetachFromAgentCommand();
        detachFromAgentCommand.setAgentName(agentInfo.getAgentName());
        detachFromAgentCommand.setProcessId(agentInfo.getProcessId());
        controlMessage.appendCommand(detachFromAgentCommand);
        this._engine.sendMessage(inetAddress, controlMessage, this);
    }

    public void incommingCommand(InetAddress inetAddress, CommandElement commandElement) {
        System.out.println("Incomming command: " + commandElement.getTag());
        switch ((int)commandElement.getTag()) {
            case 35: {
                this._listener.agentActive((AgentActiveCommand)commandElement);
                break;
            }
            case 36: {
                this._listener.agentInactive((AgentInactiveCommand)commandElement);
                break;
            }
            case 37: {
                this._listener.error((ErrorCommand)commandElement);
                System.out.println("Error: " + ((ErrorCommand)commandElement).getErrorString());
            }
        }
    }
}

