/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.common;

import com.ibm.etools.logging.tracing.common.AcknowledgementHandler;
import com.ibm.etools.logging.tracing.common.AcknowledgementMessage;
import com.ibm.etools.logging.tracing.common.CommandHandler;
import com.ibm.etools.logging.tracing.common.Constants;
import com.ibm.etools.logging.tracing.common.ControlMessage;
import com.ibm.etools.logging.tracing.common.Message;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public final class ControlServerDaemon
implements Constants {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private DatagramServer _server = null;
    private DatagramSocket _sock = null;
    private AcknowledgementHandler _ackHandler = null;
    private CommandHandler _cmdHandler = null;

    public void sendMessage(byte[] byArray, int n, InetAddress inetAddress) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, inetAddress, 10002);
        this._sock.send(datagramPacket);
    }

    public void setAcknowledgementHandler(AcknowledgementHandler acknowledgementHandler) {
        this._ackHandler = acknowledgementHandler;
    }

    public void setCommandHandler(CommandHandler commandHandler) {
        this._cmdHandler = commandHandler;
    }

    public void startServer() throws SocketException {
        if (this._server != null) {
            return;
        }
        this._sock = new DatagramSocket();
        this._server = new DatagramServer();
        this._server.setSocket(this._sock);
        this._server.setDaemon(true);
        this._server.start();
    }

    class DatagramServer
    extends Thread
    implements Constants {
        DatagramSocket _socket = null;

        DatagramServer() {
        }

        public void setSocket(DatagramSocket datagramSocket) {
            this._socket = datagramSocket;
        }

        public void run() {
            while (true) {
                byte[] byArray = new byte[8096];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 8096);
                try {
                    this._socket.receive(datagramPacket);
                    Message message = new Message();
                    message.readFromBuffer(datagramPacket.getData(), datagramPacket.getLength());
                    if (message.getType() != 0L) {
                        byte[] byArray2 = new byte[16];
                        AcknowledgementMessage acknowledgementMessage = new AcknowledgementMessage();
                        acknowledgementMessage.setTicket(message.getTicket());
                        acknowledgementMessage.writeToBuffer(byArray2, 0);
                        DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, 12, datagramPacket.getAddress(), datagramPacket.getPort());
                        this._socket.send(datagramPacket2);
                    }
                    this.processMessage(datagramPacket.getData(), datagramPacket.getLength(), datagramPacket.getAddress());
                }
                catch (IOException iOException) {
                }
            }
        }

        protected void processMessage(byte[] byArray, int n, InetAddress inetAddress) {
            long l = Message.readRALongFromBuffer(byArray, 8);
            switch ((int)l) {
                case 0: {
                    this.processAcknowledgementMessage(byArray, n, inetAddress);
                    break;
                }
                case 1: {
                    this.processControlMessage(byArray, n, inetAddress);
                    break;
                }
            }
        }

        protected void processAcknowledgementMessage(byte[] byArray, int n, InetAddress inetAddress) {
            if (ControlServerDaemon.this._ackHandler != null) {
                AcknowledgementMessage acknowledgementMessage = new AcknowledgementMessage();
                acknowledgementMessage.readFromBuffer(byArray, n);
                ControlServerDaemon.this._ackHandler.incommingAcknowledgement(inetAddress, acknowledgementMessage.getTicket());
            }
        }

        protected void processControlMessage(byte[] byArray, int n, InetAddress inetAddress) {
            if (ControlServerDaemon.this._cmdHandler != null) {
                ControlMessage controlMessage = new ControlMessage();
                controlMessage.readFromBuffer(byArray, n);
                int n2 = controlMessage.getCommandCount();
                int n3 = 0;
                while (n3 < n2) {
                    ControlServerDaemon.this._cmdHandler.incommingCommand(inetAddress, controlMessage.getCommand(n3));
                    ++n3;
                }
            }
        }
    }
}

