/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.common;

import com.ibm.etools.logging.tracing.common.Message;
import com.ibm.etools.logging.tracing.common.RABinaryArray;
import com.ibm.etools.logging.tracing.common.RAString;
import com.ibm.etools.logging.tracing.common.SimpleAgentInfoCommand;

public class CustomCommand
extends SimpleAgentInfoCommand {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected RAString _data;
    protected RABinaryArray _binaryData;

    public CustomCommand() {
        this._tag = 26L;
    }

    public String getData() {
        if (this._data != null) {
            return this._data.getData();
        }
        if (this._binaryData != null) {
            return new String(this._binaryData.getData(), 0);
        }
        return null;
    }

    public byte[] getDataBinary() {
        if (this._binaryData != null) {
            return this._binaryData.getData();
        }
        if (this._data != null) {
            return this._data.getData().getBytes();
        }
        return null;
    }

    public int getSize() {
        if (this._data != null) {
            return super.getSize() + this._data.getSize();
        }
        if (this._binaryData != null) {
            return super.getSize() + this._binaryData.getSize();
        }
        return super.getSize() + 4;
    }

    public int readFromBuffer(byte[] byArray, int n) {
        int n2 = super.readFromBuffer(byArray, n);
        this._binaryData = new RABinaryArray();
        n2 = Message.readRABinaryArrayFromBuffer(byArray, n2, this._binaryData);
        return n2;
    }

    public void setData(String string) {
        if (this._data == null) {
            this._data = new RAString(string);
        } else {
            this._data.setData(string);
        }
        this._binaryData = null;
    }

    public void setData(byte[] byArray) {
        if (this._binaryData == null) {
            this._binaryData = new RABinaryArray(byArray);
        } else {
            this._binaryData.setData(byArray);
        }
        this._data = null;
    }

    public int writeToBuffer(byte[] byArray, int n) {
        int n2 = super.writeToBuffer(byArray, n);
        n2 = this._data != null ? Message.writeRAStringToBuffer(byArray, n2, this._data) : (this._binaryData != null ? Message.writeRABinaryArrayToBuffer(byArray, n2, this._binaryData) : Message.writeRAStringToBuffer(byArray, n2, new RAString("")));
        return n2;
    }
}

