/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.common;

import com.ibm.etools.logging.tracing.common.CommandElement;
import com.ibm.etools.logging.tracing.common.Console;
import com.ibm.etools.logging.tracing.common.ConsoleNotStartedException;
import com.ibm.etools.logging.tracing.common.Constants;
import com.ibm.etools.logging.tracing.common.Message;
import com.ibm.etools.logging.tracing.common.RAString;
import java.util.Vector;

public class LaunchProcessCommand
extends CommandElement
implements Constants {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected RAString _args = new RAString("");
    protected RAString _exe = new RAString("");
    protected RAString _location = new RAString("");
    protected long _consoleIP = 0L;
    protected long _consolePort = 0L;
    protected Vector _environment = new Vector();
    protected Vector _agents = new Vector();

    public LaunchProcessCommand() {
        this._tag = 16L;
    }

    public void addAgent(String string) {
        this._agents.addElement(new RAString(string));
    }

    public void addEnvironmentVariable(String string, String string2) {
        this._environment.addElement(new RAString(string + "=" + string2));
    }

    public String getArgs() {
        if (this._args != null) {
            return this._args.getData();
        }
        return null;
    }

    public String getExe() {
        if (this._exe != null) {
            return this._exe.getData();
        }
        return null;
    }

    public int getSize() {
        int n = 16 + this._exe.getSize() + this._args.getSize() + this._location.getSize() + 8;
        int n2 = 0;
        while (n2 < this._agents.size()) {
            n += ((RAString)this._agents.elementAt(n2)).getSize();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this._environment.size()) {
            n += ((RAString)this._environment.elementAt(n3)).getSize();
            ++n3;
        }
        return n;
    }

    public int readFromBuffer(byte[] byArray, int n) {
        int n2 = n;
        this._context = Message.readRALongFromBuffer(byArray, n2);
        this._consoleIP = Message.readRALongFromBuffer(byArray, n2 += 4);
        this._consolePort = Message.readRALongFromBuffer(byArray, n2 += 4);
        n2 += 4;
        n2 = Message.readRAStringFromBuffer(byArray, n2, this._exe);
        n2 = Message.readRAStringFromBuffer(byArray, n2, this._args);
        n2 = Message.readRAStringFromBuffer(byArray, n2, this._location);
        long l = Message.readRALongFromBuffer(byArray, n2);
        n2 += 4;
        int n3 = 0;
        while ((long)n3 < l) {
            RAString rAString = null;
            n2 = Message.readRAStringFromBuffer(byArray, n2, rAString);
            this._agents.addElement(rAString);
            ++n3;
        }
        l = Message.readRALongFromBuffer(byArray, n2);
        n2 += 4;
        int n4 = 0;
        while ((long)n4 < l) {
            RAString rAString = null;
            n2 = Message.readRAStringFromBuffer(byArray, n2, rAString);
            this._environment.addElement(rAString);
            ++n4;
        }
        return n2;
    }

    public void setArgs(String string) {
        this._args = new RAString(string);
    }

    public void setConsole(Console console) throws ConsoleNotStartedException {
        this._consoleIP = console.getIP();
        this._consolePort = console.getPort();
    }

    public void setExe(String string) {
        this._exe = new RAString(string);
    }

    public void setLocation(String string) {
        this._location = new RAString(string);
    }

    public int writeToBuffer(byte[] byArray, int n) {
        int n2 = n;
        n2 = Message.writeRALongToBuffer(byArray, n2, this._tag);
        n2 = Message.writeRALongToBuffer(byArray, n2, this._context);
        n2 = Message.writeRALongToBuffer(byArray, n2, this._consoleIP);
        n2 = Message.writeRALongToBuffer(byArray, n2, this._consolePort);
        n2 = Message.writeRAStringToBuffer(byArray, n2, this._exe);
        n2 = Message.writeRAStringToBuffer(byArray, n2, this._args);
        n2 = Message.writeRAStringToBuffer(byArray, n2, this._location);
        n2 = Message.writeRALongToBuffer(byArray, n2, this._environment.size());
        int n3 = 0;
        while (n3 < this._environment.size()) {
            n2 = Message.writeRAStringToBuffer(byArray, n2, (RAString)this._environment.elementAt(n3));
            ++n3;
        }
        n2 = Message.writeRALongToBuffer(byArray, n2, this._agents.size());
        int n4 = 0;
        while (n4 < this._agents.size()) {
            n2 = Message.writeRAStringToBuffer(byArray, n2, (RAString)this._agents.elementAt(n4));
            ++n4;
        }
        return n2;
    }
}

