/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.common;

import com.ibm.etools.logging.tracing.common.Constants;
import com.ibm.etools.logging.tracing.common.RABinaryArray;
import com.ibm.etools.logging.tracing.common.RAInetAddress;
import com.ibm.etools.logging.tracing.common.RAString;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Message
implements Constants {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected long _version = 256L;
    protected long _type = 0L;
    protected long _ticket = 0L;

    public int getSize() {
        return 16;
    }

    public long getTicket() {
        return this._ticket;
    }

    public long getType() {
        return this._type;
    }

    public long getVersion() {
        return this._version;
    }

    public int readFromBuffer(byte[] byArray, int n) {
        Message.readRALongFromBuffer(byArray, n);
        this._version = Message.readRALongFromBuffer(byArray, n += 4);
        this._type = Message.readRALongFromBuffer(byArray, n += 4);
        this._ticket = Message.readRALongFromBuffer(byArray, n += 4);
        return n += 4;
    }

    public static long readRALongFromBuffer(byte[] byArray, int n) {
        return (long)(byArray[0 + n] << 24 & 0xFF000000) | (long)(byArray[1 + n] << 16 & 0xFF0000) | (long)(byArray[2 + n] << 8 & 0xFF00) | (long)(byArray[3 + n] & 0xFF);
    }

    public static int readRAStringFromBuffer(byte[] byArray, int n, RAString rAString) {
        long l = Message.readRALongFromBuffer(byArray, n);
        String string = new String(byArray, 0, n + 4, (int)l);
        rAString.setData(string);
        return n + rAString.getSize();
    }

    public static int readRABinaryArrayFromBuffer(byte[] byArray, int n, RABinaryArray rABinaryArray) {
        long l = Message.readRALongFromBuffer(byArray, n);
        rABinaryArray.setData(byArray, n + 4, (int)l);
        return n + rABinaryArray.getSize();
    }

    public static int readRAInetAddressFromBuffer(byte[] byArray, int n, RAInetAddress rAInetAddress) {
        int n2 = byArray[0 + n];
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[1 + n3];
            ++n3;
        }
        rAInetAddress.setLength(n2);
        rAInetAddress.setData(byArray2);
        return n + 1 + n2;
    }

    public void setTicket(long l) {
        this._ticket = l;
    }

    public void setVersion(long l) {
        this._version = l;
    }

    public static int writeRALongToBuffer(byte[] byArray, int n, long l) {
        byArray[0 + n] = (byte)(l >> 24 & 0xFFL);
        byArray[1 + n] = (byte)(l >> 16 & 0xFFL);
        byArray[2 + n] = (byte)(l >> 8 & 0xFFL);
        byArray[3 + n] = (byte)l;
        return n + 4;
    }

    public static int writeRAStringToBuffer(byte[] byArray, int n, RAString rAString) {
        Message.writeRALongToBuffer(byArray, n, rAString.length());
        byte[] byArray2 = rAString.getData().getBytes();
        System.arraycopy(byArray2, 0, byArray, n + 4, (int)rAString.length());
        return n + rAString.getSize();
    }

    public static int writeRABinaryArrayToBuffer(byte[] byArray, int n, RABinaryArray rABinaryArray) {
        if (rABinaryArray == null) {
            Message.writeRALongToBuffer(byArray, n, 0L);
            return n + 4;
        }
        byte[] byArray2 = rABinaryArray.getData();
        Message.writeRALongToBuffer(byArray, n, byArray2.length);
        System.arraycopy(byArray2, 0, byArray, n + 4, byArray2.length);
        return n + rABinaryArray.getSize();
    }

    public static int writeRAInetAddressToBuffer(byte[] byArray, int n, RAInetAddress rAInetAddress) {
        if (rAInetAddress == null) {
            byArray[n] = 0;
            return n + 1;
        }
        try {
            InetAddress inetAddress = rAInetAddress.getAddress();
            if (inetAddress == null) {
                byArray[n] = 0;
                return n + 1;
            }
            byte[] byArray2 = inetAddress.getAddress();
            byArray[n + 0] = (byte)byArray2.length;
            int n2 = 0;
            while (n2 < byArray2.length) {
                byArray[n + n2 + 1] = byArray2[n2];
                ++n2;
            }
            return n + 1 + byArray2.length;
        }
        catch (UnknownHostException unknownHostException) {
            byArray[n] = 0;
            return n + 1;
        }
    }

    public int writeToBuffer(byte[] byArray, int n) {
        int n2 = n;
        n2 = Message.writeRALongToBuffer(byArray, n2, -2107283584L);
        n2 = Message.writeRALongToBuffer(byArray, n2, 256L);
        n2 = Message.writeRALongToBuffer(byArray, n2, this._type);
        n2 = Message.writeRALongToBuffer(byArray, n2, this._ticket);
        return n2;
    }
}

