/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.common;

import com.ibm.etools.logging.tracing.common.Message;
import com.ibm.etools.logging.tracing.common.RABinaryArray;
import com.ibm.etools.logging.tracing.common.RAString;
import com.ibm.etools.logging.tracing.common.SimpleAgentInfoCommand;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MonitorPeerRequestCommand
extends SimpleAgentInfoCommand {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2002 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected RABinaryArray _peerNode = new RABinaryArray();
    protected RABinaryArray _targetNode = new RABinaryArray();
    protected RAString _peerName = new RAString("");
    protected long _peerProcessId;
    private InetAddress _peerAddress = null;
    private InetAddress _targetAddress = null;

    public MonitorPeerRequestCommand() {
        this._tag = 98L;
    }

    public int getSize() {
        return super.getSize() + this._peerNode.getSize() + 4 + this._peerName.getSize();
    }

    public InetAddress getPeerNode() throws UnknownHostException {
        if (this._peerAddress != null) {
            return this._targetAddress;
        }
        if (this._peerNode.length() == 0L) {
            return null;
        }
        byte[] byArray = this._peerNode.getData();
        String string = new String();
        string = string + this.convertPointAddress(new Byte(byArray[0]).intValue());
        int n = 1;
        while ((long)n < this._peerNode.length()) {
            string = string + "." + this.convertPointAddress(new Byte(byArray[n]).intValue());
            ++n;
        }
        return InetAddress.getByName(string);
    }

    public InetAddress getTargetNode() throws UnknownHostException {
        if (this._targetAddress != null) {
            return this._targetAddress;
        }
        if (this._targetNode.length() == 0L) {
            return null;
        }
        byte[] byArray = this._targetNode.getData();
        String string = new String();
        string = string + this.convertPointAddress(new Byte(byArray[0]).intValue());
        int n = 1;
        while ((long)n < this._targetNode.length()) {
            string = string + "." + this.convertPointAddress(new Byte(byArray[n]).intValue());
            ++n;
        }
        return InetAddress.getByName(string);
    }

    public String getPeerAgentName() {
        if (this._peerName != null) {
            return this._peerName.getData();
        }
        return null;
    }

    public long getPeerProcessId() {
        return this._peerProcessId;
    }

    public int readFromBuffer(byte[] byArray, int n) {
        int n2 = super.readFromBuffer(byArray, n);
        n2 = Message.readRABinaryArrayFromBuffer(byArray, n2, this._targetNode);
        this._peerProcessId = Message.readRALongFromBuffer(byArray, n2);
        n2 += 4;
        n2 = Message.readRAStringFromBuffer(byArray, n2, this._peerName);
        n2 = Message.readRABinaryArrayFromBuffer(byArray, n2, this._peerNode);
        return n2;
    }

    public int writeToBuffer(byte[] byArray, int n) {
        int n2 = super.writeToBuffer(byArray, n);
        n2 = Message.writeRABinaryArrayToBuffer(byArray, n2, this._targetNode);
        n2 = Message.writeRALongToBuffer(byArray, n2, this._peerProcessId);
        n2 = Message.writeRAStringToBuffer(byArray, n2, this._peerName);
        n2 = Message.writeRABinaryArrayToBuffer(byArray, n2, this._peerNode);
        return n2;
    }

    private int convertPointAddress(int n) {
        if (n < 0) {
            n = 256 - Math.abs(n);
        }
        return n;
    }
}

