/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.control;

import com.ibm.etools.logging.tracing.common.CommandElement;
import com.ibm.etools.logging.tracing.common.Console;
import com.ibm.etools.logging.tracing.common.ConsoleNotStartedException;
import com.ibm.etools.logging.tracing.common.ControlMessage;
import com.ibm.etools.logging.tracing.common.DetailedAgentInfoCommand;
import com.ibm.etools.logging.tracing.common.ErrorCommand;
import com.ibm.etools.logging.tracing.common.LaunchProcessCommand;
import com.ibm.etools.logging.tracing.common.ProcessLaunchedCommand;
import com.ibm.etools.logging.tracing.common.SimpleAgentInfoCommand;
import com.ibm.etools.logging.tracing.control.Agent;
import com.ibm.etools.logging.tracing.control.AgentFactory;
import com.ibm.etools.logging.tracing.control.AgentImpl;
import com.ibm.etools.logging.tracing.control.AgentListener;
import com.ibm.etools.logging.tracing.control.CommandHandler;
import com.ibm.etools.logging.tracing.control.Connection;
import com.ibm.etools.logging.tracing.control.ConnectionListener;
import com.ibm.etools.logging.tracing.control.InactiveProcessException;
import com.ibm.etools.logging.tracing.control.NoSuchApplicationException;
import com.ibm.etools.logging.tracing.control.Node;
import com.ibm.etools.logging.tracing.control.NotConnectedException;
import com.ibm.etools.logging.tracing.control.Process;
import com.ibm.etools.logging.tracing.control.ProcessActiveException;
import com.ibm.etools.logging.tracing.control.ProcessListener;
import com.ibm.etools.logging.tracing.control.Variable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ProcessImpl
implements Process,
AgentListener,
ConnectionListener {
    protected String _name = null;
    protected String _exe = null;
    protected String _params = null;
    protected String _location = null;
    protected String _processId = null;
    protected String _UUID = null;
    protected Node _node = null;
    protected Console _console = null;
    protected boolean _isActive = false;
    protected boolean _isComplete = false;
    protected Vector _agents = new Vector(10);
    protected Vector _variables = new Vector(20);
    protected Vector _listeners = new Vector(10);
    private Object _launcherLock = new Object();
    private Object _eclipseLock = new Object();
    private boolean _requireEclipseLock = false;
    private boolean _noSuchAliasExceptionThrown = false;
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001, 2002 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ProcessImpl(Node node) {
        this._node = node;
    }

    public ProcessImpl(Node node, String string) {
        this(node, string, null);
    }

    public ProcessImpl(Node node, String string, String string2) {
        this._node = node;
        this._exe = string;
        this._params = string2;
        this._console = new Console();
    }

    public ProcessImpl(Node node, String string, long l) {
        this._node = node;
        this._exe = string;
        this._processId = new Long(l).toString();
        this._isActive = true;
    }

    public void launch() throws ProcessActiveException, NotConnectedException, NoSuchApplicationException {
        Object object;
        Object object2;
        if (this.isActive() || this._isComplete) {
            throw new ProcessActiveException();
        }
        ControlMessage controlMessage = new ControlMessage();
        LaunchProcessCommand launchProcessCommand = new LaunchProcessCommand();
        launchProcessCommand.setExe(this._exe);
        launchProcessCommand.setArgs(this._params);
        launchProcessCommand.setLocation(this._location);
        if (this._console == null) {
            this._console = new Console();
        }
        this._console.start();
        try {
            launchProcessCommand.setConsole(this._console);
        }
        catch (ConsoleNotStartedException consoleNotStartedException) {
            // empty catch block
        }
        Enumeration enumeration = this._variables.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Variable)enumeration.nextElement();
            launchProcessCommand.addEnvironmentVariable(((Variable)object2).getName(), ((Variable)object2).getValue());
        }
        enumeration = this._agents.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Agent)enumeration.nextElement();
            launchProcessCommand.addAgent(object2.getName());
        }
        controlMessage.appendCommand(launchProcessCommand);
        object2 = this._node.getConnection();
        Object object3 = this._launcherLock;
        synchronized (object3) {
            try {
                object2.addConnectionListener(this);
                this._requireEclipseLock = false;
                object2.sendMessage(controlMessage, new CommandHandler(){

                    public void incommingCommand(Node node, CommandElement commandElement) {
                        ProcessImpl.this.handleCommand(commandElement);
                    }
                });
                this._requireEclipseLock = true;
            }
            catch (IOException iOException) {
                throw new NotConnectedException();
            }
            try {
                this._launcherLock.wait(7000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            Vector vector = this._listeners;
            synchronized (vector) {
                enumeration = this._listeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((ProcessListener)enumeration.nextElement()).processLaunched(this);
                }
            }
            Object var10_12 = null;
            object = this._eclipseLock;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            Object object4 = this._eclipseLock;
            synchronized (object4) {
                this._eclipseLock.notify();
            }
            object2.removeConnectionListener(this);
            if (!object2.isActive()) {
                if (this._noSuchAliasExceptionThrown) {
                    this._noSuchAliasExceptionThrown = false;
                    throw new NoSuchApplicationException();
                }
                throw new NotConnectedException();
            }
            if (!this.isActive()) {
                this._console.close();
            }
            throw throwable;
        }
        synchronized (object) {
            this._eclipseLock.notify();
        }
        object2.removeConnectionListener(this);
        if (!object2.isActive()) {
            if (this._noSuchAliasExceptionThrown) {
                this._noSuchAliasExceptionThrown = false;
                throw new NoSuchApplicationException();
            }
            throw new NotConnectedException();
        }
        if (!this.isActive()) {
            this._console.close();
        }
    }

    public void kill(long l) throws InactiveProcessException, NotConnectedException {
        if (this._node == null) {
            throw new InactiveProcessException();
        }
        this._node.killProcess(this);
    }

    public void addAgent(Agent agent) {
        if (!this._agents.contains(agent)) {
            this._agents.addElement(agent);
        }
    }

    public Enumeration listAgents() {
        return ((Vector)this._agents.clone()).elements();
    }

    public Enumeration getAgentsByType(String string) {
        Vector<Agent> vector = new Vector<Agent>();
        Vector vector2 = this._agents;
        synchronized (vector2) {
            Enumeration enumeration = this.listAgents();
            while (enumeration.hasMoreElements()) {
                Agent agent = (Agent)enumeration.nextElement();
                if (!agent.getType().equals(string)) continue;
                vector.addElement(agent);
            }
        }
        return vector.elements();
    }

    public Agent getAgent(String string) {
        Vector vector = this._agents;
        synchronized (vector) {
            Enumeration enumeration = this.listAgents();
            while (enumeration.hasMoreElements()) {
                Agent agent = (Agent)enumeration.nextElement();
                if (!agent.getName().equals(string)) continue;
                Agent agent2 = agent;
                return agent2;
            }
        }
        return null;
    }

    public Enumeration getEnvironment() {
        return this._variables.elements();
    }

    public void addProcessListener(ProcessListener processListener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(processListener)) {
                this._listeners.add(processListener);
            }
        }
    }

    public void removeProcessListener(ProcessListener processListener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(processListener)) {
                this._listeners.remove(processListener);
            }
        }
    }

    public Node getNode() {
        return this._node;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public String getUUID() {
        return this._UUID;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public Console getConsole() {
        if (this._console == null) {
            this._console = new Console();
        }
        return this._console;
    }

    public void addEnvironmentVariable(Variable variable) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._variables.add(variable);
    }

    public Variable getEnvironmentVariable(String string) {
        Enumeration enumeration = this.getEnvironment();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (!variable.getName().equals(string)) continue;
            return variable;
        }
        return null;
    }

    public void removeEnvironmentVariable(Variable variable) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._variables.remove(variable);
    }

    public void setExecutable(String string) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._exe = string;
    }

    public String getExecutable() {
        return this._exe;
    }

    public void setParameters(String string) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._params = string;
    }

    public String getParameters() {
        return this._params;
    }

    public void setLocation(String string) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._location = string;
    }

    public String getProcessId() throws InactiveProcessException {
        if (this._processId == null) {
            throw new InactiveProcessException();
        }
        return this._processId;
    }

    public void agentActive(Agent agent) {
        if (!this._agents.contains(agent)) {
            this._agents.add(agent);
        }
    }

    public void agentInactive(Agent agent) {
    }

    public void error(Agent agent, String string, String string2) {
    }

    public void handleCommand(Agent agent, CommandElement commandElement) {
    }

    public void connectionClosed(Connection connection) {
        Object object = this._eclipseLock;
        synchronized (object) {
            Object object2 = this._launcherLock;
            synchronized (object2) {
                this._launcherLock.notify();
                if (!this._requireEclipseLock) {
                    return;
                }
            }
            try {
                this._eclipseLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String getlocation() {
        return this._location;
    }

    public void setUUID(String string) {
        this._UUID = string;
    }

    protected void handleCommand(CommandElement commandElement) {
        switch ((int)commandElement.getTag()) {
            case 32: {
                Object object;
                if (this._isActive) break;
                ProcessLaunchedCommand processLaunchedCommand = (ProcessLaunchedCommand)commandElement;
                this._processId = new Long(processLaunchedCommand.getProcessId()).toString();
                this._UUID = processLaunchedCommand.getProcessUUID();
                this._variables.removeAllElements();
                String[] stringArray = processLaunchedCommand.getEnvironment();
                int n = 0;
                while (n < stringArray.length) {
                    int n2 = stringArray[n].indexOf(61);
                    if (n2 > 0) {
                        object = stringArray[n].substring(0, n2);
                        String string = stringArray[n].substring(n2 + 1);
                        this._variables.addElement(new Variable((String)object, string));
                    }
                    ++n;
                }
                this._isActive = true;
                Object object2 = this._eclipseLock;
                synchronized (object2) {
                    object = this._launcherLock;
                    synchronized (object) {
                        this._launcherLock.notify();
                        if (!this._requireEclipseLock) {
                            break;
                        }
                    }
                    try {
                        this._eclipseLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    break;
                }
            }
            case 35: 
            case 36: {
                DetailedAgentInfoCommand detailedAgentInfoCommand = (DetailedAgentInfoCommand)commandElement;
                Vector vector = this._agents;
                synchronized (vector) {
                    Agent agent;
                    Agent agent2 = null;
                    Enumeration enumeration = this._agents.elements();
                    while (enumeration.hasMoreElements()) {
                        agent = (Agent)enumeration.nextElement();
                        if (!agent.getName().equals(detailedAgentInfoCommand.getAgentName())) continue;
                        agent2 = agent;
                        break;
                    }
                    if (agent2 == null) {
                        agent2 = AgentFactory.createAgent(this, detailedAgentInfoCommand.getAgentName(), detailedAgentInfoCommand.getAgentType());
                        ((AgentImpl)agent2).setUUID(detailedAgentInfoCommand.getAgentUUID());
                    }
                    try {
                        agent = (AgentImpl)agent2;
                        ((AgentImpl)agent).handleCommand(commandElement);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    break;
                }
            }
            case 37: {
                ErrorCommand errorCommand = (ErrorCommand)commandElement;
                if (!errorCommand.getErrorId().equals("RAC002")) break;
                this._noSuchAliasExceptionThrown = true;
                Object object = this._launcherLock;
                synchronized (object) {
                    this._launcherLock.notify();
                    break;
                }
            }
            case 41: {
                if (this._isComplete) break;
                this._isComplete = true;
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration enumeration = this._listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((ProcessListener)enumeration.nextElement()).processExited(this);
                    }
                    break;
                }
            }
            default: {
                if (!(commandElement instanceof SimpleAgentInfoCommand)) break;
                Agent agent = this.getAgent(((SimpleAgentInfoCommand)commandElement).getAgentName());
                try {
                    if (agent == null) break;
                    ((AgentImpl)agent).handleCommand(commandElement);
                    break;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    }
}

