/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class KeyStoreHelper {
    public static KeyStore createKeyStore(String string, String string2) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NoSuchProviderException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        File file = new File(string);
        if (file.exists()) {
            return KeyStoreHelper.loadKeyStore(string, string2);
        }
        keyStore.load(null, string2.toCharArray());
        KeyStoreHelper.persistKeyStore(keyStore, string, string2);
        return keyStore;
    }

    public static KeyStore loadKeyStore(String string, String string2) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NoSuchProviderException {
        KeyStore keyStore = null;
        File file = new File(string);
        if (file.exists()) {
            keyStore = KeyStore.getInstance("JKS");
            FileInputStream fileInputStream = new FileInputStream(file);
            keyStore.load(fileInputStream, string2.toCharArray());
            fileInputStream.close();
        }
        return keyStore;
    }

    public static Certificate loadCertificate(String string) throws CertificateException, FileNotFoundException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return certificateFactory.generateCertificate(new FileInputStream(string));
    }

    public static void addCertificateToKeyStore(KeyStore keyStore, Certificate certificate, String string) throws KeyStoreException {
        keyStore.setCertificateEntry(string, certificate);
    }

    public static void persistKeyStore(KeyStore keyStore, String string, String string2) throws KeyStoreException, FileNotFoundException, NoSuchAlgorithmException, CertificateException, IOException {
        keyStore.store(new FileOutputStream(string), string2.toCharArray());
    }

    public static void main(String[] stringArray) {
        try {
            KeyStore keyStore = KeyStoreHelper.createKeyStore("d:\\build\\ikeyman\\genkey", "richard");
            Certificate certificate = KeyStoreHelper.loadCertificate("d:\\build\\ikeyman\\cert.arm");
            KeyStoreHelper.addCertificateToKeyStore(keyStore, certificate, "richardCA");
            KeyStoreHelper.persistKeyStore(keyStore, "d:\\build\\ikeyman\\genkey", "richard");
        }
        catch (Exception exception) {
            System.out.println("Error creating keystore " + exception.getMessage());
        }
    }
}

