/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util;

import com.ibm.etools.logging.util.AbstractMessageLogger;
import com.ibm.etools.logging.util.LoggingUtilities;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractMessageLoggerFactory {
    public static final String abstractMessageLoggerFactoryCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Hashtable loggers = new Hashtable();

    protected abstract AbstractMessageLogger createProperLogger();

    public final void closeAllFileHandles() {
        Enumeration enumeration = this.loggers.elements();
        while (enumeration.hasMoreElements()) {
            ((AbstractMessageLogger)enumeration.nextElement()).closeFile();
        }
    }

    public final void destroyLogger(String string) throws IllegalArgumentException {
        if (LoggingUtilities.isValidLoggerName(string)) {
            String string2 = string.trim();
            Hashtable hashtable = this.loggers;
            synchronized (hashtable) {
                if (this.loggers.containsKey(string2)) {
                    AbstractMessageLogger abstractMessageLogger = (AbstractMessageLogger)this.loggers.remove(string2);
                    abstractMessageLogger.finalize();
                }
            }
        } else {
            throw new IllegalArgumentException(LoggingUtilities.getResourceString("ILLEGAL_LOGGING_NAME_EXC_"));
        }
    }

    public final AbstractMessageLogger getLogger(String string, Plugin plugin) throws IllegalArgumentException {
        if (LoggingUtilities.isValidLoggerName(string)) {
            AbstractMessageLogger abstractMessageLogger;
            String string2 = new String(string.trim());
            Hashtable hashtable = this.loggers;
            synchronized (hashtable) {
                if (this.loggers.containsKey(string2)) {
                    abstractMessageLogger = (AbstractMessageLogger)this.loggers.get(string2);
                    if (plugin != null) {
                        abstractMessageLogger.setPlugin(plugin);
                    }
                } else {
                    abstractMessageLogger = this.createProperLogger();
                    if (plugin != null) {
                        abstractMessageLogger.setPlugin(plugin);
                    }
                    abstractMessageLogger.initialize(string2);
                    this.loggers.put(string2, abstractMessageLogger);
                }
            }
            return abstractMessageLogger;
        }
        throw new IllegalArgumentException(LoggingUtilities.getResourceString("ILLEGAL_LOGGING_NAME_EXC_"));
    }

    public final AbstractMessageLogger getLogger(String string) throws IllegalArgumentException {
        return this.getLogger(string, null);
    }

    public final AbstractMessageLogger createLogger(String string) throws IllegalArgumentException {
        return this.getLogger(string);
    }
}

