/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util;

import com.ibm.etools.logging.util.Level;
import com.ibm.etools.logging.util.LoggingUtilities;
import com.ibm.etools.logging.util.SubstitutionVariable;
import java.net.InetAddress;
import java.util.Date;

public class DefaultRecord {
    public static final String defaultRecordCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2000, 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String componentName = null;
    private String messageID = null;
    private String message = null;
    private String threadName = null;
    private String sourceClassName = null;
    private String sourceMethodName = null;
    private String date = null;
    private String product = null;
    private String version = null;
    private static String _hostName = null;
    private static String _hostAddress = null;
    private int severity = 0;
    private long millis = 0L;
    private long sequenceNumber = 0L;
    private static long currentSequenceNumber = 0L;
    private SubstitutionVariable[] substitutionVariables = null;

    public DefaultRecord() {
        this(null, null, null, null, null, null, 0, null, null);
    }

    public DefaultRecord(String string, String string2, String string3, Object object, String string4, String string5, int n, String string6, SubstitutionVariable[] substitutionVariableArray) {
        this.product = string;
        this.version = string2;
        this.componentName = string3;
        this.setSourceClassName(object);
        this.sourceMethodName = string4;
        this.messageID = string5;
        this.setSeverity(n);
        this.message = string6;
        this.substitutionVariables = substitutionVariableArray;
        this.sequenceNumber = currentSequenceNumber++;
        this.millis = System.currentTimeMillis();
        Date date = new Date(this.millis);
        this.date = date.toString();
        this.threadName = Thread.currentThread().getName();
    }

    public DefaultRecord(String string, Object object, String string2, String string3, int n, String string4, SubstitutionVariable[] substitutionVariableArray) {
        this("WebSphere Studio Workbench", "Version: R5", string, object, string2, string3, n, string4, substitutionVariableArray);
    }

    public DefaultRecord(String string, Object object, String string2, int n, String string3) {
        this(string, object, string2, null, n, string3, null);
    }

    public DefaultRecord(String string, Object object, String string2, String string3, int n, SubstitutionVariable[] substitutionVariableArray) {
        this(string, object, string2, string3, n, null, substitutionVariableArray);
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getMessage() {
        return this.message;
    }

    public long getMillis() {
        return this.millis;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getDate() {
        return this.date;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHostName() {
        return _hostName;
    }

    public String getHostAddress() {
        return _hostAddress;
    }

    public SubstitutionVariable[] getMessageVars() {
        return this.substitutionVariables;
    }

    public void setComponentName(String string) {
        this.componentName = string;
    }

    public void setMessageID(String string) {
        this.messageID = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public void setThreadName(String string) {
        this.threadName = string;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public void setSourceClassName(Object object) {
        this.sourceClassName = object != null ? (object instanceof String ? (String)object : (object instanceof Class ? ((Class)object).getName() : object.getClass().getName())) : null;
    }

    public void setSourceMethodName(String string) {
        this.sourceMethodName = string;
    }

    public final void setSeverity(int n) throws IllegalArgumentException {
        if (!Level.isValidLevel(n)) {
            throw new IllegalArgumentException(LoggingUtilities.getResourceString("ILLEGAL_LOGGING_LEVEL_EXC_"));
        }
        this.severity = n;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public void setProduct(String string) {
        this.product = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setHostName(String string) {
        _hostName = string;
    }

    public void setHostAddress(String string) {
        _hostAddress = string;
    }

    public void setMessageVars(SubstitutionVariable[] substitutionVariableArray) {
        this.substitutionVariables = substitutionVariableArray;
    }

    public String toString() {
        String string = ", ";
        StringBuffer stringBuffer = new StringBuffer("com.ibm.etools.logging.util.DefaultRecord[");
        stringBuffer.append("Class=").append(this.getClass().getName());
        stringBuffer.append(string).append("ComponentName=").append(this.componentName);
        stringBuffer.append(string).append("MessageID=").append(this.messageID);
        stringBuffer.append(string).append("Message=").append(this.message);
        stringBuffer.append(string).append("Millis=").append(this.millis);
        stringBuffer.append(string).append("ThreadName=").append(this.threadName);
        stringBuffer.append(string).append("SequenceNumber=").append(this.sequenceNumber);
        stringBuffer.append(string).append("SourceClassName=").append(this.sourceClassName);
        stringBuffer.append(string).append("SourceMethodName=").append(this.sourceMethodName);
        stringBuffer.append(string).append("Severity=").append(this.severity);
        stringBuffer.append(string).append("Date=").append(this.date);
        stringBuffer.append(string).append("Product=").append(this.product);
        stringBuffer.append(string).append("HostName=").append(_hostName);
        stringBuffer.append(string).append("HostAddress=").append(_hostAddress);
        if (this.substitutionVariables != null) {
            stringBuffer.append(string).append(LoggingUtilities.objectToString(this.substitutionVariables));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        try {
            _hostAddress = InetAddress.getLocalHost().getHostAddress();
            _hostName = InetAddress.getByName(_hostAddress).getHostName();
        }
        catch (Exception exception) {
            _hostAddress = "127.0.0.1";
            _hostName = "localhost";
        }
    }
}

