/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util;

import com.ibm.etools.logging.util.Constants;
import com.ibm.etools.logging.util.LoggingUtilPlugin;
import com.ibm.etools.logging.util.SubstitutionVariable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public final class LoggingUtilities {
    public static final String loggingUtilitiesCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Hashtable fileHandles = new Hashtable();
    private static Hashtable filesWithProcessIds = new Hashtable();
    private static ResourceBundle resourceBundle = null;
    private static Hashtable archivedFiles = new Hashtable();

    protected static void archiveFile(String string) {
        if (string != null && string.trim().length() != 0) {
            File file = new File(string);
            String string2 = file.getAbsolutePath().trim();
            if (file.isFile() && !archivedFiles.containsKey(string2)) {
                String string3 = file.getName().trim();
                StringBuffer stringBuffer = new StringBuffer(string3);
                if (string3.indexOf(46) != -1) {
                    stringBuffer.insert(string3.lastIndexOf(46), String.valueOf(System.currentTimeMillis()));
                } else {
                    stringBuffer.append(String.valueOf(System.currentTimeMillis()));
                }
                try {
                    if (!file.renameTo(new File(file.getParent(), stringBuffer.toString()))) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    System.err.println("");
                    System.err.println(LoggingUtilities.getResourceString("ERROR_UI_") + "  " + LoggingUtilities.getResourceString("ARCHIVE_FILE_ERROR_", string2));
                    System.err.println("");
                }
            }
            archivedFiles.put(string2, "");
        }
    }

    protected static void deleteArchivedFiles(String string, int n) {
        File file;
        File file2;
        if (n == 0) {
            return;
        }
        if (string != null && string.trim().length() != 0 && (file2 = (file = new File(string)).getParentFile()).exists()) {
            long l = System.currentTimeMillis();
            long l2 = n * 86400000;
            File[] fileArray = file2.listFiles();
            String string2 = file.getName().trim();
            String string3 = "";
            if (string2.indexOf(46) != -1) {
                string3 = string2.substring(string2.lastIndexOf(46));
                string2 = string2.substring(0, string2.lastIndexOf(46));
            }
            int n2 = 0;
            while (n2 < fileArray.length) {
                String string4;
                File file3 = fileArray[n2];
                if (file3.isFile() && (string4 = file3.getName().trim()).startsWith(string2) && string4.endsWith(string3)) {
                    try {
                        long l3 = Long.parseLong(string4.substring(string2.length(), string4.lastIndexOf(string3)));
                        if (l - l3 >= l2 && !file3.delete()) {
                            System.err.println("");
                            System.err.println(LoggingUtilities.getResourceString("ERROR_UI_") + "  " + LoggingUtilities.getResourceString("ARCHIVE_FILE_DELETE_ERROR_", file.getAbsolutePath()));
                            System.err.println("");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
    }

    protected static synchronized String getProcessId(String string) {
        String string2;
        String string3 = new File(string).getAbsolutePath();
        if (filesWithProcessIds.containsKey(string3)) {
            string2 = (String)filesWithProcessIds.get(string3);
        } else {
            String string4 = "";
            String string5 = "";
            String string6 = null;
            StringBuffer stringBuffer = null;
            try {
                string4 = InetAddress.getLocalHost().getHostAddress();
                string5 = InetAddress.getByName(string4).getHostName();
            }
            catch (Exception exception) {
                string4 = "127.0.0.1";
                string5 = "localhost";
            }
            String string7 = "NODE".concat(".").concat(string5);
            String string8 = LoggingUtilities.currentTimeSeconds();
            if (new File(string).length() == 0L) {
                string6 = "<!-- com.ibm.etools.logging.util log file -->";
                stringBuffer = new StringBuffer("<");
                stringBuffer.append("NODE");
                stringBuffer.append(" ");
                stringBuffer.append("logging.util.node_id");
                stringBuffer.append("=\"" + string7 + "\" ");
                stringBuffer.append("logging.util.hostname");
                stringBuffer.append("=\"" + string5 + "\" ");
                stringBuffer.append("logging.util.ipaddress");
                stringBuffer.append("=\"" + string4 + "\" ");
                stringBuffer.append("logging.util.timezone");
                stringBuffer.append("=\"" + Math.abs(Calendar.getInstance().get(15)) / 60000 + "\" ");
                stringBuffer.append("logging.util.time");
                stringBuffer.append("=\"" + string8 + "\"");
                stringBuffer.append("/>");
            }
            string2 = "PROCESS_CREATE".concat(".eclipse.").concat(string8);
            StringBuffer stringBuffer2 = new StringBuffer("<");
            stringBuffer2.append("PROCESS_CREATE");
            stringBuffer2.append(" ");
            stringBuffer2.append("logging.util.process_id");
            stringBuffer2.append("=\"" + string2 + "\" ");
            stringBuffer2.append("logging.util.pid");
            stringBuffer2.append("=\"" + Runtime.getRuntime().hashCode() + "\" ");
            stringBuffer2.append("logging.util.node_idref");
            stringBuffer2.append("=\"" + string7 + "\" ");
            stringBuffer2.append("logging.util.time");
            stringBuffer2.append("=\"" + string8 + "\" ");
            stringBuffer2.append("logging.util.process_environment");
            stringBuffer2.append("=\"unknown\" ");
            stringBuffer2.append("logging.util.process_application_execution");
            stringBuffer2.append("=\"\"");
            stringBuffer2.append("/>");
            BufferedWriter bufferedWriter = LoggingUtilities.getFileHandle(string);
            try {
                BufferedWriter bufferedWriter2 = bufferedWriter;
                synchronized (bufferedWriter2) {
                    if (string6 != null) {
                        bufferedWriter.write(string6);
                        bufferedWriter.newLine();
                        bufferedWriter.flush();
                    }
                    if (stringBuffer != null) {
                        bufferedWriter.write(stringBuffer.toString());
                        bufferedWriter.newLine();
                        bufferedWriter.flush();
                    }
                    bufferedWriter.write(stringBuffer2.toString());
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
                filesWithProcessIds.put(string3, string2);
            }
            catch (Exception exception) {
                string2 = null;
            }
            LoggingUtilities.closeFileHandle(string);
        }
        return string2;
    }

    protected static synchronized BufferedWriter getFileHandle(String string) {
        BufferedWriter bufferedWriter;
        String string2 = new File(string).getAbsolutePath();
        if (fileHandles.containsKey(string2)) {
            SubstitutionVariable substitutionVariable = (SubstitutionVariable)fileHandles.get(string2);
            substitutionVariable.setKey(String.valueOf(Integer.parseInt(substitutionVariable.getKey()) + 1));
            bufferedWriter = (BufferedWriter)substitutionVariable.getVariable();
        } else {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string, true));
                fileHandles.put(string2, new SubstitutionVariable("1", bufferedWriter));
            }
            catch (IOException iOException) {
                System.err.println("");
                System.err.println(LoggingUtilities.getResourceString("ERROR_UI_") + "  " + LoggingUtilities.getResourceString("SET_FILE_NAME_ERROR_", string2));
                System.err.println(LoggingUtilities.getResourceString("REASON_UI_") + " " + iOException);
                System.err.println(LoggingUtilities.getResourceString("RESULT_UI_") + " " + LoggingUtilities.getResourceString("LOG_TO_STDOUT_INFO_"));
                System.err.println("");
                return null;
            }
        }
        return bufferedWriter;
    }

    protected static synchronized void closeFileHandle(String string) {
        String string2 = new File(string).getAbsolutePath();
        if (fileHandles.containsKey(string2)) {
            SubstitutionVariable substitutionVariable = (SubstitutionVariable)fileHandles.get(string2);
            if (Integer.parseInt(substitutionVariable.getKey()) == 1) {
                try {
                    ((BufferedWriter)substitutionVariable.getVariable()).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                fileHandles.remove(string2);
            } else {
                substitutionVariable.setKey(String.valueOf(Integer.parseInt(substitutionVariable.getKey()) - 1));
            }
        }
    }

    public static synchronized String getThrowableStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "null";
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString().trim();
        }
        catch (Exception exception) {
            return throwable.toString();
        }
    }

    public static String getThreadStackTrace(Thread thread) {
        if (thread == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("Stack trace of ");
        stringBuffer.append(thread.toString());
        stringBuffer.append(Constants.LINESEPARATOR);
        String string = LoggingUtilities.getThrowableStackTrace(new Throwable());
        stringBuffer.append(string.substring(string.indexOf(Constants.LINESEPARATOR) + 2));
        return stringBuffer.toString();
    }

    public static String objectToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            String string = ", ";
            StringBuffer stringBuffer = new StringBuffer();
            if (object instanceof boolean[]) {
                int n = 0;
                while (n < ((boolean[])object).length) {
                    stringBuffer.append(string).append(((boolean[])object)[n]);
                    ++n;
                }
            } else if (object instanceof char[]) {
                int n = 0;
                while (n < ((char[])object).length) {
                    stringBuffer.append(string).append(((char[])object)[n]);
                    ++n;
                }
            } else if (object instanceof byte[]) {
                int n = 0;
                while (n < ((byte[])object).length) {
                    stringBuffer.append(string).append(((byte[])object)[n]);
                    ++n;
                }
            } else if (object instanceof short[]) {
                int n = 0;
                while (n < ((short[])object).length) {
                    stringBuffer.append(string).append(((short[])object)[n]);
                    ++n;
                }
            } else if (object instanceof int[]) {
                int n = 0;
                while (n < ((int[])object).length) {
                    stringBuffer.append(string).append(((int[])object)[n]);
                    ++n;
                }
            } else if (object instanceof long[]) {
                int n = 0;
                while (n < ((long[])object).length) {
                    stringBuffer.append(string).append(((long[])object)[n]);
                    ++n;
                }
            } else if (object instanceof float[]) {
                int n = 0;
                while (n < ((float[])object).length) {
                    stringBuffer.append(string).append(((float[])object)[n]);
                    ++n;
                }
            } else if (object instanceof double[]) {
                int n = 0;
                while (n < ((double[])object).length) {
                    stringBuffer.append(string).append(((double[])object)[n]);
                    ++n;
                }
            } else {
                int n = 0;
                while (n < ((Object[])object).length) {
                    stringBuffer.append(string).append(LoggingUtilities.objectToString(((Object[])object)[n]));
                    ++n;
                }
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.delete(0, string.length());
            }
            return "[" + stringBuffer.toString() + "]";
        }
        if (object instanceof Thread) {
            return LoggingUtilities.getThreadStackTrace((Thread)object);
        }
        if (object instanceof Throwable) {
            return LoggingUtilities.getThrowableStackTrace((Throwable)object);
        }
        return object.toString();
    }

    public static boolean isWorkbench() {
        try {
            LoggingUtilPlugin.getPlugin();
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public static boolean isValidLoggerName(String string) {
        return string != null && string.trim().length() != 0;
    }

    public static String currentTimeSeconds() {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingSize(0);
        return decimalFormat.format((double)System.currentTimeMillis() / 1000.0);
    }

    public static String getResourceString(String string) {
        if (resourceBundle == null) {
            try {
                resourceBundle = LoggingUtilPlugin.getResourceBundle();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle("com.ibm.etools.logging.util.properties.plugin");
                }
                catch (MissingResourceException missingResourceException) {
                    return string;
                }
            }
        }
        try {
            return resourceBundle.getString(string.trim()).trim();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getResourceString(String string, String string2) {
        return LoggingUtilities.getResourceString(string, new String[]{string2});
    }

    public static String getResourceString(String string, String string2, String string3) {
        return LoggingUtilities.getResourceString(string, new String[]{string2, string3});
    }

    public static String getResourceString(String string, String string2, String string3, String string4) {
        return LoggingUtilities.getResourceString(string, new String[]{string2, string3, string4});
    }

    public static String getResourceString(String string, String[] stringArray) {
        try {
            return MessageFormat.format(LoggingUtilities.getResourceString(string), stringArray);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getEnvironmentVariable(String string) {
        String string2 = "env";
        if (System.getProperties().getProperty("os.name").toLowerCase().startsWith("win")) {
            string2 = "cmd /C set";
        }
        try {
            String string3;
            Process process = Runtime.getRuntime().exec(string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                int n = string3.indexOf(61);
                if (n <= -1) continue;
                try {
                    String string4 = string3.substring(0, n).trim();
                    if (!string4.equals(string.trim())) continue;
                    return string3.substring(n + 1).trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Properties getEnvironmentVariables() {
        Properties properties = new Properties();
        String string = "env";
        if (System.getProperties().getProperty("os.name").toLowerCase().startsWith("win")) {
            string = "cmd /C set";
        }
        try {
            String string2;
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(61);
                if (n <= -1) continue;
                try {
                    String string3 = string2.substring(0, n).trim();
                    if (string3.length() <= 0) continue;
                    properties.setProperty(string3, string2.substring(n + 1).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }
}

