/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util.dcs;

import com.ibm.etools.logging.util.dcs.DCSCorrelator;
import com.ibm.etools.logging.util.dcs.MiddlewareRegistrationEntry;
import com.ibm.etools.logging.util.dcs.Parameter;
import com.ibm.etools.logging.util.dcs.ProviderCorrelator;
import com.ibm.etools.logging.util.dcs.ProviderRegistrationEntry;
import com.ibm.etools.logging.util.dcs.ProviderThreadCorrelator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.dgc.VMID;

public class Service {
    public static final String serviceCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static Service dcs = new Service();
    private ProviderRegistrationEntry[] registeredProvidersTable = null;
    private int _provider_stack_size = 0;
    private static final int _list_size = 16;
    private MiddlewareRegistrationEntry[] registeredMiddlewareTable = null;
    private int _middleware_stack_size = 0;
    private boolean started = false;
    private DCSCorrelator correlatorList = null;
    private ProviderCorrelator providerCorrelator;
    private long global_sequence_counter = 0L;
    private int start_counter = 0;
    private static final String jvm_id = new VMID().toString();
    static String _hostname = null;

    protected ProviderRegistrationEntry[] getRegisteredProvidersTable() {
        return this.registeredProvidersTable;
    }

    public synchronized int start() throws UnknownHostException {
        int n = 0;
        if (this.started) {
            ++this.start_counter;
            return 1;
        }
        this.started = true;
        this.start_counter = 1;
        this.correlatorList = new DCSCorrelator();
        this.registeredProvidersTable = new ProviderRegistrationEntry[16];
        this.registeredMiddlewareTable = new MiddlewareRegistrationEntry[16];
        return n;
    }

    public synchronized int stop() {
        int n = 0;
        if (!this.started) {
            return -1;
        }
        if (this.start_counter > 1) {
            --this.start_counter;
            return 0;
        }
        this.started = false;
        this.correlatorList = null;
        this.providerCorrelator = null;
        this.global_sequence_counter = 1L;
        if (this.registeredProvidersTable != null) {
            this.registeredProvidersTable = null;
            this._provider_stack_size = 0;
        }
        if (this.registeredMiddlewareTable != null) {
            this.registeredMiddlewareTable = null;
            this._middleware_stack_size = 0;
        }
        return n;
    }

    public synchronized int register(String string) {
        int n = 0;
        boolean bl = false;
        this.log("ProviderID=" + string);
        if (!this.started || this.registeredProvidersTable == null) {
            return -1;
        }
        int n2 = Thread.currentThread().hashCode();
        int n3 = 0;
        while (n3 < this._provider_stack_size) {
            if (this.registeredProvidersTable[n3].getProviderID().equals(string)) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (!bl) {
            ProviderRegistrationEntry providerRegistrationEntry = new ProviderRegistrationEntry(string, n2);
            if (this._provider_stack_size < this.registeredProvidersTable.length) {
                this.registeredProvidersTable[this._provider_stack_size] = providerRegistrationEntry;
                ++this._provider_stack_size;
            } else {
                ProviderRegistrationEntry[] providerRegistrationEntryArray = new ProviderRegistrationEntry[2 * this._provider_stack_size];
                System.arraycopy(this.registeredProvidersTable, 0, providerRegistrationEntryArray, 0, this._provider_stack_size);
                this.registeredProvidersTable = providerRegistrationEntryArray;
                this.registeredProvidersTable[this._provider_stack_size] = providerRegistrationEntry;
                ++this._provider_stack_size;
            }
        } else if (!this.registeredProvidersTable[n3].getProviderThreadEntry(n2)) {
            this.registeredProvidersTable[n3].addProviderThreadEntry(n2);
        } else {
            n = 2;
        }
        return n;
    }

    public synchronized int unregister(String string) {
        int n = -3;
        if (!this.started || this.registeredProvidersTable == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < this._provider_stack_size) {
            if (this.registeredProvidersTable[n2].getProviderID().equals(string)) {
                this.registeredProvidersTable[n2] = null;
                int n3 = n2 + 1;
                while (n3 < this._provider_stack_size) {
                    this.registeredProvidersTable[n3 - 1] = this.registeredProvidersTable[n3];
                    this.registeredProvidersTable[n3] = null;
                    ++n3;
                }
                --this._provider_stack_size;
                n = 0;
                break;
            }
            ++n2;
        }
        if (n == 0 && this._provider_stack_size == 0 && this._middleware_stack_size == 0) {
            this.stop();
        }
        return n;
    }

    public synchronized DCSCorrelator pullCorrelator(String string, long l) {
        boolean bl = false;
        long l2 = 0L;
        int n = 0;
        if (!this.started) {
            return null;
        }
        if (this.registeredProvidersTable != null) {
            n = this._provider_stack_size - 1;
            while (n >= 0) {
                if (this.registeredProvidersTable[n].getProviderID().equals(string) && this.registeredProvidersTable[n].getProviderThreadEntry(l)) {
                    bl = true;
                    break;
                }
                --n;
            }
        }
        if (!bl || this.correlatorList == null) {
            return null;
        }
        DCSCorrelator dCSCorrelator = this.correlatorList.pullCorrelator(n, string, l);
        return dCSCorrelator;
    }

    public synchronized int pushCorrelator(String string, long l, DCSCorrelator dCSCorrelator) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (!this.started) {
            n = -1;
            return n;
        }
        if (this.registeredProvidersTable != null) {
            n2 = this._provider_stack_size - 1;
            while (n2 >= 0) {
                if (this.registeredProvidersTable[n2].getProviderID().equals(string)) {
                    bl2 = true;
                    n3 = n2;
                    if (this.registeredProvidersTable[n2].getProviderThreadEntry(l)) {
                        bl = true;
                        break;
                    }
                }
                --n2;
            }
        }
        if (bl && !this.registeredProvidersTable[n2].getProviderThreadEntryState(l)) {
            if (dCSCorrelator.getProviderThreadCorrelatorList().getProviderThreadCorrelatorList().length != 0) {
                dCSCorrelator.getProviderThreadCorrelatorList(0).getProviderCorrelator().getProviderCorrelatorCommonData().set_partner_correlator_data(null);
                this.correlatorList.pushCorrelator(l, dCSCorrelator);
            }
        } else if (bl2 && !bl) {
            this.registeredProvidersTable[n3].addProviderThreadEntry(l);
            dCSCorrelator.getProviderThreadCorrelatorList(0).getProviderCorrelator().getProviderCorrelatorCommonData().set_partner_correlator_data(null);
            this.correlatorList.pushCorrelator(l, dCSCorrelator);
        } else {
            n = !bl ? -3 : 2;
        }
        return n;
    }

    public synchronized int removeAllCorrelator(String string) {
        int n = 0;
        boolean bl = false;
        if (!this.started) {
            return -1;
        }
        if (this.registeredProvidersTable != null) {
            int n2 = 0;
            while (n2 < this._provider_stack_size) {
                if (this.registeredProvidersTable[n2].getProviderID().equals(string)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        if (bl) {
            this.correlatorList.getProviderThreadCorrelatorList().removeAllCorrelator(string);
        } else {
            n = -3;
        }
        return n;
    }

    public synchronized int suspendCorrelator(String string, long l) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (!this.started) {
            return -1;
        }
        if (this.registeredProvidersTable != null) {
            n2 = this._provider_stack_size - 1;
            while (n2 >= 0) {
                if (this.registeredProvidersTable[n2].getProviderID().equals(string) && this.registeredProvidersTable[n2].getProviderThreadEntry(l)) {
                    bl = true;
                    break;
                }
                --n2;
            }
        }
        n = bl ? this.registeredProvidersTable[n2].setProviderThreadEntryState(l, true) : -3;
        return n;
    }

    public synchronized int resumeCorrelator(String string, long l) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (!this.started) {
            return -1;
        }
        if (this.registeredProvidersTable != null) {
            n2 = this._provider_stack_size - 1;
            while (n2 >= 0) {
                if (this.registeredProvidersTable[n2].getProviderID().equals(string) && this.registeredProvidersTable[n2].getProviderThreadEntry(l)) {
                    bl = true;
                    break;
                }
                --n2;
            }
        }
        n = bl ? this.registeredProvidersTable[n2].setProviderThreadEntryState(l, false) : -3;
        return n;
    }

    public synchronized int setPartnerDataStream(String string, long l, DCSCorrelator dCSCorrelator) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (!this.started) {
            return -1;
        }
        if (this.registeredMiddlewareTable != null) {
            n2 = 0;
            while (n2 < this._middleware_stack_size) {
                if (this.registeredMiddlewareTable[n2].getInstanceID().equals(string)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        try {
            if (bl && dCSCorrelator != null) {
                if (dCSCorrelator.getProviderThreadCorrelatorList().getProviderThreadCorrelatorList().length == 0 || dCSCorrelator.getProviderThreadCorrelatorList(0).getProviderCorrelatorList().length == 0) {
                    n = 4;
                } else {
                    ProviderThreadCorrelator providerThreadCorrelator = dCSCorrelator.getProviderThreadCorrelatorList(0);
                    int n4 = providerThreadCorrelator.get_stack_size() - 1;
                    while (n4 >= 0) {
                        bl = false;
                        bl2 = false;
                        if (this.registeredProvidersTable != null) {
                            n2 = this._provider_stack_size - 1;
                            while (n2 >= 0) {
                                if (this.registeredProvidersTable[n2].getProviderID().equals(providerThreadCorrelator.getProviderCorrelator(n4).getProviderID())) {
                                    bl2 = true;
                                    n3 = n2;
                                    if (this.registeredProvidersTable[n2].getProviderThreadEntry(l)) {
                                        bl = true;
                                        break;
                                    }
                                }
                                --n2;
                            }
                        }
                        if (bl2) {
                            if (!bl) {
                                this.registeredProvidersTable[n3].addProviderThreadEntry(l);
                            }
                            n = this.correlatorList.getProviderThreadCorrelatorList().updatePartnerCorrelator(providerThreadCorrelator.getProviderCorrelator(n4).getProviderID(), l, n4, dCSCorrelator);
                        }
                        --n4;
                    }
                }
            } else {
                n = dCSCorrelator == null ? 4 : -3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public synchronized DCSCorrelator getDataStream(String string, long l, Parameter[] parameterArray) {
        boolean bl = false;
        int n = 0;
        if (!this.started) {
            return null;
        }
        if (this.registeredMiddlewareTable != null) {
            n = this._middleware_stack_size - 1;
            while (n >= 0) {
                if (this.registeredMiddlewareTable[n].getInstanceID().equals(string)) {
                    bl = true;
                    break;
                }
                --n;
            }
        }
        if (!bl) {
            return null;
        }
        DCSCorrelator dCSCorrelator = this.correlatorList.getProviderThreadCorrelatorList().getAllCorrelator(l, this.registeredProvidersTable, parameterArray);
        return dCSCorrelator;
    }

    public synchronized int registerMiddleware(String string, String string2) {
        int n = 0;
        boolean bl = false;
        this.log("registerMiddleware1 - entry - I=" + string + " M=" + string2);
        if (!this.started) {
            this.log("Not started");
            return -1;
        }
        try {
            this.log("Checking registeredMiddlewareTable");
            if (this.registeredMiddlewareTable != null) {
                this.log("registerMiddlewareTable not NULL");
                int n2 = 0;
                while (n2 < this._middleware_stack_size) {
                    this.log("Index=" + n2);
                    if (this.registeredMiddlewareTable[n2].getInstanceID().equals(string)) {
                        this.log("Found!");
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl) {
                this.log("Adding element in the middleware table");
                MiddlewareRegistrationEntry middlewareRegistrationEntry = new MiddlewareRegistrationEntry(string, string2);
                if (this._middleware_stack_size < this.registeredMiddlewareTable.length) {
                    this.registeredMiddlewareTable[this._middleware_stack_size] = middlewareRegistrationEntry;
                    ++this._middleware_stack_size;
                } else {
                    MiddlewareRegistrationEntry[] middlewareRegistrationEntryArray = new MiddlewareRegistrationEntry[2 * this._provider_stack_size];
                    System.arraycopy(this.registeredMiddlewareTable, 0, middlewareRegistrationEntryArray, 0, this._middleware_stack_size);
                    this.registeredMiddlewareTable = middlewareRegistrationEntryArray;
                    this.registeredMiddlewareTable[this._middleware_stack_size] = middlewareRegistrationEntry;
                    ++this._middleware_stack_size;
                }
            } else {
                this.log("Already registered");
                n = 1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log(exception.getMessage());
        }
        this.log("registerMiddleware - Exit rc=" + n);
        return n;
    }

    public synchronized int unregisterMiddleware(String string) {
        int n = 0;
        boolean bl = false;
        if (!this.started) {
            return -1;
        }
        if (this.registeredMiddlewareTable != null) {
            int n2 = 0;
            while (n2 < this._middleware_stack_size) {
                if (this.registeredMiddlewareTable[n2].getInstanceID().equals(string)) {
                    this.registeredMiddlewareTable[n2] = null;
                    int n3 = n2 + 1;
                    while (n3 < this._middleware_stack_size) {
                        this.registeredMiddlewareTable[n3 - 1] = this.registeredMiddlewareTable[n3];
                        this.registeredMiddlewareTable[n3] = null;
                        ++n3;
                    }
                    --this._middleware_stack_size;
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        if (!bl) {
            n = -3;
        }
        if (bl && this._middleware_stack_size == 0 && this._provider_stack_size == 0) {
            this.stop();
        }
        return n;
    }

    public long increment_global_sequence_counter() {
        return ++this.global_sequence_counter;
    }

    public String get_jvmID() {
        return jvm_id;
    }

    protected DCSCorrelator getCorrelatorList() {
        return this.correlatorList;
    }

    protected int get_provider_stack_size() {
        return this._provider_stack_size;
    }

    protected int get_middleware_stack_size() {
        return this._middleware_stack_size;
    }

    protected String get_hostname() {
        return _hostname;
    }

    public void log(String string) {
    }

    static {
        try {
            _hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            _hostname = "localhost";
        }
    }
}

