/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xslt4j.b2b2dtm;

import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import com.ibm.xml.b2b.util.DataStore;
import com.ibm.xml.b2b.util.IntegerHashtable;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.SymbolTable;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.XMLStringBuffer;
import com.ibm.xml.b2b.util.entity.EntityDeclPool;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;

final class DTDGrammar {
    public static final int ATTDEF_ATTRNAME_OFFSET = 0;
    public static final int ATTDEF_ATTTYPE_OFFSET = 1;
    public static final int ATTDEF_DEFAULTTYPE_OFFSET = 2;
    public static final int ATTDEF_ENUMTYPE_OFFSET = 3;
    public static final int ATTDEF_ATTVALUE_OFFSET = 4;
    public static final int ATTDEF_EXTERNAL_OFFSET = 5;
    public static final int ATTDEF_RECORD_SIZE = 6;
    protected SymbolTable fSymbolTable;
    protected XMLStringBuffer fStringBuffer;
    protected DataStore fDataStore;
    protected EntityDeclPool fEntityDeclPool;
    protected int fRootElementTypeHandle;
    protected int fPublicIDHandle;
    protected int fSystemIDHandle;
    protected int fEnumerationTypeList;
    protected QName[] fDefaultAttrNames;
    protected int fDefaultAttrNamesCount;
    protected XMLString[] fDefaultAttValues;
    protected int fDefaultAttValuesCount;
    protected int fCDATASymbol;
    protected int fREQUIREDSymbol;
    protected int fFIXEDSymbol;
    protected boolean fHaveAttDefs;
    protected IntegerHashtable fAttDefs;
    protected boolean fHaveElementContentElements;
    protected IntegerHashtable fElementContentElements;

    public DTDGrammar(SymbolTable symbolTable, ParsedEntityFactory entityFactory) {
        this.fSymbolTable = symbolTable;
        this.fEntityDeclPool = new EntityDeclPool(this.fSymbolTable);
        this.fStringBuffer = entityFactory.createStringBuffer();
        this.fDataStore = new DataStore();
        this.fDefaultAttrNames = new QName[16];
        this.fDefaultAttValues = new XMLString[16];
        this.fCDATASymbol = this.fSymbolTable.addSymbol("CDATA");
        this.fFIXEDSymbol = this.fSymbolTable.addSymbol("#FIXED");
        this.fREQUIREDSymbol = this.fSymbolTable.addSymbol("#REQUIRED");
    }

    public void reset(boolean retainObjects) {
        this.fEntityDeclPool.reset(retainObjects);
        this.fStringBuffer.reset(retainObjects);
        this.fDataStore.reset(retainObjects);
        if (this.fHaveElementContentElements) {
            this.fElementContentElements.clear(retainObjects);
            this.fHaveElementContentElements = false;
            if (!retainObjects) {
                this.fElementContentElements = null;
            }
        }
        if (this.fHaveAttDefs) {
            this.fAttDefs.clear(retainObjects);
            this.fHaveAttDefs = false;
            if (!retainObjects) {
                int i = 0;
                while (i < this.fDefaultAttrNamesCount) {
                    this.fDefaultAttrNames[i] = null;
                    ++i;
                }
                i = 0;
                while (i < this.fDefaultAttValuesCount) {
                    this.fDefaultAttValues[i] = null;
                    ++i;
                }
            }
            this.fDefaultAttrNamesCount = 0;
            this.fDefaultAttValuesCount = 0;
        }
        this.fCDATASymbol = this.fSymbolTable.addSymbol("CDATA");
        this.fFIXEDSymbol = this.fSymbolTable.addSymbol("#FIXED");
        this.fREQUIREDSymbol = this.fSymbolTable.addSymbol("#REQUIRED");
    }

    public EntityDeclPool getEntityDeclPool() {
        return this.fEntityDeclPool;
    }

    public XMLStringBuffer getStringBuffer() {
        return this.fStringBuffer;
    }

    public void setDescription(QName rootElementType, int publicID, int systemID) {
        if (rootElementType != null) {
            this.fRootElementTypeHandle = this.fSymbolTable.addSymbol(rootElementType);
        }
        this.fPublicIDHandle = publicID;
        this.fSystemIDHandle = systemID;
    }

    public boolean hasElementContentElements() {
        return this.fHaveElementContentElements;
    }

    public boolean hasElementContent(int elementTypeHandle) {
        return this.fElementContentElements.get(elementTypeHandle) != -1;
    }

    public void setElementContentElement(int elementTypeHandle) {
        if (this.fElementContentElements == null) {
            this.fElementContentElements = new IntegerHashtable();
        }
        this.fElementContentElements.put(elementTypeHandle, 1);
        this.fHaveElementContentElements = true;
    }

    public boolean hasAttDefs() {
        return this.fHaveAttDefs;
    }

    public void addDefaultAttributes(DocumentScannerSupport support, int elementTypeHandle) {
        int attDefs = this.getAttDefs(elementTypeHandle);
        if (attDefs == -1) {
            return;
        }
        int count = this.attDefsCount(attDefs);
        int[] defs = this.attDefsArray(attDefs);
        int defbase = this.attDefsBase(attDefs);
        String nsDeclPrefix = support.nsDeclPrefix;
        int attrCount = support.attrCount;
        int i = 0;
        while (i < count) {
            boolean required;
            int attDef = defs[defbase + i];
            int[] record = this.attDefArray(attDef);
            int base = this.attDefBase(attDef);
            int attrNameHandle = record[base + 0];
            QName attrName = this.defaultAttrName(attrNameHandle);
            boolean isNSDecl = attrName.localPart == nsDeclPrefix || attrName.prefix == nsDeclPrefix;
            int attType = record[base + 1];
            int attDefType = record[base + 2];
            int attValueHandle = record[base + 4];
            XMLString attValue = this.defaultAttValue(attValueHandle);
            boolean found = false;
            boolean bl = required = attDefType == this.fREQUIREDSymbol;
            if (required || attType != this.fCDATASymbol || attValueHandle != -1) {
                int j;
                if (isNSDecl) {
                    int firstMapping = support.firstMapping;
                    int lastMapping = support.lastMapping;
                    j = firstMapping;
                    while (j < lastMapping) {
                        String nsDeclQName = support.nsDeclQNames[j];
                        if (attrName.str == nsDeclQName) {
                            if (attDefType == this.fFIXEDSymbol) {
                                String specValue = support.namespaceURIs[j];
                                XMLString defValue = attValue;
                                this.checkFixedAttValue(attrName, specValue, defValue.toString());
                            }
                            found = true;
                            break;
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < attrCount) {
                        if (attrName.handle == support.attrNames[j].handle) {
                            if (attDefType == this.fFIXEDSymbol) {
                                XMLString specValue = support.attValues[j];
                                XMLString defValue = attValue;
                                this.checkFixedAttValue(attrName, specValue.toString(), defValue.toString());
                            }
                            if (attType != this.fCDATASymbol) {
                                support.attValueNormalized[j] = false;
                                support.attTypes[j] = this.fSymbolTable.toString(attType);
                            }
                            found = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!found) {
                    if (required) {
                        this.requiredAttributeNotSpecified(attrName);
                    }
                    if (attValueHandle != -1) {
                        this.addDefaultAttribute(support, attrName, this.fSymbolTable.toString(attType), attValue, attDef);
                    }
                }
            }
            ++i;
        }
    }

    protected void checkFixedAttValue(QName attrName, String specValue, String defValue) {
    }

    protected void requiredAttributeNotSpecified(QName attrName) {
    }

    protected void addDefaultAttribute(DocumentScannerSupport support, QName attrName, String attType, XMLString attValue, int attDef) {
        support.addDefaultAttribute(attrName, attType, attValue);
    }

    public int getAttDefs(int elementTypeHandle) {
        return this.fHaveAttDefs ? this.fAttDefs.get(elementTypeHandle) : -1;
    }

    public int attDefsCount(int attDefs) {
        return this.fDataStore.getListCount(attDefs);
    }

    public int[] attDefsArray(int attDefs) {
        return this.fDataStore.getListArray(attDefs);
    }

    public int attDefsBase(int attDefs) {
        return this.fDataStore.getListBase(attDefs);
    }

    public int[] attDefArray(int attDef) {
        return this.fDataStore.getRecordArray(attDef);
    }

    public int attDefBase(int attDef) {
        return this.fDataStore.getRecordBase(attDef);
    }

    public QName attDefAttrName(int attDef) {
        int[] record = this.attDefArray(attDef);
        int base = this.attDefBase(attDef);
        int attrNameHandle = record[base + 0];
        QName attrName = this.defaultAttrName(attrNameHandle);
        return attrName;
    }

    public XMLString attDefAttValue(int attDef) {
        int[] record = this.attDefArray(attDef);
        int base = this.attDefBase(attDef);
        int attValueHandle = record[base + 4];
        XMLString attValue = this.defaultAttValue(attValueHandle);
        return attValue;
    }

    public boolean attDefIsExternal(int attDef) {
        int base;
        int[] record = this.fDataStore.getRecordArray(attDef);
        return record[(base = this.fDataStore.getRecordBase(attDef)) + 5] != 0;
    }

    private QName defaultAttrName(int handle) {
        return this.fDefaultAttrNames[handle];
    }

    private XMLString defaultAttValue(int handle) {
        return handle != -1 ? this.fDefaultAttValues[handle] : null;
    }

    public int lookupAttDef(QName elementType, QName attrName) {
        int elem;
        int attDefs;
        if (this.fHaveAttDefs && (attDefs = this.fAttDefs.get(elem = this.fSymbolTable.addSymbol(elementType))) != -1) {
            int count = this.fDataStore.getListCount(attDefs);
            int[] defs = this.fDataStore.getListArray(attDefs);
            int base = this.fDataStore.getListBase(attDefs);
            int attr = this.fSymbolTable.addSymbol(attrName);
            int i = 0;
            while (i < count) {
                int def = defs[base + i];
                int[] record = this.fDataStore.getRecordArray(def);
                int recordBase = this.fDataStore.getRecordBase(def);
                int defAttrName = record[recordBase + 0];
                if (attr == this.fDefaultAttrNames[defAttrName].handle) {
                    return def;
                }
                ++i;
            }
        }
        return -1;
    }

    public void startAttDef(QName attrName, XMLString attType) {
        this.fEnumerationTypeList = -1;
    }

    public void enumerationType(XMLString type) {
        this.fEnumerationTypeList = this.fDataStore.addToList(this.fEnumerationTypeList, this.fSymbolTable.addSymbol(type));
    }

    public void saveAttDef(QName elementType, QName attrName, XMLString attType, XMLString defaultType, XMLString attValue, boolean declaredExternally) {
        int attDefs;
        int elem = this.fSymbolTable.addSymbol(elementType);
        int attr = this.fSymbolTable.addSymbol(attrName);
        int n = attDefs = this.fHaveAttDefs ? this.fAttDefs.get(elem) : -1;
        if (attrName.prefix == null) {
            if (attrName.sepOffset == -1) {
                attrName.prefix = XMLString.EMPTY_STRING;
                attrName.localPart = this.fSymbolTable.toString(attr);
            } else {
                this.fSymbolTable.addQNameSymbols(attrName);
            }
        }
        int attDef = this.fDataStore.allocateRecord(6);
        int[] defChunk = this.fDataStore.getRecordArray(attDef);
        int base = this.fDataStore.getRecordBase(attDef);
        if ((attr = this.fDefaultAttrNamesCount++) == this.fDefaultAttrNames.length) {
            QName[] newDefaultAttrNames = new QName[attr << 1];
            System.arraycopy(this.fDefaultAttrNames, 0, newDefaultAttrNames, 0, attr);
            this.fDefaultAttrNames = newDefaultAttrNames;
            this.fDefaultAttrNames[attr] = new QName(attrName);
        } else if (this.fDefaultAttrNames[attr] == null) {
            this.fDefaultAttrNames[attr] = new QName(attrName);
        } else {
            this.fDefaultAttrNames[attr].setValues(attrName);
        }
        defChunk[base + 0] = attr;
        int at = attType != null ? this.fSymbolTable.addSymbol(attType) : -1;
        int dt = defaultType != null ? this.fSymbolTable.addSymbol(defaultType) : -1;
        defChunk[base + 1] = at;
        defChunk[base + 2] = dt;
        defChunk[base + 3] = this.fEnumerationTypeList;
        if (attValue != null) {
            if (at != this.fCDATASymbol) {
                this.normalizeDefaultAttValue(attrName, attValue, at, attDef);
            }
            if (this.fDefaultAttValuesCount == this.fDefaultAttValues.length) {
                XMLString[] newDefaultAttValues = new XMLString[this.fDefaultAttValuesCount << 1];
                System.arraycopy(this.fDefaultAttValues, 0, newDefaultAttValues, 0, this.fDefaultAttValuesCount);
                this.fDefaultAttValues = newDefaultAttValues;
                this.fDefaultAttValues[this.fDefaultAttValuesCount] = new XMLString(attValue);
            } else if (this.fDefaultAttValues[this.fDefaultAttValuesCount] == null) {
                this.fDefaultAttValues[this.fDefaultAttValuesCount] = new XMLString(attValue);
            } else {
                this.fDefaultAttValues[this.fDefaultAttValuesCount].setValues(attValue);
            }
            defChunk[base + 4] = attr = this.fDefaultAttValuesCount++;
        } else {
            defChunk[base + 4] = -1;
        }
        int n2 = defChunk[base + 5] = declaredExternally ? 1 : 0;
        if (attDefs == -1) {
            attDefs = this.fDataStore.addToList(-1, attDef);
            if (this.fAttDefs == null) {
                this.fAttDefs = new IntegerHashtable();
            }
            this.fAttDefs.put(elem, attDefs);
            this.fHaveAttDefs = true;
        } else {
            this.fDataStore.addToList(attDefs, attDef);
        }
    }

    protected void normalizeDefaultAttValue(QName attrName, XMLString attValue, int attType, int attDef) {
        this.fStringBuffer.normalizeTextValue(attValue, null);
    }
}

