/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.AbstractTreeNode;
import com.ibm.ObjectQuery.crud.util.DoToRootMinusOneTreeIterator;
import com.ibm.ObjectQuery.crud.util.DoToRootTreeIterator;
import com.ibm.ObjectQuery.crud.util.DoubleLinkTreelike;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDoubleLinkTreeNode
extends AbstractTreeNode
implements DoubleLinkTreelike {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public void addChild(AbstractDoubleLinkTreeNode aNode) {
        this.basicAddChild(aNode);
    }

    public List ancestors() {
        if (!this.hasParent()) {
            return new ArrayList();
        }
        DoToRootTreeIterator it = new DoToRootTreeIterator(this.parent());
        return this.collectIntoList(it);
    }

    public void basicAddChild(AbstractDoubleLinkTreeNode aNode) {
        aNode.removeFromParent();
        this.children().add(aNode);
        aNode.parent(this);
    }

    public int depth() {
        int i = 0;
        DoubleLinkTreelike aNode = this;
        while (aNode != null) {
            aNode = aNode.parent();
            ++i;
        }
        return i - 1;
    }

    public boolean hasParent() {
        return this.parent() != null;
    }

    public boolean isRoot() {
        return this.parent() == null;
    }

    public int level() {
        if (this.parent() == null) {
            return 1;
        }
        return ((AbstractDoubleLinkTreeNode)this.parent()).level() + 1;
    }

    public int[] levelId() {
        List aList = this.withAncestors();
        if (this.ancestors().size() == 0) {
            int[] anArray = new int[]{this.localLevelId()};
            return anArray;
        }
        int i = aList.size();
        int[] anArray = new int[i--];
        --i;
        int j = 1;
        while (j < aList.size()) {
            anArray[i--] = ((AbstractDoubleLinkTreeNode)aList.get(j)).localLevelId();
            ++j;
        }
        return anArray;
    }

    public int localLevelId() {
        DoubleLinkTreelike aParent = this.parent();
        if (aParent == null) {
            return 0;
        }
        return aParent.children().indexOf(this);
    }

    public abstract DoubleLinkTreelike parent();

    public abstract void parent(DoubleLinkTreelike var1);

    public void printDetailOn(StringBuffer aBuffer) {
        int[] anArray = this.levelId();
        int i = 0;
        while (i < anArray.length) {
            aBuffer.append(anArray[i]);
            if (i != anArray.length - 1) {
                aBuffer.append(" ");
            }
            ++i;
        }
    }

    public void printPrefixOn(StringBuffer aBuffer) {
        int max = this.depth() - 1;
        int i = 0;
        while (i < max) {
            aBuffer.append(this.nestingIndicator());
            ++i;
        }
    }

    public DoubleLinkTreelike removeChild(DoubleLinkTreelike aNode) {
        super.removeChild(aNode);
        aNode.parent(null);
        return aNode;
    }

    public void removeFromParent() {
        if (this.parent() == null) {
            return;
        }
        this.parent().children().remove(this);
        this.parent(null);
    }

    public DoubleLinkTreelike root() {
        if (this.parent() == null) {
            return this;
        }
        return this.parent().root();
    }

    public Iterator toRootIterator() {
        return new DoToRootTreeIterator(this);
    }

    public Iterator toRootMinusOneIterator() {
        return new DoToRootMinusOneTreeIterator(this);
    }

    public List withAncestors() {
        ArrayList aList = new ArrayList();
        DoToRootTreeIterator it = new DoToRootTreeIterator(this);
        return this.collectIntoList(it);
    }
}

