/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.BooleanFunction;
import com.ibm.ObjectQuery.crud.util.BreadthFirstTreeIterator;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.Function;
import com.ibm.ObjectQuery.crud.util.PostOrderTreeIterator;
import com.ibm.ObjectQuery.crud.util.PreOrderTreeIterator;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.TreeNode;
import com.ibm.ObjectQuery.crud.util.Treelike;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class AbstractTreeNode
implements Treelike,
Serializable,
Cloneable {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public void addChild(Treelike aNode) {
        this.basicAddChild(aNode);
    }

    public String asFullTreeString() {
        StringBuffer aBuffer = new StringBuffer();
        this.printFullTreeOn(aBuffer);
        return aBuffer.toString();
    }

    public List asList() {
        return this.collectIntoList(this.iterator());
    }

    public String asTreeString() {
        StringBuffer aBuffer = new StringBuffer();
        this.printTreeOn(aBuffer);
        return aBuffer.toString();
    }

    public Vector asVector() {
        return this.collectIntoVector(this.iterator());
    }

    public void basicAddChild(Treelike aNode) {
        this.children().add(aNode);
    }

    public void basicAddChildren(Vector aVector) {
        Enumeration e = aVector.elements();
        while (e.hasMoreElements()) {
            this.basicAddChild((TreeNode)e.nextElement());
        }
    }

    public Iterator breadthFirstIterator() {
        return new BreadthFirstTreeIterator(this);
    }

    public abstract List children();

    public abstract void children(List var1);

    public Iterator childrenIterator() {
        return this.children().iterator();
    }

    public List collect(Function aFunction) {
        ArrayList<Object> aList = new ArrayList<Object>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            aList.add(aFunction.value(it.next()));
        }
        return aList;
    }

    public List collectInto(Iterator e, List aList) {
        while (e.hasNext()) {
            aList.add(e.next());
        }
        return aList;
    }

    public List collectIntoList(Iterator it) {
        return this.collectInto(it, new ArrayList());
    }

    public Vector collectIntoVector(Iterator it) {
        Vector aVector = new Vector();
        while (it.hasNext()) {
            aVector.addElement(it.next());
        }
        return aVector;
    }

    public boolean conform(BooleanFunction aFunction) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (aFunction.value(it.next())) continue;
            return false;
        }
        return true;
    }

    public List decendants() {
        Iterator it = this.iterator();
        ArrayList<TreeNode> aList = new ArrayList<TreeNode>();
        while (it.hasNext()) {
            TreeNode each = (TreeNode)it.next();
            if (each == this) continue;
            aList.add(each);
        }
        return aList;
    }

    private String getNewLine() {
        return System.getProperties().getProperty("line.separator");
    }

    public boolean hasChildren() {
        return !this.children().isEmpty();
    }

    public boolean isBranch() {
        if (this.isLeaf()) {
            return false;
        }
        return this.children().size() > 1;
    }

    public boolean isCyclicReference(TreeNode aNode) {
        if (this == aNode) {
            return true;
        }
        Iterator it = this.children().iterator();
        while (it.hasNext()) {
            TreeNode each = (TreeNode)it.next();
            if (each == aNode) {
                return true;
            }
            if (!each.isCyclicReference(aNode)) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaf() {
        return !this.hasChildren();
    }

    public Iterator iterator() {
        return this.preOrderIterator();
    }

    public int leafCount() {
        if (this.isLeaf()) {
            return 1;
        }
        int i = 0;
        Iterator it = this.childrenIterator();
        while (it.hasNext()) {
            i += ((AbstractTreeNode)it.next()).leafCount();
        }
        return i;
    }

    public List leaves() {
        Iterator it = this.iterator();
        ArrayList<AbstractTreeNode> aList = new ArrayList<AbstractTreeNode>();
        while (it.hasNext()) {
            AbstractTreeNode aNode = (AbstractTreeNode)it.next();
            if (!aNode.isLeaf()) continue;
            aList.add(aNode);
        }
        return aList;
    }

    public int maxPrint() {
        return 1000;
    }

    public char nestingIndicator() {
        return '.';
    }

    public Iterator postOrderIterator() {
        return new PostOrderTreeIterator(this);
    }

    public Iterator preOrderIterator() {
        return new PreOrderTreeIterator(this);
    }

    public void printChildrenOn(StringBuffer aBuffer) {
        Iterator it = this.childrenIterator();
        while (it.hasNext()) {
            if (aBuffer.length() > this.maxPrint()) {
                this.printEtcOn(aBuffer);
                return;
            }
            aBuffer.append(this.getNewLine());
            AbstractTreeNode aNode = (AbstractTreeNode)it.next();
            aNode.printTreeOn(aBuffer);
            aBuffer.append(" ");
        }
    }

    public void printDetailOn(StringBuffer aBuffer) {
    }

    public void printEtcOn(StringBuffer aBuffer) {
        aBuffer.append("...etc...");
    }

    public void printFullTreeOn(StringBuffer aBuffer) {
        this.printFullTreeOn(aBuffer, new StSet());
    }

    public void printFullTreeOn(StringBuffer aBuffer, StSet aSet) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            this.printTreeNodeOn((AbstractTreeNode)it.next(), aBuffer, aSet);
        }
    }

    public void printOn(StringBuffer aBuffer) {
        aBuffer.append(ClassShortName.name(this));
        aBuffer.append("(");
        this.printDetailOn(aBuffer);
        aBuffer.append(")");
    }

    public void printPartialTreeOn(StringBuffer aBuffer) {
        this.printPartialTreeOn(aBuffer, new StSet());
    }

    public void printPartialTreeOn(StringBuffer aBuffer, StSet aSet) {
        int max = aBuffer.length() + this.maxPrint();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (aBuffer.length() > max) {
                this.printEtcOn(aBuffer);
                return;
            }
            this.printTreeNodeOn((AbstractTreeNode)it.next(), aBuffer, aSet);
        }
    }

    public void printPrefixOn(StringBuffer aBuffer) {
    }

    public void printRecursionMessageOn(StringBuffer aBuffer) {
        aBuffer.append("... recursive reference to ");
        aBuffer.append(ClassShortName.name(this));
        aBuffer.append(" ...");
    }

    public void printSuffixOn(StringBuffer aBuffer) {
    }

    public void printTreeNodeOn(AbstractTreeNode aNode, StringBuffer aBuffer, StSet aSet) {
        if (this.recursiveAccessCheck(aSet)) {
            this.printRecursionMessageOn(aBuffer);
            return;
        }
        aBuffer.append(this.getNewLine());
        aNode.printPrefixOn(aBuffer);
        aNode.printOn(aBuffer);
        aNode.printSuffixOn(aBuffer);
        this.recursiveAccessClear(aSet);
    }

    public void printTreeNodeOn(TreeNode aNode, StringBuffer aBuffer, StSet aSet) {
        if (this.recursiveAccessCheck(aSet)) {
            this.printRecursionMessageOn(aBuffer);
            return;
        }
        aBuffer.append(this.getNewLine());
        aNode.printPrefixOn(aBuffer);
        aNode.printOn(aBuffer);
        aNode.printSuffixOn(aBuffer);
        this.recursiveAccessClear(aSet);
    }

    public void printTreeOn(StringBuffer aBuffer) {
        this.printTreeOn(aBuffer, new StSet());
    }

    public void printTreeOn(StringBuffer aBuffer, StSet aSet) {
        if (this.recursiveAccessCheck(aSet)) {
            this.printRecursionMessageOn(aBuffer);
            return;
        }
        this.printPrefixOn(aBuffer);
        this.printOn(aBuffer);
        this.printChildrenOn(aBuffer);
        this.printSuffixOn(aBuffer);
        this.recursiveAccessClear(aSet);
    }

    public boolean recursiveAccessCheck(StSet aSet) {
        return aSet.includes(this);
    }

    public AbstractTreeNode recursiveAccessClear(StSet aSet) {
        aSet.remove(this);
        return this;
    }

    public Treelike removeChild(Treelike aNode) {
        this.children().remove(aNode);
        return aNode;
    }

    public List select(BooleanFunction aFunction) {
        ArrayList aList = new ArrayList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object each = it.next();
            if (!aFunction.value(each)) continue;
            aList.add(each);
        }
        return aList;
    }

    public int size() {
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ++i;
            it.next();
        }
        return i;
    }

    public synchronized String toString() {
        StringBuffer aBuffer = new StringBuffer();
        this.printOn(aBuffer);
        return aBuffer.toString();
    }
}

