/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.AccumulatingFunction;
import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.BooleanFunction;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.Function;
import com.ibm.ObjectQuery.crud.util.MultiIterator;
import com.ibm.ObjectQuery.crud.util.ObjectCollectionWrapper;
import com.ibm.ObjectQuery.crud.util.PairwiseIterator;
import com.ibm.ObjectQuery.crud.util.ReverseArrayEnumerator;
import com.ibm.ObjectQuery.crud.util.ShouldNotImplement;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.TwoValuedFunction;
import com.ibm.ObjectQuery.crud.util.TwoValuedIntFunction;
import com.ibm.ObjectQuery.crud.util.UnderConstruction;
import com.ibm.ObjectQuery.crud.util.VoidFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class Array
extends ObjectCollectionWrapper
implements List {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Object[] fValue;

    public Array() {
    }

    public Array(Object[] anArray) {
        this.value(anArray);
    }

    public Array(int aSize) {
        this.value(new Object[aSize]);
    }

    public Array(Object anObject) {
        this.value(Array.array(anObject));
    }

    public Array(Object anObj1, Object anObj2) {
        this.value(Array.array(anObj1, anObj2));
    }

    public Array(Object anObj1, Object anObj2, Object anObj3) {
        this.value(Array.array(anObj1, anObj2, anObj3));
    }

    public Array(Object anObj1, Object anObj2, Object anObj3, Object anObj4) {
        this.value(Array.array(anObj1, anObj2, anObj3, anObj4));
    }

    public Object accumulate(AccumulatingFunction aFunction, Object initValue) {
        return this.accumulate(new ArrayIterator(this.value()), aFunction, initValue);
    }

    public void add(int i, Object obj) {
        if (i >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(i) + " >= " + this.value().length);
        }
        this.value()[i] = obj;
    }

    public boolean add(Object obj) {
        throw new ShouldNotImplement();
    }

    public boolean addAll(int i, Collection c) {
        throw new ShouldNotImplement();
    }

    public boolean addAll(Object obj) {
        throw new ShouldNotImplement();
    }

    public boolean addAll(Collection c) {
        throw new ShouldNotImplement();
    }

    public void apply(VoidFunction aFunction) {
        super.apply(new ArrayIterator(this.value()), aFunction);
    }

    public void applyWith(Object[] anArray2, TwoValuedFunction aFunction) {
        super.applyWith(new ArrayIterator(this.value()), new ArrayIterator(anArray2), aFunction);
    }

    public void applyWithIndex(TwoValuedIntFunction aFunction) {
        super.applyWithIndex(new ArrayIterator(this.value()), aFunction);
    }

    public static Object[] array(int anInt) {
        return new Object[anInt];
    }

    public static Object[] array(Object anObject) {
        Object[] anArray = new Object[]{anObject};
        return anArray;
    }

    public static Object[] array(Object anObj1, Object anObj2) {
        Object[] anArray = new Object[]{anObj1, anObj2};
        return anArray;
    }

    public static Object[] array(Object anObj1, Object anObj2, Object anObj3) {
        Object[] anArray = new Object[]{anObj1, anObj2};
        anArray[2] = anObj3;
        return anArray;
    }

    public static Object[] array(Object anObj1, Object anObj2, Object anObj3, Object anObj4) {
        Object[] anArray = new Object[]{anObj1, anObj2};
        anArray[2] = anObj3;
        anArray[3] = anObj4;
        return anArray;
    }

    public Object at(int index) {
        if (index >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.value().length);
        }
        try {
            return this.value()[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.size()) {
            this.value()[i] = null;
            ++i;
        }
    }

    public Object[] collect(Function aFunction) {
        Object[] newArray = new Object[this.value().length];
        int i = 0;
        while (i < this.value().length) {
            newArray[i] = aFunction.value(this.value()[i]);
            ++i;
        }
        return newArray;
    }

    public void commaSpaceInBetweenOn(StringBuffer aBuffer) {
        super.inBetweenOn(new ArrayIterator(this.value()), null, ", ", aBuffer);
    }

    public Object[] concatenate(Object[] anArray2) {
        Object[] anArray = new Object[this.value().length + anArray2.length];
        int i = 0;
        while (i < this.value().length - 1) {
            anArray[i] = this.value()[i];
            ++i;
        }
        i = this.value().length + 1;
        while (i < this.value().length + anArray2.length - 1) {
            anArray[i] = anArray2[i];
            ++i;
        }
        return anArray;
    }

    public boolean conform(BooleanFunction aFunction) {
        return super.conform(new ArrayIterator(this.value()), aFunction);
    }

    public boolean contains(Object anObject) {
        return this.indexOf(anObject) >= 0;
    }

    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public Object[] copy() {
        return this.copy(0);
    }

    public Object[] copy(int start) {
        return this.copy(start, this.size() - 1);
    }

    public Object[] copy(int start, int end) {
        Object[] aNewArray = Array.array(this.size());
        if (start > end || start < 0 || end < 0) {
            return aNewArray;
        }
        int m = Math.max(end, this.size() - 1);
        int i = start;
        while (i <= m) {
            aNewArray[i] = this.at(i);
            ++i;
        }
        return aNewArray;
    }

    public void copyInto(Object[] anArray) {
        int i = this.value().length;
        while (i-- > 0) {
            anArray[i] = this.value()[i];
        }
    }

    public Object detect(BooleanFunction aFunction) {
        return super.detect(new ArrayIterator(this.value()), aFunction);
    }

    public Iterator dual(Object[] anArray2) {
        return new MultiIterator(this.value(), anArray2);
    }

    public boolean eq(Object[] array2) {
        if (this.value() == array2) {
            return true;
        }
        if (this.value().length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < this.value().length) {
            if (!this.value()[i].equals(array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Array)) {
            return false;
        }
        Iterator e1 = this.iterator();
        Iterator e2 = ((Array)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public Object first() {
        return this.value()[0];
    }

    public Object get(int index) {
        return this.at(index);
    }

    public int hashCode() {
        int hashCode = 1;
        int i = 0;
        while (i < this.size()) {
            hashCode = 31 * hashCode + (this.value()[i] == null ? 0 : this.value()[i].hashCode());
            ++i;
        }
        return hashCode;
    }

    public void inBetweenOn(Function aFunction, String aString, StringBuffer aBuffer) {
        super.inBetweenOn(new ArrayIterator(this.value()), aFunction, aString, aBuffer);
    }

    public void inBetweenOn(String aString, StringBuffer aBuffer) {
        this.inBetweenOn(new ArrayIterator(this.value()), null, aString, aBuffer);
    }

    public int indexOf(Object anObject) {
        return this.indexOf(anObject, 0);
    }

    public int indexOf(Object anObject, int index) {
        int i = index;
        while (i < this.value().length) {
            if (anObject.equals(this.value()[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.conform(new BooleanFunction(){

            public boolean value(Object anObject) {
                return anObject == null;
            }
        });
    }

    public Iterator iterator() {
        return new ArrayIterator(this.value());
    }

    public Object last() {
        return this.value()[this.value().length - 1];
    }

    public int lastIndexOf(Object anObject) {
        if (anObject == null) {
            int i = this.size() - 1;
            while (i >= 0) {
                if (this.value()[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = this.size() - 1;
            while (i >= 0) {
                if (anObject.equals(this.value()[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        throw new UnderConstruction();
    }

    public ListIterator listIterator(int i) {
        throw new UnderConstruction();
    }

    public Iterator pairwise() {
        return new PairwiseIterator(this.value());
    }

    public void put(Object obj, int index) {
        this.set(obj, index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size());
        }
    }

    public Object remove(int i) {
        if (i >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(i) + " >= " + this.value().length);
        }
        Object obj = this.value()[i];
        return obj;
    }

    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            if (o.equals(this.value()[i])) {
                this.value()[i] = null;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        Iterator it = c.iterator();
        boolean modified = true;
        while (it.hasNext()) {
            boolean bl = modified = modified && this.remove(it.next());
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        int i = 0;
        while (i < this.size()) {
            if (c.contains(this.value()[i])) {
                this.value()[i] = null;
                modified = true;
            }
            ++i;
        }
        return modified;
    }

    public Object[] reverse() {
        int l = this.value().length;
        Object[] anArray = new Object[l];
        int i = 0;
        while (i < l) {
            anArray[l - (i + 1)] = this.value()[i];
            ++i;
        }
        return anArray;
    }

    public Enumeration reverseEnumerator() {
        return new ReverseArrayEnumerator(this.value());
    }

    public Object[] select(BooleanFunction aFunction) {
        Object[] newArray = new Object[this.value().length];
        int j = 0;
        int i = 0;
        while (i < this.value().length) {
            if (aFunction.value(this.value()[i])) {
                newArray[j++] = this.value()[i];
            }
            ++i;
        }
        Object[] finalArray = new Object[j + 1];
        System.arraycopy(newArray, 0, finalArray, 0, j);
        return finalArray;
    }

    public Object set(int index, Object element) {
        this.rangeCheck(index);
        this.value()[index] = element;
        return element;
    }

    public void set(Object obj, int index) {
        if (index >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.value().length);
        }
        this.value()[index] = obj;
    }

    public void setAll(Object obj) {
        this.applyWithIndex(new TwoValuedIntFunction(){

            public Object value(Object anObject, int i) {
                Array.this.set(anObject, i);
                return anObject;
            }
        });
    }

    public int size() {
        return this.value().length;
    }

    public void spaceInBetweenOn(StringBuffer aBuffer) {
        super.inBetweenOn(new ArrayIterator(this.value()), null, " ", aBuffer);
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        ArrayList<Object> aList = new ArrayList<Object>();
        int i = fromIndex;
        while (i < toIndex) {
            aList.add(this.value()[i]);
            ++i;
        }
        return aList;
    }

    public Object[] toArray() {
        return this.copy();
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])java.lang.reflect.Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        while (i < size) {
            a[i] = this.value()[i];
            ++i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public List toList() {
        int max = this.value().length;
        ArrayList<Object> aList = new ArrayList<Object>(max);
        int i = 0;
        while (i < max) {
            aList.add(this.value()[i]);
            ++i;
        }
        return aList;
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(ClassShortName.name(this));
        aBuffer.append(" {");
        this.commaSpaceInBetweenOn(aBuffer);
        aBuffer.append("}");
        return aBuffer.toString();
    }

    public StSet toStSet() {
        StSet aSet = new StSet();
        ArrayIterator e = new ArrayIterator(this.value());
        while (e.hasNext()) {
            aSet.add(e.next());
        }
        return aSet;
    }

    public Vector toVector() {
        int max = this.value().length;
        Vector<Object> aVector = new Vector<Object>(max);
        int i = 0;
        while (i < max) {
            aVector.addElement(this.value()[i]);
            ++i;
        }
        return aVector;
    }

    public Object[] value() {
        if (this.fValue == null) {
            this.fValue = new Object[0];
        }
        return this.fValue;
    }

    public void value(Object[] aValue) {
        this.fValue = aValue;
    }
}

