/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.ReadBeyondEnd;
import java.util.Enumeration;
import java.util.Vector;

public class ArrayReader
implements Enumeration {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Object lock;
    private Object[] array = new Object[0];
    private int length;
    private int next = -1;

    protected ArrayReader() {
        this.lock = this;
    }

    public ArrayReader(Object[] anArray) {
        this.lock = this;
        this.array = anArray;
        this.length = anArray.length;
    }

    public boolean atEnd() {
        if (this.array.length == 0) {
            return true;
        }
        Object anObject = this.read();
        if (!(anObject instanceof ReadBeyondEnd)) {
            this.backup();
        }
        return anObject instanceof ReadBeyondEnd;
    }

    public long backup() {
        return this.skip(-1L);
    }

    public void close() {
        this.array = new Object[0];
        this.reset();
    }

    public boolean hasMoreElements() {
        return !this.atEnd();
    }

    public Object next() {
        Object anObject = this.read();
        if (anObject instanceof ReadBeyondEnd) {
            throw new RuntimeException("read past end of array");
        }
        return anObject;
    }

    public Object nextElement() {
        return this.next();
    }

    public Object peek() {
        Object anObject = this.read();
        if (anObject instanceof ReadBeyondEnd) {
            throw new RuntimeException("peeking past end of array");
        }
        this.backup();
        return anObject;
    }

    private Object read() {
        Object object = this.lock;
        synchronized (object) {
            if (this.next >= this.length - 1) {
                return new ReadBeyondEnd();
            }
            ++this.next;
            return this.array[this.next];
        }
    }

    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.next = 0;
        }
    }

    public long skip() {
        return this.skip(1L);
    }

    public long skip(long ns) {
        Object object = this.lock;
        synchronized (object) {
            if (ns > 0L && this.next >= this.length) {
                return 0L;
            }
            long n = Math.min((long)(this.length - this.next), ns);
            int oldNext = this.next;
            this.next = (int)((long)this.next + n);
            if (this.next < 0) {
                this.next = -1;
                return oldNext;
            }
            return n;
        }
    }

    public int skipUpTo(Object anObject) {
        int i = 0;
        while (!this.atEnd()) {
            Object nextObject = this.next();
            if (nextObject.equals(anObject)) {
                this.backup();
                break;
            }
            ++i;
        }
        return i;
    }

    public Object[] upTo(Object anObject) {
        int i = 0;
        Vector<Object> aVector = new Vector<Object>();
        while (!this.atEnd()) {
            Object nextObject = this.next();
            aVector.addElement(nextObject);
            if (nextObject.equals(anObject)) {
                this.backup();
                break;
            }
            ++i;
        }
        return new ListWrapper(aVector).toArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] upToEnd() {
        int i = 0;
        if (this.atEnd()) return new Object[0];
        Object[] anArray = new Object[this.length - this.next + 1];
        while (!this.atEnd()) {
            anArray[i] = this.next();
            ++i;
        }
        return anArray;
    }
}

