/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.BagEnumerator;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.DictionaryEnumerator;
import com.ibm.ObjectQuery.crud.util.DictionaryKeyEnumerator;
import com.ibm.ObjectQuery.crud.util.SetEnumerator;
import com.ibm.ObjectQuery.crud.util.StCollection;
import com.ibm.ObjectQuery.crud.util.StDictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class Bag
extends StCollection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private StDictionary occurrenceDictionary;

    public Bag() {
        this.initialize(Bag.minimumSize());
    }

    public Bag(int anInteger) {
        this.initialize(Math.max(anInteger + anInteger, Bag.minimumSize()));
    }

    public Bag add(char aChar) {
        this.add(new Character(aChar), 1);
        return this;
    }

    public boolean add(char aChar, int occurrences) {
        return this.add(new Character(aChar), occurrences);
    }

    public Bag add(int anInt) {
        this.add(new Integer(anInt), 1);
        return this;
    }

    public boolean add(int anInt, int occurrences) {
        return this.add(new Integer(anInt), occurrences);
    }

    public boolean add(Object newObject) {
        return this.add(newObject, 1);
    }

    public boolean add(Object newObject, int occurrences) {
        Object anInteger = this.getOccurrenceDictionary().get(newObject);
        int anInt = this.unwrapInteger(anInteger);
        this.getOccurrenceDictionary().put(newObject, anInt + occurrences);
        return true;
    }

    public Bag add(boolean aBoolean) {
        this.add(new Boolean(aBoolean), 1);
        return this;
    }

    public int[] asIntArray() {
        int aSize = this.numberOfElements();
        int[] answer = new int[aSize];
        int i = 0;
        Enumeration e = this.occurrenceElements();
        while (e.hasMoreElements()) {
            answer[i] = (Integer)e.nextElement();
            ++i;
        }
        return answer;
    }

    public Enumeration associationElements() {
        return new SetEnumerator(this.getOccurrenceDictionary());
    }

    public Vector asVector() {
        Vector answer = new Vector(this.numberOfElements());
        Enumeration e = this.occurrenceElements();
        while (e.hasMoreElements()) {
            answer.addElement(e.nextElement());
        }
        return answer;
    }

    public float avg() {
        return this.sum() / this.numberOfElements();
    }

    public void clear() {
        this.occurrenceDictionary.clear();
    }

    public Enumeration elements() {
        return new BagEnumerator(this);
    }

    public StDictionary getOccurrenceDictionary() {
        return this.occurrenceDictionary;
    }

    public boolean includes(char aChar) {
        return this.getOccurrenceDictionary().includesKey(aChar);
    }

    public boolean includes(int anInt) {
        return this.getOccurrenceDictionary().includesKey(anInt);
    }

    public boolean includes(Object anObject) {
        return this.getOccurrenceDictionary().includesKey(anObject);
    }

    public boolean includes(boolean aBoolean) {
        return this.getOccurrenceDictionary().includesKey(aBoolean);
    }

    public void initialize(int anInt) {
        super.initialize(anInt);
        this.occurrenceDictionary = new StDictionary(anInt);
    }

    public boolean isEmpty() {
        return this.getOccurrenceDictionary().isEmpty();
    }

    public Iterator iterator() {
        return new BagEnumerator(this);
    }

    public Enumeration keyElements() {
        return new DictionaryKeyEnumerator(this.getOccurrenceDictionary());
    }

    public int max() {
        int max = 0;
        Enumeration e = this.occurrenceElements();
        while (e.hasMoreElements()) {
            max = Math.max(max, (Integer)e.nextElement());
        }
        return max;
    }

    public int min() {
        int min = 0;
        Enumeration e = this.occurrenceElements();
        if (e.hasMoreElements()) {
            min = (Integer)e.nextElement();
        }
        while (e.hasMoreElements()) {
            min = Math.min(min, (Integer)e.nextElement());
        }
        return min;
    }

    public static int minimumSize() {
        return 11;
    }

    public int numberOfElements() {
        return this.occurrenceDictionary.size();
    }

    public Enumeration occurrenceElements() {
        return new DictionaryEnumerator(this.getOccurrenceDictionary());
    }

    public int occurrencesOf(char aChar) {
        Object anInteger = this.getOccurrenceDictionary().get(aChar);
        return this.unwrapInteger(anInteger);
    }

    public int occurrencesOf(int anInt) {
        Object anInteger = this.getOccurrenceDictionary().get(anInt);
        return this.unwrapInteger(anInteger);
    }

    public int occurrencesOf(Object anObject) {
        Object anInteger = this.getOccurrenceDictionary().get(anObject);
        return this.unwrapInteger(anInteger);
    }

    public int occurrencesOf(boolean aBoolean) {
        Object anInteger = this.getOccurrenceDictionary().get(aBoolean);
        return this.unwrapInteger(anInteger);
    }

    public void rehash() {
        this.getOccurrenceDictionary().rehash();
    }

    public boolean remove(Object oldObject) {
        int anInt = this.occurrencesOf(oldObject);
        if (anInt > 1) {
            this.getOccurrenceDictionary().put(oldObject, anInt--);
            return false;
        }
        this.getOccurrenceDictionary().removeKey(oldObject);
        return true;
    }

    private void setOccurenceDictionary(StDictionary aDictionary) {
        this.occurrenceDictionary = aDictionary;
    }

    public int size() {
        int aCount = 0;
        Enumeration e = this.getOccurrenceDictionary().elements();
        while (e.hasMoreElements()) {
            aCount += ((Integer)e.nextElement()).intValue();
        }
        return aCount;
    }

    public int sum() {
        int sum = 0;
        Enumeration e = this.occurrenceElements();
        while (e.hasMoreElements()) {
            sum += ((Integer)e.nextElement()).intValue();
        }
        return sum;
    }

    public synchronized String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(ClassShortName.name(this));
        if (this.numberOfElements() - 1 < 100) {
            this.occurrenceDictionary.toStringForSmallOn(aBuffer);
        } else {
            this.occurrenceDictionary.toStringForLargeOn(aBuffer);
        }
        return aBuffer.toString();
    }

    private int unwrapInteger(Object anInteger) {
        return anInteger == null ? 0 : (Integer)anInteger;
    }
}

